/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.generic;

import org.eclipse.wb.gef.tree.TreeEditPart;
import org.eclipse.wb.internal.core.model.nonvisual.FlowContainerGroupInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.model.generic.FlowContainerAbstractGefTest;
import org.eclipse.wb.tests.designer.core.model.generic.FlowContainerModelTest;
import org.junit.Test;

public class FlowContainerGroupGefTest
extends FlowContainerAbstractGefTest {
    @Test
    public void test_group_hierarchy() throws Exception {
        this.prepareFlowPanel();
        ContainerInfo mainPanel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      FlowPanel panel = new FlowPanel();", "      add(panel);", "      {", "        JButton buttonA = new JButton();", "        panel.add(buttonA);", "      }", "      {", "        JButton buttonB = new JButton();", "        panel.add(buttonB);", "      }", "    }", "  }", "}");
        ContainerInfo panel = (ContainerInfo)mainPanel.getChildrenComponents().get(0);
        FlowContainerGroupInfo group = (FlowContainerGroupInfo)panel.getChildren(FlowContainerGroupInfo.class).get(0);
        ComponentInfo buttonA = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo buttonB = (ComponentInfo)panel.getChildrenComponents().get(1);
        TreeEditPart panelPart = this.tree.getEditPart(panel);
        TreeEditPart buttonApart = this.tree.getEditPart(buttonA);
        TreeEditPart buttonBpart = this.tree.getEditPart(buttonB);
        TreeEditPart groupPart = this.tree.getEditPart(group);
        FlowContainerGroupGefTest.assertSame((Object)buttonApart.getParent(), (Object)groupPart);
        FlowContainerGroupGefTest.assertSame((Object)buttonBpart.getParent(), (Object)groupPart);
        FlowContainerGroupGefTest.assertSame((Object)groupPart.getParent(), (Object)panelPart);
    }

    @Test
    public void test_group_add() throws Exception {
        this.prepareFlowPanel();
        ContainerInfo mainPanel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      FlowPanel panel = new FlowPanel();", "      add(panel);", "      {", "        JButton existingButton = new JButton();", "        panel.add(existingButton);", "      }", "    }", "    {", "      JButton rootButton = new JButton('A');", "      add(rootButton, BorderLayout.NORTH);", "    }", "  }", "}");
        ContainerInfo panel = (ContainerInfo)mainPanel.getChildrenComponents().get(0);
        ComponentInfo rootButton = (ComponentInfo)mainPanel.getChildrenComponents().get(1);
        FlowContainerGroupInfo group = (FlowContainerGroupInfo)panel.getChildren(FlowContainerGroupInfo.class).get(0);
        this.tree.startDrag(rootButton);
        this.tree.dragOn(group);
        this.tree.assertFeedback_on(group);
        this.tree.assertCommandNotNull();
        this.tree.endDrag();
        this.tree.assertFeedback_empty();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      FlowPanel panel = new FlowPanel();", "      add(panel);", "      {", "        JButton existingButton = new JButton();", "        panel.add(existingButton);", "      }", "      {", "        JButton rootButton = new JButton('A');", "        panel.add(rootButton);", "      }", "    }", "  }", "}");
    }

    @Override
    protected void prepareFlowPanel() throws Exception {
        FlowContainerModelTest.prepareFlowPanel_classes();
        FlowContainerGroupGefTest.setFileContentSrc("test/FlowPanel.wbp-component.xml", FlowContainerGroupGefTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='add'>", "      <parameter type='java.awt.Component' child='true'/>", "    </method>", "  </methods>", "  <parameters>", "    <parameter name='flowContainer'>true</parameter>", "    <parameter name='flowContainer.horizontal'>true</parameter>", "    <parameter name='flowContainer.association'>%parent%.add(%child%)</parameter>", "    <parameter name='flowContainer.component'>java.awt.Component</parameter>", "    <parameter name='flowContainer.reference'>java.awt.Component</parameter>", "    <parameter name='flowContainer.group'>Group</parameter>", "  </parameters>", "</component>"));
        FlowContainerGroupGefTest.waitForAutoBuild();
    }
}

