/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.parser;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.description.Description;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.ObjectInfoVisitor;
import org.eclipse.wb.internal.core.model.clipboard.IClipboardCreationSupport;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMementoTransfer;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ToolkitDescriptionJava;
import org.eclipse.wb.internal.core.model.description.helpers.EditorStateLoadingContext;
import org.eclipse.wb.internal.core.model.description.helpers.ILoadingContext;
import org.eclipse.wb.internal.core.model.generic.FlowContainer;
import org.eclipse.wb.internal.core.model.generic.FlowContainerFactory;
import org.eclipse.wb.internal.core.model.generic.SimpleContainer;
import org.eclipse.wb.internal.core.model.generic.SimpleContainerFactory;
import org.eclipse.wb.internal.core.model.util.GlobalStateJava;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.parser.JavaInfoParser;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.BodyDeclarationTarget;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.swing.model.layout.absolute.AbsoluteLayoutInfo;
import org.eclipse.wb.tests.designer.core.PreferencesRepairer;
import org.eclipse.wb.tests.designer.core.model.parser.AbstractJavaInfoRelatedTest;
import org.junit.After;
import org.junit.Before;

public abstract class AbstractJavaInfoTest
extends AbstractJavaInfoRelatedTest {
    protected boolean m_ignoreCompilationProblems;
    protected boolean m_waitForAutoBuild;
    protected JavaInfo m_lastParseInfo;
    protected EditorState m_lastState;
    protected ILoadingContext m_lastLoadingContext;
    protected ClassLoader m_lastLoader;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.m_ignoreCompilationProblems = false;
        this.m_waitForAutoBuild = false;
        AbstractJavaInfoTest.useStrictEvaluationMode(true);
        this.configureToolkits();
        if (m_javaProject != null) {
            m_javaProject.setOptions(null);
        }
    }

    protected void configureToolkits() {
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.disposeLastModel();
        this.tearDown_afterLastModelDispose();
        super.tearDown();
    }

    protected void tearDown_afterLastModelDispose() throws Exception {
    }

    protected final void disposeLastModel() throws Exception {
        if (this.m_lastParseInfo != null) {
            this.m_lastParseInfo.refresh_dispose();
            this.m_lastParseInfo.getBroadcastObject().dispose();
            this.m_lastParseInfo = null;
        }
        if (this.m_lastState != null) {
            GlobalStateJava.deactivate();
            this.m_lastState = null;
            this.m_lastLoadingContext = null;
        }
        this.m_lastLoader = null;
    }

    protected static void useStrictEvaluationMode(boolean value) {
        DesignerPlugin.getDefault().getPreferenceStore().setValue("evaluation.strictMode", value);
    }

    protected static TypeDeclaration getTypeDeclaration(JavaInfo javaInfo) {
        ASTNode node = javaInfo.getCreationSupport().getNode();
        return AstNodeUtils.getEnclosingType((ASTNode)node);
    }

    protected static BodyDeclaration getBodyDeclaration(JavaInfo javaInfo, int index) {
        ASTNode node = javaInfo.getCreationSupport().getNode();
        TypeDeclaration typeDeclaration = AstNodeUtils.getEnclosingType((ASTNode)node);
        return (BodyDeclaration)DomGenerics.bodyDeclarations((TypeDeclaration)typeDeclaration).get(index);
    }

    protected static Block getBlock(JavaInfo javaInfo, int ... indexes) {
        return (Block)AbstractJavaInfoTest.getStatement(javaInfo, indexes);
    }

    protected static Block getBlock(JavaInfo javaInfo, String methodSignature, int ... indexes) {
        return (Block)AbstractJavaInfoTest.getStatement(javaInfo, methodSignature, indexes);
    }

    protected static Statement getStatement(JavaInfo javaInfo, String methodSignature, int ... indexes) {
        TypeDeclaration typeDeclaration = JavaInfoUtils.getTypeDeclaration((JavaInfo)javaInfo);
        MethodDeclaration methodDeclaration = AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)methodSignature);
        Assert.isNotNull((Object)methodDeclaration, (String)"no %s in %s", (Object[])new Object[]{methodSignature, typeDeclaration});
        return AbstractJavaInfoTest.getStatement(methodDeclaration.getBody(), indexes);
    }

    protected static void assertTarget(StatementTarget target, Block expectedBlock, Statement expectedStatement, boolean expectedBefore) {
        StatementTarget expectedTarget = new StatementTarget(expectedBlock, expectedStatement, expectedBefore);
        AbstractJavaInfoTest.assertEquals((Object)expectedTarget.toString(), (Object)target.toString());
    }

    protected static NodeTarget getNodeStatementTarget(JavaInfo javaInfo, boolean before, int ... indexes) {
        return new NodeTarget(AbstractJavaInfoTest.getStatementTarget(javaInfo, before, indexes));
    }

    protected static NodeTarget getNodeStatementTarget(JavaInfo javaInfo, String methodSignature, boolean before, int ... indexes) {
        StatementTarget statementTarget = AbstractJavaInfoTest.getStatementTarget(javaInfo, methodSignature, before, indexes);
        return new NodeTarget(statementTarget);
    }

    protected static NodeTarget getNodeBlockTarget(JavaInfo javaInfo, String methodSignature, boolean before, int ... indexes) {
        StatementTarget statementTarget = AbstractJavaInfoTest.getBlockTarget(javaInfo, methodSignature, before, indexes);
        return new NodeTarget(statementTarget);
    }

    protected static NodeTarget getNodeBlockTarget(JavaInfo javaInfo, boolean before, int ... indexes) {
        return new NodeTarget(AbstractJavaInfoTest.getBlockTarget(javaInfo, before, indexes));
    }

    protected static NodeTarget getNodeBodyDeclarationTarget(JavaInfo javaInfo, boolean before, int index) {
        return new NodeTarget(AbstractJavaInfoTest.getBodyDeclarationTarget(javaInfo, before, index));
    }

    protected static NodeTarget getNodeTypeDeclarationTarget(JavaInfo javaInfo, boolean before) {
        return new NodeTarget(AbstractJavaInfoTest.getTypeDeclarationTarget(javaInfo, before));
    }

    protected static StatementTarget getStatementTarget(JavaInfo javaInfo, boolean before, int ... indexes) {
        Statement targetStatement = AbstractJavaInfoTest.getStatement(javaInfo, indexes);
        return new StatementTarget(targetStatement, before);
    }

    protected static StatementTarget getBlockTarget(JavaInfo javaInfo, boolean before, int ... indexes) {
        Block targetBlock = (Block)AbstractJavaInfoTest.getStatement(javaInfo, indexes);
        return new StatementTarget(targetBlock, before);
    }

    protected static StatementTarget getStatementTarget(JavaInfo javaInfo, String methodSignature, boolean before, int ... indexes) {
        Statement targetStatement = AbstractJavaInfoTest.getStatement(javaInfo, methodSignature, indexes);
        return new StatementTarget(targetStatement, before);
    }

    protected static StatementTarget getBlockTarget(JavaInfo javaInfo, String methodSignature, boolean before, int ... indexes) {
        Block targetBlock = (Block)AbstractJavaInfoTest.getStatement(javaInfo, methodSignature, indexes);
        return new StatementTarget(targetBlock, before);
    }

    protected static void assertStatementTarget(JavaInfo javaInfo, Block expectedBlock, Statement expectedStatement, boolean expectedBefore) throws Exception {
        VariableSupport variableSupport = javaInfo.getVariableSupport();
        StatementTarget target = variableSupport.getStatementTarget();
        AbstractJavaInfoTest.assertTarget(target, expectedBlock, expectedStatement, expectedBefore);
    }

    protected static BodyDeclarationTarget getBodyDeclarationTarget(JavaInfo javaInfo, boolean before, int index) {
        BodyDeclaration bodyDeclaration = AbstractJavaInfoTest.getBodyDeclaration(javaInfo, index);
        return new BodyDeclarationTarget(bodyDeclaration, before);
    }

    protected static BodyDeclarationTarget getTypeDeclarationTarget(JavaInfo javaInfo, boolean before) {
        TypeDeclaration typeDeclaration = AbstractJavaInfoTest.getTypeDeclaration(javaInfo);
        return new BodyDeclarationTarget(typeDeclaration, before);
    }

    protected static void assertNodes(AstEditor editor, List<ASTNode> nodes, String[] expectedNodes) throws Exception {
        AbstractJavaInfoTest.assertEquals((long)expectedNodes.length, (long)nodes.size());
        int i = 0;
        while (i < expectedNodes.length) {
            String expectedSource = expectedNodes[i];
            String actualSource = editor.getSource(nodes.get(i));
            AbstractJavaInfoTest.assertEquals((Object)expectedSource, (Object)actualSource);
            ++i;
        }
    }

    protected static void assert_creation(JavaInfo root) throws Exception {
        AbstractJavaInfoTest.assert_isCleanHierarchy(root);
        root.refresh();
        root.accept(new ObjectInfoVisitor(){

            public void endVisit(ObjectInfo objectInfo) throws Exception {
                if (!(objectInfo instanceof AbsoluteLayoutInfo) && objectInfo instanceof JavaInfo) {
                    JavaInfo javaInfo = (JavaInfo)objectInfo;
                    AbstractJavaInfoTest.assertNotNull((String)"Object expected.", (Object)javaInfo.getObject());
                }
            }
        });
        root.refresh_dispose();
        AbstractJavaInfoTest.assert_isCleanHierarchy(root);
    }

    protected static void assert_isCleanHierarchy(JavaInfo root) throws Exception {
        root.accept(new ObjectInfoVisitor(){

            public void endVisit(ObjectInfo objectInfo) throws Exception {
                if (objectInfo instanceof JavaInfo) {
                    JavaInfo javaInfo = (JavaInfo)objectInfo;
                    AbstractJavaInfoTest.assertNull((Object)javaInfo.getObject());
                }
            }
        });
    }

    public static void assertClipboardSource(JavaInfo javaInfo, String expectedSource) throws Exception {
        IClipboardCreationSupport clipboardCreationSupport = javaInfo.getCreationSupport().getClipboard();
        CreationSupport creationSupport = clipboardCreationSupport.create(javaInfo);
        String creationSource = creationSupport.add_getSource(null);
        AbstractJavaInfoTest.assertEquals((Object)expectedSource, (Object)creationSource);
    }

    public static JavaInfoMemento recodeMemento(JavaInfoMemento memento) throws Exception {
        byte[] bytes = JavaInfoMementoTransfer.convertObjectToBytes((Object)memento);
        return (JavaInfoMemento)JavaInfoMementoTransfer.convertBytesToObject((byte[])bytes);
    }

    public static <T extends JavaInfo> void doCopyPaste(final T source, final PasteProcedure<T> pasteProcedure) throws Exception {
        final JavaInfoMemento memento = JavaInfoMemento.createMemento(source);
        ExecutionUtils.run(source, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                JavaInfo copy = memento.create(source);
                pasteProcedure.run(copy);
                memento.apply();
            }
        });
    }

    public final JavaInfo parseSource(String packageName, String unitName, String unitSource) throws Exception {
        ICompilationUnit unit = this.createModelCompilationUnit(packageName, unitName, unitSource);
        return this.parseCompilationUnit(unit);
    }

    public final JavaInfo parseCompilationUnit(ICompilationUnit unit) throws Exception {
        if (this.m_waitForAutoBuild) {
            AbstractJavaInfoTest.waitForAutoBuild();
        }
        if (!this.m_ignoreCompilationProblems) {
            IProblem[] problems;
            AstEditor editor = new AstEditor(unit);
            IProblem[] iProblemArray = problems = editor.getAstUnit().getProblems();
            int n = problems.length;
            int n2 = 0;
            while (n2 < n) {
                IProblem problem = iProblemArray[n2];
                Assert.isTrue((!problem.isError() ? 1 : 0) != 0, (String)(problem.getMessage() + " at line " + problem.getSourceLineNumber()));
                ++n2;
            }
        }
        this.m_lastParseInfo = JavaInfoParser.parse((ICompilationUnit)unit);
        this.m_lastEditor = this.m_lastParseInfo.getEditor();
        this.m_lastState = EditorState.get((AstEditor)this.m_lastEditor);
        this.m_lastLoadingContext = EditorStateLoadingContext.get((EditorState)this.m_lastState);
        this.m_lastLoader = this.m_lastState.getEditorLoader();
        return this.m_lastParseInfo;
    }

    public void refresh() throws Exception {
        this.m_lastParseInfo.refresh();
    }

    public static void setText_withAlwaysRename(JavaInfo component, String text) throws Exception {
        ToolkitDescriptionJava toolkit = component.getDescription().getToolkit();
        PreferencesRepairer preferencesRepairer = new PreferencesRepairer(toolkit.getPreferences());
        try {
            preferencesRepairer.setValue("textVariable.mode", 0);
            preferencesRepairer.setValue("textVariable.template", "${text}${class_name}");
            component.getPropertyByTitle("text").setValue((Object)text);
        }
        finally {
            preferencesRepairer.restore();
        }
    }

    public static void assertVisibleInTree(final ObjectInfo child, boolean expected) throws Exception {
        List children = child.getParent().getPresentation().getChildrenTree();
        if (expected) {
            ((ListAssert)Assertions.assertThat((List)children).as(new Description(){

                public String value() {
                    return "Should be in children: " + String.valueOf(child);
                }
            })).contains((Object[])new ObjectInfo[]{child});
        } else {
            ((ListAssert)Assertions.assertThat((List)children).as(new Description(){

                public String value() {
                    return "Should not be in children: " + String.valueOf(child);
                }
            })).doesNotContain((Object[])new ObjectInfo[]{child});
        }
    }

    public static void assertVisibleInGraphical(final ObjectInfo child, boolean expected) throws Exception {
        List children = child.getParent().getPresentation().getChildrenGraphical();
        if (expected) {
            ((ListAssert)Assertions.assertThat((List)children).as(new Description(){

                public String value() {
                    return "Should be in children: " + String.valueOf(child);
                }
            })).contains((Object[])new ObjectInfo[]{child});
        } else {
            ((ListAssert)Assertions.assertThat((List)children).as(new Description(){

                public String value() {
                    return "Should not be in children: " + String.valueOf(child);
                }
            })).doesNotContain((Object[])new ObjectInfo[]{child});
        }
    }

    public static void assertVisible(ObjectInfo child, boolean expected) throws Exception {
        AbstractJavaInfoTest.assertVisibleInGraphical(child, expected);
        AbstractJavaInfoTest.assertVisibleInTree(child, expected);
    }

    public static void flowContainer_CREATE(final JavaInfo container, final Object object, final Object reference) throws Exception {
        ExecutionUtils.run((ObjectInfo)container, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                FlowContainer flowContainer = (FlowContainer)new FlowContainerFactory(container, false).get().get(0);
                flowContainer.command_CREATE(object, reference);
            }
        });
    }

    public static void flowContainer_MOVE(final JavaInfo container, final Object object, final Object reference) throws Exception {
        ExecutionUtils.run((ObjectInfo)container, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                FlowContainer flowContainer = (FlowContainer)new FlowContainerFactory(container, false).get().get(0);
                flowContainer.command_MOVE(object, reference);
            }
        });
    }

    public static void simpleContainer_CREATE(JavaInfo container, Object object) throws Exception {
        SimpleContainer simpleContainer = (SimpleContainer)new SimpleContainerFactory(container, false).get().get(0);
        simpleContainer.command_CREATE(object);
    }

    public static void simpleContainer_ADD(JavaInfo container, Object object) throws Exception {
        SimpleContainer simpleContainer = (SimpleContainer)new SimpleContainerFactory(container, false).get().get(0);
        simpleContainer.command_ADD(object);
    }

    public static interface PasteProcedure<T> {
        public void run(T var1) throws Exception;
    }
}

