/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.accessor;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.accessor.ExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.FieldAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.IAccessibleExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.IExposableExpressionAccessor;
import org.eclipse.wb.internal.core.model.util.PropertyUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class FieldAccessorTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_fieldAccessor() throws Exception {
        this.defineMyButton();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    button.hgap = 1;", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        GenericProperty property = (GenericProperty)button.getPropertyByTitle("hgap");
        FieldAccessorTest.assertEquals((Object)1, (Object)property.getValue());
        property.setValue((Object)3);
        FieldAccessorTest.assertEquals((Object)3, (Object)property.getValue());
        FieldAccessorTest.assertNotNull((Object)property.getExpression());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    button.hgap = 3;", "    add(button);", "  }", "}");
        property.setValue(Property.UNKNOWN_VALUE);
        FieldAccessorTest.assertEquals((Object)0, (Object)property.getValue());
        FieldAccessorTest.assertNull((Object)property.getExpression());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    add(button);", "  }", "}");
        property.setValue((Object)2);
        FieldAccessorTest.assertEquals((Object)2, (Object)property.getValue());
        FieldAccessorTest.assertNotNull((Object)property.getExpression());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    button.hgap = 2;", "    add(button);", "  }", "}");
    }

    @Test
    public void test_0() throws Exception {
        FieldAccessorTest.setFileContentSrc("test/MyComponent.java", this.getTestSource("public class MyComponent extends JComponent {", "  /**", "  * my documentation", "  */", "  public int field_1 = 1;", "  public double field_2 = 2.0;", "  public MyComponent() {", "  }", "}"));
        FieldAccessorTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new MyComponent());", "  }", "}");
        ComponentInfo myComponent = (ComponentInfo)panel.getChildrenComponents().get(0);
        GenericProperty property = (GenericProperty)myComponent.getPropertyByTitle("field_1");
        List<ExpressionAccessor> accessors = FieldAccessorTest.getGenericPropertyAccessors(property);
        FieldAccessorTest.assertEquals((long)1L, (long)accessors.size());
        FieldAccessor fieldAccessor = (FieldAccessor)accessors.get(0);
        FieldAccessorTest.assertEquals((Object)1, (Object)fieldAccessor.getDefaultValue((JavaInfo)myComponent));
        FieldAccessorTest.assertEquals((Object)"my documentation", (Object)FieldAccessorTest.getPropertyTooltipText((IAdaptable)fieldAccessor, (Property)property));
        FieldAccessorTest.assertNull((Object)fieldAccessor.getAdapter(null));
        IExposableExpressionAccessor exposableAccessor = (IExposableExpressionAccessor)fieldAccessor.getAdapter(IExposableExpressionAccessor.class);
        FieldAccessorTest.assertSame(Integer.TYPE, (Object)exposableAccessor.getValueClass((JavaInfo)myComponent));
        FieldAccessorTest.assertEquals((Object)"field_1", (Object)exposableAccessor.getGetterCode((JavaInfo)myComponent));
        FieldAccessorTest.assertEquals((Object)"field_1 = 123", (Object)exposableAccessor.getSetterCode((JavaInfo)myComponent, "123"));
        property = (GenericProperty)myComponent.getPropertyByTitle("field_2");
        accessors = FieldAccessorTest.getGenericPropertyAccessors(property);
        FieldAccessorTest.assertEquals((long)1L, (long)accessors.size());
        fieldAccessor = (FieldAccessor)accessors.get(0);
        FieldAccessorTest.assertEquals((Object)2.0, (Object)fieldAccessor.getDefaultValue((JavaInfo)myComponent));
        FieldAccessorTest.assertEquals((Object)"field_2", (Object)FieldAccessorTest.getPropertyTooltipText((IAdaptable)fieldAccessor, (Property)property));
        FieldAccessorTest.assertNull((Object)fieldAccessor.getAdapter(null));
        exposableAccessor = (IExposableExpressionAccessor)fieldAccessor.getAdapter(IExposableExpressionAccessor.class);
        FieldAccessorTest.assertSame(Double.TYPE, (Object)exposableAccessor.getValueClass((JavaInfo)myComponent));
        FieldAccessorTest.assertEquals((Object)"field_2", (Object)exposableAccessor.getGetterCode((JavaInfo)myComponent));
        FieldAccessorTest.assertEquals((Object)"field_2 = 12.3", (Object)exposableAccessor.getSetterCode((JavaInfo)myComponent, "12.3"));
    }

    @Test
    public void test_defaultValue() throws Exception {
        FieldAccessorTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public String foo;", "  public MyButton(String s) {", "    foo = s;", "  }", "}"));
        FieldAccessorTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new MyButton('A'));", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property constructorTextProperty = PropertyUtils.getByPath((ObjectInfo)button, (String)"Constructor/s");
        Property fooProperty = button.getPropertyByTitle("foo");
        FieldAccessorTest.assertEquals((Object)"A", (Object)constructorTextProperty.getValue());
        FieldAccessorTest.assertEquals((Object)"A", (Object)fooProperty.getValue());
        constructorTextProperty.setValue((Object)"B");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    add(new MyButton('B'));", "  }", "}");
        FieldAccessorTest.assertEquals((Object)"B", (Object)constructorTextProperty.getValue());
        FieldAccessorTest.assertEquals((Object)"B", (Object)fooProperty.getValue());
    }

    @Test
    public void test_defaultValue_whenReplacedWithPlaceholder() throws Exception {
        FieldAccessorTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public String foo;", "  public MyButton() {", "    throw new IllegalStateException();", "  }", "}"));
        FieldAccessorTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    add(button);", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)FieldAccessorTest.getJavaInfoByName("button");
        Property fooProperty = button.getPropertyByTitle("foo");
        FieldAccessorTest.assertSame((Object)Property.UNKNOWN_VALUE, (Object)fooProperty.getValue());
    }

    @Test
    public void test_separateAssignment() throws Exception {
        this.defineMyButton();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    add(button);", "    button.hgap = 5;", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        GenericProperty property = (GenericProperty)button.getPropertyByTitle("hgap");
        Object buttonObject = button.getObject();
        FieldAccessorTest.assertEquals((long)5L, (long)ReflectionUtils.getFieldInt((Object)buttonObject, (String)"hgap"));
        Assignment oldAssignment = (Assignment)property.getExpression().getParent();
        FieldAccessorTest.assertEquals((Object)"button.hgap = 5", (Object)this.m_lastEditor.getSource((ASTNode)oldAssignment));
        property.setExpression("6", (Object)5);
        Assignment newAssignment = (Assignment)property.getExpression().getParent();
        FieldAccessorTest.assertEquals((Object)"button.hgap = 6", (Object)this.m_lastEditor.getSource((ASTNode)newAssignment));
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    add(button);", "    button.hgap = 6;", "  }", "}");
        FieldAccessorTest.assertSame((Object)oldAssignment, (Object)newAssignment);
    }

    @Test
    public void test_sequence_parse() throws Exception {
        this.defineMyButton();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    add(button);", "    button.hgap = button.vgap = 5;", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        panel.refresh();
        Object buttonObject = button.getObject();
        FieldAccessorTest.assertEquals((long)5L, (long)ReflectionUtils.getFieldInt((Object)buttonObject, (String)"hgap"));
        FieldAccessorTest.assertEquals((long)5L, (long)ReflectionUtils.getFieldInt((Object)buttonObject, (String)"vgap"));
    }

    @Test
    public void test_sequence_modifyLast() throws Exception {
        this.defineMyButton();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    add(button);", "    button.hgap = button.vgap = 5;", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property vgapProperty = button.getPropertyByTitle("vgap");
        FieldAccessorTest.assertEquals((Object)5, (Object)vgapProperty.getValue());
        vgapProperty.setValue((Object)10);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    add(button);", "    button.hgap = 5;", "    button.vgap = 10;", "  }", "}");
        FieldAccessorTest.assertEquals((Object)10, (Object)vgapProperty.getValue());
    }

    @Test
    public void test_sequence_modifyFirst() throws Exception {
        this.defineMyButton();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    add(button);", "    button.hgap = button.vgap = 5;", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property hgapProperty = button.getPropertyByTitle("hgap");
        FieldAccessorTest.assertEquals((Object)5, (Object)hgapProperty.getValue());
        hgapProperty.setValue((Object)10);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    add(button);", "    button.hgap = 10;", "    button.vgap = 5;", "  }", "}");
        FieldAccessorTest.assertEquals((Object)10, (Object)hgapProperty.getValue());
    }

    @Test
    public void test_IAccessibleExpressionAccessor() throws Exception {
        FieldAccessorTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "  public int foo;", "}"));
        FieldAccessorTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        GenericProperty property = (GenericProperty)panel.getPropertyByTitle("foo");
        FieldAccessor accessor = (FieldAccessor)FieldAccessorTest.getGenericPropertyAccessors(property).get(0);
        IAccessibleExpressionAccessor accessibleAccessor = (IAccessibleExpressionAccessor)accessor.getAdapter(IAccessibleExpressionAccessor.class);
        FieldAccessorTest.assertNotNull((Object)accessibleAccessor);
        FieldAccessorTest.assertNotNull((Object)ReflectionUtils.getFieldByName(accessibleAccessor.getClass(), (String)"val$field"));
    }

    private void defineMyButton() throws Exception {
        FieldAccessorTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public int hgap;", "  public int vgap;", "}"));
        FieldAccessorTest.waitForAutoBuild();
    }
}

