/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.editor;

import org.assertj.core.api.Assertions;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.editor.ObjectPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.util.PropertyUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.eclipse.wb.tests.gef.UIRunnable;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.Test;

public class ObjectPropertyEditorTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_nonVisualBean() throws Exception {
        this.setJavaContentSrc("test", "MyObject", new String[]{"public class MyObject {", "  // filler filler filler filler filler", "}"}, null);
        this.setJavaContentSrc("test", "MyComponent", new String[]{"public class MyComponent extends JLabel {", "  public void setValue(MyObject object) {", "  }", "}"}, null);
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final MyComponent component = new MyComponent();", "  /**", "  * @wbp.nonvisual location=0,0", "  */", "  private final MyObject object_1 = new MyObject();", "  /**", "  * @wbp.nonvisual location=0,0", "  */", "  private final Object object_2 = new Object();", "  public Test() {", "    add(component);", "  }", "}");
        panel.refresh();
        ObjectPropertyEditorTest.assertNull((Object)panel.getPropertyByTitle("dropTarget"));
        ObjectPropertyEditorTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(component)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyComponent} {field-initializer: component} {/new MyComponent()/ /add(component)/}", "  {NonVisualBeans}", "    {new: test.MyObject} {field-initializer: object_1} {/new MyObject()/}", "    {new: java.lang.Object} {field-initializer: object_2} {/new Object()/}");
        ComponentInfo component = (ComponentInfo)panel.getChildrenComponents().get(0);
        final Property property = component.getPropertyByTitle("value");
        ObjectPropertyEditorTest.assertNotNull((Object)property);
        ObjectPropertyEditorTest.assertFalse((boolean)property.isModified());
        ObjectPropertyEditorTest.assertSame((Object)PropertyCategory.ADVANCED, (Object)property.getCategory());
        PropertyEditor propertyEditor = property.getEditor();
        ObjectPropertyEditorTest.assertSame((Object)propertyEditor, (Object)ObjectPropertyEditor.INSTANCE);
        new UiContext().executeAndCheck(new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                ObjectPropertyEditorTest.openPropertyDialog(property);
            }
        }, new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                context.useShell("value");
                TreeItem panelItem = context.getTreeItem("(javax.swing.JPanel)");
                Button okButton = context.getButtonByText("OK");
                ObjectPropertyEditorTest.assertFalse((boolean)okButton.isEnabled());
                Object[] childItems = panelItem.getItems();
                Assertions.assertThat((Object[])childItems).hasSize(1);
                ObjectPropertyEditorTest.assertEquals((Object)"(non-visual beans)", (Object)childItems[0].getText());
                Object beansContainer = childItems[0];
                Object[] beanItems = beansContainer.getItems();
                Assertions.assertThat((Object[])beanItems).hasSize(1);
                ObjectPropertyEditorTest.assertEquals((Object)"object_1", (Object)beanItems[0].getText());
                Object myObjectItem = beanItems[0];
                UiContext.setSelection((TreeItem)beansContainer);
                ObjectPropertyEditorTest.assertFalse((boolean)okButton.isEnabled());
                UiContext.setSelection((TreeItem)myObjectItem);
                ObjectPropertyEditorTest.assertTrue((boolean)okButton.isEnabled());
                context.clickButton(okButton);
            }
        });
        this.assertEditor("public class Test extends JPanel {", "  private final MyComponent component = new MyComponent();", "  /**", "  * @wbp.nonvisual location=0,0", "  */", "  private final MyObject object_1 = new MyObject();", "  /**", "  * @wbp.nonvisual location=0,0", "  */", "  private final Object object_2 = new Object();", "  public Test() {", "    component.setValue(object_1);", "    add(component);", "  }", "}");
        ObjectPropertyEditorTest.assertNoErrors((JavaInfo)panel);
        ObjectPropertyEditorTest.assertEquals((Object)"object_1", (Object)ObjectPropertyEditorTest.getPropertyText(property));
    }

    @Test
    public void test_subclassOfComponent() throws Exception {
        this.setJavaContentSrc("test", "MyComponent", new String[]{"public class MyComponent extends JLabel {", "  public void setButton(JButton button) {", "  }", "}"}, null);
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final MyComponent component = new MyComponent();", "  private final JButton button = new JButton();", "  private final JTextField textField = new JTextField();", "  public Test() {", "    add(component);", "    add(button);", "    add(textField);", "  }", "}");
        panel.refresh();
        ComponentInfo component = (ComponentInfo)panel.getChildrenComponents().get(0);
        final Property property = component.getPropertyByTitle("button");
        ObjectPropertyEditorTest.assertNotNull((Object)property);
        ObjectPropertyEditorTest.assertFalse((boolean)property.isModified());
        PropertyEditor propertyEditor = property.getEditor();
        ObjectPropertyEditorTest.assertSame((Object)propertyEditor, (Object)ObjectPropertyEditor.INSTANCE);
        new UiContext().executeAndCheck(new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                ObjectPropertyEditorTest.openPropertyDialog(property);
            }
        }, new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                context.useShell("button");
                TreeItem panelItem = context.getTreeItem("(javax.swing.JPanel)");
                Button okButton = context.getButtonByText("OK");
                ObjectPropertyEditorTest.assertFalse((boolean)okButton.isEnabled());
                Object[] childItems = panelItem.getItems();
                Assertions.assertThat((Object[])childItems).hasSize(1);
                ObjectPropertyEditorTest.assertEquals((Object)"button", (Object)childItems[0].getText());
                UiContext.setSelection((TreeItem)childItems[0]);
                ObjectPropertyEditorTest.assertTrue((boolean)okButton.isEnabled());
                context.clickButton(okButton);
            }
        });
        this.assertEditor("public class Test extends JPanel {", "  private final MyComponent component = new MyComponent();", "  private final JButton button = new JButton();", "  private final JTextField textField = new JTextField();", "  public Test() {", "    component.setButton(button);", "    add(component);", "    add(button);", "    add(textField);", "  }", "}");
        ObjectPropertyEditorTest.assertNoErrors((JavaInfo)panel);
        ObjectPropertyEditorTest.assertEquals((Object)"button", (Object)ObjectPropertyEditorTest.getPropertyText(property));
    }

    @Test
    public void test_initialSelection() throws Exception {
        this.setJavaContentSrc("test", "MyComponent", new String[]{"public class MyComponent extends JLabel {", "  public void setButton(JButton button) {", "  }", "}"}, null);
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final MyComponent component = new MyComponent();", "  private final JButton button_1 = new JButton();", "  private final JButton button_2 = new JButton();", "  public Test() {", "    component.setButton(button_2);", "    add(component);", "    add(button_1);", "    add(button_2);", "  }", "}");
        panel.refresh();
        ComponentInfo component = (ComponentInfo)ObjectPropertyEditorTest.getJavaInfoByName("component");
        final Property property = component.getPropertyByTitle("button");
        ObjectPropertyEditorTest.assertNotNull((Object)property);
        PropertyEditor propertyEditor = property.getEditor();
        ObjectPropertyEditorTest.assertSame((Object)propertyEditor, (Object)ObjectPropertyEditor.INSTANCE);
        new UiContext().executeAndCheck(new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                ObjectPropertyEditorTest.openPropertyDialog(property);
            }
        }, new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                context.useShell("button");
                try {
                    TreeItem itemButton_2 = context.getTreeItem("button_2");
                    Object[] selection = itemButton_2.getParent().getSelection();
                    Assertions.assertThat((Object[])selection).containsOnly((Object[])new TreeItem[]{itemButton_2});
                }
                finally {
                    context.clickButton("Cancel");
                }
            }
        });
    }

    @Test
    public void test_getText_noInvocation() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JLabel label = new JLabel();", "      add(label);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo label = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property labelForProperty = label.getPropertyByTitle("labelFor");
        ObjectPropertyEditorTest.assertNotNull((Object)labelForProperty);
        ObjectPropertyEditorTest.assertSame((Object)PropertyCategory.PREFERRED, (Object)labelForProperty.getCategory());
        ObjectPropertyEditorTest.assertFalse((boolean)labelForProperty.isModified());
        ObjectPropertyEditorTest.assertNull((Object)ObjectPropertyEditorTest.getPropertyText(labelForProperty));
        ObjectPropertyEditor opEditor = (ObjectPropertyEditor)labelForProperty.getEditor();
        ObjectPropertyEditorTest.assertEquals((long)opEditor.getProperties(labelForProperty).length, (long)0L);
    }

    @Test
    public void test_getText_hasInvocation() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final JLabel label = new JLabel();", "  private final JTextField textField = new JTextField();", "  public Test() {", "    add(label);", "    label.setLabelFor(textField);", "    add(textField);", "  }", "}");
        panel.refresh();
        ComponentInfo label = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property labelForProperty = label.getPropertyByTitle("labelFor");
        ObjectPropertyEditorTest.assertTrue((boolean)labelForProperty.isModified());
        ObjectPropertyEditorTest.assertEquals((Object)"textField", (Object)ObjectPropertyEditorTest.getPropertyText(labelForProperty));
        ObjectPropertyEditor opEditor = (ObjectPropertyEditor)labelForProperty.getEditor();
        Assertions.assertThat((int)opEditor.getProperties(labelForProperty).length).isGreaterThan(0);
    }

    @Test
    public void test_withAbsoluteLayout() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "    add(new JLabel());", "  }", "}");
        panel.refresh();
        ComponentInfo label = (ComponentInfo)panel.getChildrenComponents().get(0);
        final Property property = label.getPropertyByTitle("labelFor");
        PropertyEditor propertyEditor = property.getEditor();
        ObjectPropertyEditorTest.assertSame((Object)propertyEditor, (Object)ObjectPropertyEditor.INSTANCE);
        new UiContext().executeAndCheck(new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                ObjectPropertyEditorTest.openPropertyDialog(property);
            }
        }, new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                context.useShell("labelFor");
                context.clickButton("Cancel");
            }
        });
    }

    @Test
    public void test_setComponent_labelBefore() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JLabel label = new JLabel();", "      add(label);", "    }", "    {", "      JTextField textField = new JTextField();", "      add(textField);", "    }", "  }", "}");
        ComponentInfo label = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo textField = (ComponentInfo)panel.getChildrenComponents().get(1);
        Property labelForProperty = label.getPropertyByTitle("labelFor");
        ObjectPropertyEditorTest.setComponent(labelForProperty, (JavaInfo)textField);
        this.assertEditor("public class Test extends JPanel {", "  private JLabel label;", "  public Test() {", "    {", "      label = new JLabel();", "      add(label);", "    }", "    {", "      JTextField textField = new JTextField();", "      label.setLabelFor(textField);", "      add(textField);", "    }", "  }", "}");
    }

    @Test
    public void test_setComponent_labelAfter() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JTextField textField = new JTextField();", "      add(textField);", "    }", "    {", "      JLabel label = new JLabel();", "      add(label);", "    }", "  }", "}");
        ComponentInfo textField = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo label = (ComponentInfo)panel.getChildrenComponents().get(1);
        Property labelForProperty = label.getPropertyByTitle("labelFor");
        ObjectPropertyEditorTest.setComponent(labelForProperty, (JavaInfo)textField);
        this.assertEditor("public class Test extends JPanel {", "  private JTextField textField;", "  public Test() {", "    {", "      textField = new JTextField();", "      add(textField);", "    }", "    {", "      JLabel label = new JLabel();", "      label.setLabelFor(textField);", "      add(label);", "    }", "  }", "}");
    }

    @Test
    public void test_setComponent_lazy() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JLabel m_label;", "  private JTextField m_textField;", "  public Test() {", "    add(getLabel());", "    add(getTextField());", "  }", "  private JLabel getLabel() {", "    if (m_label == null) {", "      m_label = new JLabel();", "    }", "    return m_label;", "  }", "  private JTextField getTextField() {", "    if (m_textField == null) {", "      m_textField = new JTextField();", "    }", "    return m_textField;", "  }", "}");
        ComponentInfo label = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo textField = (ComponentInfo)panel.getChildrenComponents().get(1);
        Property labelForProperty = label.getPropertyByTitle("labelFor");
        ObjectPropertyEditorTest.setComponent(labelForProperty, (JavaInfo)textField);
        this.assertEditor("public class Test extends JPanel {", "  private JLabel m_label;", "  private JTextField m_textField;", "  public Test() {", "    add(getLabel());", "    add(getTextField());", "  }", "  private JLabel getLabel() {", "    if (m_label == null) {", "      m_label = new JLabel();", "      m_label.setLabelFor(getTextField());", "    }", "    return m_label;", "  }", "  private JTextField getTextField() {", "    if (m_textField == null) {", "      m_textField = new JTextField();", "    }", "    return m_textField;", "  }", "}");
    }

    @Test
    public void test_setComponent_newComponent() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JLabel label;", "  public Test() {", "    {", "      label = new JLabel();", "      add(label);", "    }", "    {", "      JTextField textField_1 = new JTextField();", "      label.setLabelFor(textField_1);", "      add(textField_1);", "    }", "    {", "      JTextField textField_2 = new JTextField();", "      add(textField_2);", "    }", "  }", "}");
        ComponentInfo label = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo textField_2 = (ComponentInfo)panel.getChildrenComponents().get(2);
        Property labelForProperty = label.getPropertyByTitle("labelFor");
        ObjectPropertyEditorTest.setComponent(labelForProperty, (JavaInfo)textField_2);
        this.assertEditor("public class Test extends JPanel {", "  private JLabel label;", "  public Test() {", "    {", "      label = new JLabel();", "      add(label);", "    }", "    {", "      JTextField textField_1 = new JTextField();", "      add(textField_1);", "    }", "    {", "      JTextField textField_2 = new JTextField();", "      label.setLabelFor(textField_2);", "      add(textField_2);", "    }", "  }", "}");
    }

    @Test
    public void test_setComponent_noComponent() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JLabel label;", "  public Test() {", "    {", "      label = new JLabel();", "      add(label);", "    }", "    {", "      JTextField textField_1 = new JTextField();", "      label.setLabelFor(textField_1);", "      add(textField_1);", "    }", "  }", "}");
        ComponentInfo label = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property labelForProperty = label.getPropertyByTitle("labelFor");
        ObjectPropertyEditorTest.setComponent(labelForProperty, null);
        this.assertEditor("public class Test extends JPanel {", "  private JLabel label;", "  public Test() {", "    {", "      label = new JLabel();", "      add(label);", "    }", "    {", "      JTextField textField_1 = new JTextField();", "      add(textField_1);", "    }", "  }", "}");
    }

    @Test
    public void test_setComponent_constructor() throws Exception {
        ObjectPropertyEditorTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public MyPanel(JButton button) {", "  }", "}"));
        ObjectPropertyEditorTest.waitForAutoBuild();
        this.parseContainer("public class Test extends JPanel {", "  private final JButton button_1 = new JButton();", "  private final JButton button_2 = new JButton();", "  private final MyPanel myPanel = new MyPanel(button_1);", "  public Test() {", "    add(button_1);", "    add(button_2);", "    add(myPanel);", "  }", "}");
        this.refresh();
        ContainerInfo myPanel = (ContainerInfo)ObjectPropertyEditorTest.getJavaInfoByName("myPanel");
        ComponentInfo button_2 = (ComponentInfo)ObjectPropertyEditorTest.getJavaInfoByName("button_2");
        Property property = PropertyUtils.getByPath((ObjectInfo)myPanel, (String)"Constructor/button");
        ObjectPropertyEditorTest.assertNotNull((Object)property);
        ObjectPropertyEditorTest.assertTrue((boolean)property.isModified());
        ObjectPropertyEditorTest.assertEquals((Object)"button_1", (Object)ObjectPropertyEditorTest.getPropertyText(property));
        ObjectPropertyEditorTest.setComponent(property, (JavaInfo)button_2);
        this.assertEditor("public class Test extends JPanel {", "  private final JButton button_1 = new JButton();", "  private final JButton button_2 = new JButton();", "  private final MyPanel myPanel = new MyPanel(button_2);", "  public Test() {", "    add(button_1);", "    add(button_2);", "    add(myPanel);", "  }", "}");
    }

    private static void setComponent(Property property, JavaInfo component) throws Exception {
        ReflectionUtils.invokeMethod2((Object)property.getEditor(), (String)"setComponent", GenericProperty.class, JavaInfo.class, (Object)property, (Object)component);
    }
}

