/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.editor;

import java.text.MessageFormat;
import org.assertj.core.api.Assertions;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.clipboard.IClipboardSourceProvider;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.BooleanPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.IValueSourcePropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.StringComboPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.style.StylePropertyEditor;
import org.eclipse.wb.internal.core.model.util.PropertyUtils;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorWarning;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.After;
import org.junit.Test;

public class StylePropertyEditorLongTest
extends SwingModelTest {
    private GenericProperty m_styleProperty;
    private StylePropertyEditor m_editor;
    private Property[] m_properties;
    IContributionItem[] styleItems;

    @Override
    protected void configureNewProject() throws Exception {
        super.configureNewProject();
        StylePropertyEditorLongTest.setFileContentSrc("test/StylePanel.java", this.getTestSource("public class StylePanel extends JPanel {", "  public StylePanel(long style) {", "  }", "}"));
        StylePropertyEditorLongTest.setFileContentSrc("test/SWT.java", this.getTestSource("public interface SWT {", "  long NONE = 0;", "  long B0 = 1 << 0;", "  long B1 = 1 << 1;", "  long B2 = 1 << 2;", "  long B3 = 1 << 3;", "  // mix", "  long B0_B1 = B0 | B1;", "  long B0_B2 = B0 | B2;", "  //", "  long R1 = 1 << 4;", "  long R2 = 1 << 5;", "  long R3 = 1 << 6;", "  long R4 = 1 << 7;", "}"));
        StylePropertyEditorLongTest.forgetCreatedResources();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.m_styleProperty = null;
        this.m_editor = null;
        this.m_properties = null;
        this.styleItems = null;
        super.tearDown();
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_StyleProperty_Set_1() throws Exception {
        this.parseStyleProperties("set|B0 B1 B2:specialName");
        Assertions.assertThat((Object[])this.m_properties).hasSize(3);
        StylePropertyEditorLongTest.assertEquals((Object)"b0", (Object)this.m_properties[0].getTitle());
        StylePropertyEditorLongTest.assertEquals((Object)"b1", (Object)this.m_properties[1].getTitle());
        StylePropertyEditorLongTest.assertEquals((Object)"specialName", (Object)this.m_properties[2].getTitle());
        Property[] propertyArray = this.m_properties;
        int n = this.m_properties.length;
        int n2 = 0;
        while (n2 < n) {
            Property property = propertyArray[n2];
            StylePropertyEditorLongTest.assertInstanceOf(BooleanPropertyEditor.class, (Object)property.getEditor());
            StylePropertyEditorLongTest.assertEquals((Object)false, (Object)property.getValue());
            ++n2;
        }
        this.assertEditorText("[]");
        this.m_properties[0].setValue((Object)Boolean.TRUE);
        StylePropertyEditorLongTest.assertEquals((Object)Boolean.TRUE, (Object)this.m_properties[0].getValue());
        this.assertStyleSource("SWT.B0");
        this.assertEditorText("[B0]");
        this.m_properties[2].setValue((Object)Boolean.TRUE);
        StylePropertyEditorLongTest.assertEquals((Object)Boolean.TRUE, (Object)this.m_properties[2].getValue());
        this.assertStyleSource("SWT.B0 | SWT.B2");
        this.assertEditorText("[B0, B2]");
        this.m_properties[0].setValue(Property.UNKNOWN_VALUE);
        StylePropertyEditorLongTest.assertEquals((Object)Boolean.FALSE, (Object)this.m_properties[0].getValue());
        this.assertStyleSource("SWT.B2");
        this.assertEditorText("[B2]");
        this.m_properties[2].setValue(Property.UNKNOWN_VALUE);
        StylePropertyEditorLongTest.assertEquals((Object)Boolean.FALSE, (Object)this.m_properties[2].getValue());
        this.assertStyleSource("SWT.NONE");
        this.assertEditorText("[]");
    }

    @Test
    public void test_StyleProperty_Set_2() throws Exception {
        this.parseStyleProperties("set|B0 noSuchField");
        Object[] names = PropertyUtils.getTitles((Property[])this.m_properties);
        Assertions.assertThat((Object[])names).containsOnly((Object[])new String[]{"b0"});
        this.checkWarning("StylePropertyEditor: can not find field test.SWT.noSuchField");
    }

    @Test
    public void test_Select_1() throws Exception {
        this.parseStyleProperties("set|B0 B1", "select0|align R1 R1 R2 R3");
        String[] subNames = new String[]{"b0", "b1", "align"};
        StylePropertyEditorLongTest.assertEquals((long)subNames.length, (long)this.m_properties.length);
        int i = 0;
        while (i < 2) {
            Property property = this.m_properties[i];
            StylePropertyEditorLongTest.assertEquals((Object)subNames[i], (Object)property.getTitle());
            StylePropertyEditorLongTest.assertInstanceOf(BooleanPropertyEditor.class, (Object)property.getEditor());
            StylePropertyEditorLongTest.assertEquals((Object)false, (Object)property.getValue());
            ++i;
        }
        Property alignProperty = this.m_properties[2];
        StylePropertyEditorLongTest.assertEquals((Object)subNames[2], (Object)alignProperty.getTitle());
        StylePropertyEditorLongTest.assertEquals((Object)"R1", (Object)alignProperty.getValue());
        this.m_properties[0].setValue((Object)true);
        StylePropertyEditorLongTest.assertEquals((Object)true, (Object)this.m_properties[0].getValue());
        this.assertStyleSource("SWT.B0");
        this.assertEditorText("[B0]");
        alignProperty.setValue((Object)"R2");
        StylePropertyEditorLongTest.assertEquals((Object)"R2", (Object)alignProperty.getValue());
        this.assertStyleSource("SWT.B0 | SWT.R2");
        this.assertEditorText("[B0, R2]");
        alignProperty.setValue((Object)"R3");
        StylePropertyEditorLongTest.assertEquals((Object)"R3", (Object)alignProperty.getValue());
        this.assertStyleSource("SWT.B0 | SWT.R3");
        this.assertEditorText("[B0, R3]");
        this.m_properties[0].setValue((Object)false);
        StylePropertyEditorLongTest.assertEquals((Object)false, (Object)this.m_properties[0].getValue());
        this.assertStyleSource("SWT.R3");
        this.assertEditorText("[R3]");
        alignProperty.setValue((Object)"R1");
        StylePropertyEditorLongTest.assertEquals((Object)"R1", (Object)alignProperty.getValue());
        this.assertStyleSource("SWT.NONE");
        this.assertEditorText("[]");
        alignProperty.setValue((Object)"R2");
        StylePropertyEditorLongTest.assertEquals((Object)"R2", (Object)alignProperty.getValue());
        this.assertStyleSource("SWT.R2");
        this.assertEditorText("[R2]");
        alignProperty.setValue(Property.UNKNOWN_VALUE);
        StylePropertyEditorLongTest.assertEquals((Object)"R1", (Object)alignProperty.getValue());
        this.assertStyleSource("SWT.NONE");
        this.assertEditorText("[]");
    }

    @Test
    public void test_Select_2() throws Exception {
        this.parseStyleProperties("select0|align 15 15 R1 noSuchField");
        Assertions.assertThat((Object[])PropertyUtils.getTitles((Property[])this.m_properties)).containsOnly((Object[])new String[]{"align"});
        Property alignProperty = this.m_properties[0];
        StylePropertyEditorLongTest.assertEquals((Object)"align", (Object)alignProperty.getTitle());
        StylePropertyEditorLongTest.assertEquals((Object)"15", (Object)alignProperty.getValue());
        StylePropertyEditorLongTest.assertInstanceOf(StringComboPropertyEditor.class, (Object)alignProperty.getEditor());
        String[] items = (String[])ReflectionUtils.getFieldObject((Object)alignProperty.getEditor(), (String)"m_items");
        StylePropertyEditorLongTest.assertEquals((long)2L, (long)items.length);
        StylePropertyEditorLongTest.assertEquals((Object)"15", (Object)items[0]);
        StylePropertyEditorLongTest.assertEquals((Object)"R1", (Object)items[1]);
        this.checkWarning("StylePropertyEditor: can not find field test.SWT.noSuchField");
    }

    @Test
    public void test_Select_for_methodProperty() throws Exception {
        StylePropertyEditorLongTest.setFileContentSrc("test/TestComposite.java", this.getTestSource("public class TestComposite extends JPanel {", "  private long m_format;", "  public long getFormat() {", "    return m_format;", "  }", "  public void setFormat(long format) {", "    m_format = format;", "  }", "}"));
        StylePropertyEditorLongTest.setFileContentSrc("test/TestComposite.wbp-component.xml", StylePropertyEditorLongTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <property id='setFormat(long)'>", "    <editor id='style'>", "      <parameter name='class'>test.SWT</parameter>", "      <parameter name='select0'>type NONE NONE R1 R2</parameter>", "    </editor>", "  </property>", "</component>"));
        StylePropertyEditorLongTest.waitForAutoBuild();
        this.parseStyleProperties0("format", new String[]{"public class Test extends JPanel {", "  public Test() {", "    TestComposite composite = new TestComposite();", "    add(composite);", "  }", "}"});
        Assertions.assertThat((Object[])this.m_properties).hasSize(1);
        Property alignProperty = this.m_properties[0];
        this.assertEditorText("[]");
        alignProperty.setValue((Object)"R1");
        StylePropertyEditorLongTest.assertEquals((Object)"R1", (Object)alignProperty.getValue());
        this.assertEditorText("[R1]");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    TestComposite composite = new TestComposite();", "    composite.setFormat(SWT.R1);", "    add(composite);", "  }", "}");
        alignProperty.setValue((Object)"R2");
        StylePropertyEditorLongTest.assertEquals((Object)"R2", (Object)alignProperty.getValue());
        this.assertEditorText("[R2]");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    TestComposite composite = new TestComposite();", "    composite.setFormat(SWT.R2);", "    add(composite);", "  }", "}");
        alignProperty.setValue((Object)"NONE");
        StylePropertyEditorLongTest.assertEquals((Object)"NONE", (Object)alignProperty.getValue());
        this.assertEditorText("[]");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    TestComposite composite = new TestComposite();", "    add(composite);", "  }", "}");
    }

    @Test
    public void test_Macro_1() throws Exception {
        this.parseStyleProperties("set|B0 B1 B2 B3", "macro0|mix B0_B1 B0_B2 R1");
        Property property_B0 = this.m_properties[0];
        Property property_B1 = this.m_properties[1];
        Property property_B2 = this.m_properties[2];
        Property property_B3 = this.m_properties[3];
        Property propertyMix = this.m_properties[4];
        property_B0.setValue((Object)true);
        this.assertStyleSource("SWT.B0");
        StylePropertyEditorLongTest.assertEquals((Object)"", (Object)propertyMix.getValue());
        this.assertEditorText("[B0]");
        propertyMix.setValue((Object)"B0_B1");
        StylePropertyEditorLongTest.assertEquals((Object)"B0_B1", (Object)propertyMix.getValue());
        StylePropertyEditorLongTest.assertEquals((Object)true, (Object)property_B0.getValue());
        StylePropertyEditorLongTest.assertEquals((Object)true, (Object)property_B1.getValue());
        StylePropertyEditorLongTest.assertEquals((Object)false, (Object)property_B2.getValue());
        StylePropertyEditorLongTest.assertEquals((Object)false, (Object)property_B3.getValue());
        this.assertStyleSource("SWT.B0_B1");
        this.assertEditorText("[B0_B1]");
        property_B3.setValue((Object)true);
        StylePropertyEditorLongTest.assertEquals((Object)"B0_B1", (Object)propertyMix.getValue());
        StylePropertyEditorLongTest.assertEquals((Object)true, (Object)property_B0.getValue());
        StylePropertyEditorLongTest.assertEquals((Object)true, (Object)property_B1.getValue());
        StylePropertyEditorLongTest.assertEquals((Object)false, (Object)property_B2.getValue());
        StylePropertyEditorLongTest.assertEquals((Object)true, (Object)property_B3.getValue());
        this.assertStyleSource("SWT.B0_B1 | SWT.B3");
        this.assertEditorText("[B0_B1, B3]");
        propertyMix.setValue((Object)"R1");
        StylePropertyEditorLongTest.assertEquals((Object)"R1", (Object)propertyMix.getValue());
        StylePropertyEditorLongTest.assertEquals((Object)false, (Object)property_B0.getValue());
        StylePropertyEditorLongTest.assertEquals((Object)false, (Object)property_B1.getValue());
        StylePropertyEditorLongTest.assertEquals((Object)false, (Object)property_B2.getValue());
        StylePropertyEditorLongTest.assertEquals((Object)false, (Object)property_B3.getValue());
        this.assertStyleSource("SWT.R1");
        this.assertEditorText("[R1]");
    }

    @Test
    public void test_Macro_2() throws Exception {
        this.parseStyleProperties("set|B0 B1", "macro0|mix B0_B1 R1");
        Property property_B0 = this.m_properties[0];
        Property property_B1 = this.m_properties[1];
        Property propertyMix = this.m_properties[2];
        propertyMix.setValue((Object)"B0_B1");
        StylePropertyEditorLongTest.assertEquals((Object)"B0_B1", (Object)propertyMix.getValue());
        StylePropertyEditorLongTest.assertEquals((Object)true, (Object)property_B0.getValue());
        StylePropertyEditorLongTest.assertEquals((Object)true, (Object)property_B1.getValue());
        this.assertStyleSource("SWT.B0_B1");
        this.assertEditorText("[B0_B1]");
        property_B0.setValue((Object)false);
        StylePropertyEditorLongTest.assertEquals((Object)"", (Object)propertyMix.getValue());
        StylePropertyEditorLongTest.assertEquals((Object)false, (Object)property_B0.getValue());
        StylePropertyEditorLongTest.assertEquals((Object)true, (Object)property_B1.getValue());
        this.assertStyleSource("SWT.B1");
        this.assertEditorText("[B1]");
    }

    @Test
    public void test_enum() throws Exception {
        this.parseStyleProperties("SWT.R1", new String[]{"set|B0 B1", "enum0|en 0xF0 R1 R2 R3"});
        Property property_B0 = this.m_properties[0];
        StylePropertyEditorLongTest.assertEquals((Object)"b0", (Object)property_B0.getTitle());
        StylePropertyEditorLongTest.assertInstanceOf(BooleanPropertyEditor.class, (Object)property_B0.getEditor());
        StylePropertyEditorLongTest.assertEquals((Object)false, (Object)property_B0.getValue());
        Property property_B1 = this.m_properties[1];
        StylePropertyEditorLongTest.assertEquals((Object)"b1", (Object)property_B1.getTitle());
        StylePropertyEditorLongTest.assertInstanceOf(BooleanPropertyEditor.class, (Object)property_B1.getEditor());
        StylePropertyEditorLongTest.assertEquals((Object)false, (Object)property_B1.getValue());
        Property propertyEnum = this.m_properties[2];
        StylePropertyEditorLongTest.assertEquals((Object)"en", (Object)propertyEnum.getTitle());
        StylePropertyEditorLongTest.assertEquals((Object)"R1", (Object)propertyEnum.getValue());
        property_B0.setValue((Object)true);
        StylePropertyEditorLongTest.assertEquals((Object)true, (Object)property_B0.getValue());
        StylePropertyEditorLongTest.assertEquals((Object)false, (Object)property_B1.getValue());
        StylePropertyEditorLongTest.assertEquals((Object)"R1", (Object)propertyEnum.getValue());
        this.assertStyleSource("SWT.B0 | SWT.R1");
        this.assertEditorText("[B0, R1]");
        propertyEnum.setValue((Object)"R2");
        StylePropertyEditorLongTest.assertEquals((Object)true, (Object)property_B0.getValue());
        StylePropertyEditorLongTest.assertEquals((Object)false, (Object)property_B1.getValue());
        StylePropertyEditorLongTest.assertEquals((Object)"R2", (Object)propertyEnum.getValue());
        this.assertStyleSource("SWT.B0 | SWT.R2");
        this.assertEditorText("[B0, R2]");
        property_B0.setValue((Object)false);
        StylePropertyEditorLongTest.assertEquals((Object)false, (Object)property_B0.getValue());
        StylePropertyEditorLongTest.assertEquals((Object)false, (Object)property_B1.getValue());
        StylePropertyEditorLongTest.assertEquals((Object)"R2", (Object)propertyEnum.getValue());
        this.assertStyleSource("SWT.R2");
        this.assertEditorText("[R2]");
        propertyEnum.setValue((Object)"R1");
        StylePropertyEditorLongTest.assertEquals((Object)false, (Object)property_B0.getValue());
        StylePropertyEditorLongTest.assertEquals((Object)false, (Object)property_B1.getValue());
        StylePropertyEditorLongTest.assertEquals((Object)"R1", (Object)propertyEnum.getValue());
        this.assertStyleSource("SWT.R1");
        this.assertEditorText("[R1]");
    }

    private void prepareStyleItems(boolean cascade) throws Exception {
        MenuManager manager = StylePropertyEditorLongTest.getDesignerMenuManager();
        this.m_editor.contributeActions((Property)this.m_styleProperty, (IMenuManager)manager, "Style", cascade);
        IMenuManager styleMenu = StylePropertyEditorLongTest.findChildMenuManager((IContributionManager)manager, "Style");
        StylePropertyEditorLongTest.assertNotNull((Object)styleMenu);
        this.styleItems = styleMenu.getItems();
    }

    @Test
    public void test_popup() throws Exception {
        this.parseStyleProperties("set|B0 B1 B2", "select0|align R1 R1 R2 R3");
        this.prepareStyleItems(false);
        Assertions.assertThat((Object[])this.styleItems).hasSize(7);
        IContributionItem item_B0 = this.styleItems[0];
        IContributionItem item_R2 = this.styleItems[5];
        StylePropertyEditorLongTest.checkItem("b0", 2, false, item_B0);
        StylePropertyEditorLongTest.checkItem("b1", 2, false, this.styleItems[1]);
        StylePropertyEditorLongTest.checkItem("b2", 2, false, this.styleItems[2]);
        StylePropertyEditorLongTest.assertInstanceOf(Separator.class, (Object)this.styleItems[3]);
        StylePropertyEditorLongTest.checkItem("R1", 8, true, this.styleItems[4]);
        StylePropertyEditorLongTest.checkItem("R2", 8, false, item_R2);
        StylePropertyEditorLongTest.checkItem("R3", 8, false, this.styleItems[6]);
        ((ActionContributionItem)item_B0).getAction().run();
        this.assertStyleSource("SWT.B0");
        ((ActionContributionItem)item_R2).getAction().setChecked(true);
        ((ActionContributionItem)item_R2).getAction().run();
        this.assertStyleSource("SWT.B0 | SWT.R2");
    }

    @Test
    public void test_popup_cascade() throws Exception {
        this.parseStyleProperties("set|B0 B1", "select0|align R1 R1 R2 R3");
        this.prepareStyleItems(true);
        Assertions.assertThat((Object[])this.styleItems).hasSize(4);
        StylePropertyEditorLongTest.checkItem("b0", 2, false, this.styleItems[0]);
        StylePropertyEditorLongTest.checkItem("b1", 2, false, this.styleItems[1]);
        StylePropertyEditorLongTest.assertInstanceOf(Separator.class, (Object)this.styleItems[2]);
        StylePropertyEditorLongTest.assertInstanceOf(MenuManager.class, (Object)this.styleItems[3]);
        IMenuManager alignMenu = (IMenuManager)this.styleItems[3];
        Object[] alignItems = alignMenu.getItems();
        Assertions.assertThat((Object[])alignItems).hasSize(4);
        StylePropertyEditorLongTest.assertInstanceOf(Separator.class, alignItems[0]);
        StylePropertyEditorLongTest.checkItem("R1", 8, true, (IContributionItem)alignItems[1]);
        StylePropertyEditorLongTest.checkItem("R2", 8, false, (IContributionItem)alignItems[2]);
        StylePropertyEditorLongTest.checkItem("R3", 8, false, (IContributionItem)alignItems[3]);
    }

    @Test
    public void test_popup_enum() throws Exception {
        this.parseStyleProperties("set|B0 B1", "enum0|enum 0xF0 R1 R2 R3");
        this.prepareStyleItems(false);
        Assertions.assertThat((Object[])this.styleItems).hasSize(6);
        StylePropertyEditorLongTest.checkItem("b0", 2, false, this.styleItems[0]);
        StylePropertyEditorLongTest.checkItem("b1", 2, false, this.styleItems[1]);
        StylePropertyEditorLongTest.assertInstanceOf(Separator.class, (Object)this.styleItems[2]);
        StylePropertyEditorLongTest.checkItem("R1", 8, false, this.styleItems[3]);
        StylePropertyEditorLongTest.checkItem("R2", 8, false, this.styleItems[4]);
        StylePropertyEditorLongTest.checkItem("R3", 8, false, this.styleItems[5]);
    }

    @Test
    public void test_popup_macro() throws Exception {
        this.parseStyleProperties("set|B0 B1", "macro0|mix B0_B1 B0_B2 R1");
        this.prepareStyleItems(false);
        Assertions.assertThat((Object[])this.styleItems).hasSize(6);
        StylePropertyEditorLongTest.checkItem("b0", 2, false, this.styleItems[0]);
        StylePropertyEditorLongTest.checkItem("b1", 2, false, this.styleItems[1]);
        StylePropertyEditorLongTest.assertInstanceOf(Separator.class, (Object)this.styleItems[2]);
        StylePropertyEditorLongTest.checkItem("B0_B1", 8, false, this.styleItems[3]);
        StylePropertyEditorLongTest.checkItem("B0_B2", 8, false, this.styleItems[4]);
        StylePropertyEditorLongTest.checkItem("R1", 8, false, this.styleItems[5]);
    }

    private static void checkItem(String text, int style, boolean value, IContributionItem item) throws Exception {
        StylePropertyEditorLongTest.assertInstanceOf(ActionContributionItem.class, (Object)item);
        ActionContributionItem contributionItem = (ActionContributionItem)item;
        IAction action = contributionItem.getAction();
        StylePropertyEditorLongTest.assertNotNull((Object)action);
        StylePropertyEditorLongTest.assertEquals((Object)text, (Object)action.getText());
        StylePropertyEditorLongTest.assertEquals((long)style, (long)action.getStyle());
        StylePropertyEditorLongTest.assertEquals((Object)value, (Object)action.isChecked());
    }

    @Test
    public void test_IValueSourcePropertyEditor() throws Exception {
        int value = 5;
        this.parseStyleProperties("set|B0 B1 B2");
        IValueSourcePropertyEditor sourceProvider = (IValueSourcePropertyEditor)this.m_styleProperty.getEditor();
        StylePropertyEditorLongTest.assertEquals((Object)"test.SWT.B0 | test.SWT.B2", (Object)sourceProvider.getValueSource((Object)value));
        this.assertStyleSource("SWT.NONE");
        this.m_styleProperty.setValue((Object)value);
        this.assertStyleSource("SWT.B0 | SWT.B2");
    }

    @Test
    public void test_IClipboardSourceProvider() throws Exception {
        this.parseStyleProperties("SWT.B0 | SWT.B2", new String[]{"set|B0 B1 B2"});
        IClipboardSourceProvider sourceProvider = (IClipboardSourceProvider)this.m_styleProperty.getEditor();
        StylePropertyEditorLongTest.assertEquals((Object)"test.SWT.B0 | test.SWT.B2", (Object)sourceProvider.getClipboardSource(this.m_styleProperty));
    }

    private void assertEditorText(String text) throws Exception {
        StylePropertyEditorLongTest.assertEquals((Object)text, (Object)StylePropertyEditorLongTest.getPropertyText((Property)this.m_styleProperty));
    }

    private void assertStyleSource(String styleSource) {
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    add(new TestComposite(" + styleSource + "));", "  }", "}");
    }

    private void parseStyleProperties(String ... styleLines) throws Exception {
        this.parseStyleProperties("SWT.NONE", styleLines);
    }

    private void parseStyleProperties(String styleSource, String[] styleLines0) throws Exception {
        StylePropertyEditorLongTest.setFileContentSrc("test/TestComposite.java", this.getTestSource("public class TestComposite extends JPanel {", "  public TestComposite(long style) {", "  }", "}"));
        String[] styleLines = new String[styleLines0.length];
        int i = 0;
        while (i < styleLines0.length) {
            String line = styleLines0[i];
            int index = line.indexOf(124);
            String name = line.substring(0, index);
            String value = line.substring(index + 1);
            styleLines[i] = MessageFormat.format("<parameter name=''{0}''>{1}</parameter>", name, value);
            ++i;
        }
        String[] lines = new String[]{"<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <constructors>", "    <constructor>", "      <parameter type='long' defaultSource='test.SWT.NONE'>", "        <editor id='style'>", "          <parameter name='class'>test.SWT</parameter>"};
        lines = CodeUtils.join((String[])lines, (String[])styleLines);
        lines = CodeUtils.join((String[])lines, (String[])new String[]{"        </editor>", "      </parameter>", "    </constructor>", "  </constructors>", "</component>"});
        StylePropertyEditorLongTest.setFileContentSrc("test/TestComposite.wbp-component.xml", StylePropertyEditorLongTest.getSource(lines));
        StylePropertyEditorLongTest.waitForAutoBuild();
        this.parseStyleProperties0("Constructor/style", new String[]{"// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    add(new TestComposite(" + styleSource + "));", "  }", "}"});
    }

    private void parseStyleProperties0(String propertyPath, String[] lines) throws Exception {
        ContainerInfo panel = this.parseContainer(lines);
        panel.refresh();
        ComponentInfo component = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.m_styleProperty = (GenericProperty)PropertyUtils.getByPath((ObjectInfo)component, (String)propertyPath);
        this.m_editor = (StylePropertyEditor)this.m_styleProperty.getEditor();
        this.m_properties = this.m_editor.getProperties((Property)this.m_styleProperty);
    }

    private void checkWarning(String message) throws Exception {
        boolean find = false;
        for (EditorWarning warning : this.m_lastState.getWarnings()) {
            find = message.equals(warning.getMessage());
            if (find) break;
        }
        StylePropertyEditorLongTest.assertTrue((boolean)find);
    }
}

