/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.nls.ui;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.internal.core.nls.ui.NlsDialog;
import org.eclipse.wb.internal.core.nls.ui.SourceComposite;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.tests.designer.core.nls.ui.AbstractNlsUiTest;
import org.eclipse.wb.tests.gef.EventSender;
import org.eclipse.wb.tests.gef.UIRunnable;
import org.eclipse.wb.tests.gef.UiContext;

public abstract class AbstractDialogTest
extends AbstractNlsUiTest {
    protected static Point getItemLocation(Table table, int column, int row) {
        int x = 0;
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < column) {
            TableColumn tableColumn = columns[i];
            x += tableColumn.getWidth();
            ++i;
        }
        int y = table.getHeaderHeight() + table.getItemHeight() * row + table.getItemHeight() / 2;
        return new Point(x += columns[column].getWidth() / 2, y);
    }

    protected static void clickItem(Table table, int column, int row, int button) throws Exception {
        Point p = AbstractDialogTest.getItemLocation(table, column, row);
        EventSender eventSender = new EventSender((Control)table);
        eventSender.postMouseMove(p);
        EventSender.postMouseDown(1);
        EventSender.postMouseUp(1);
        AbstractDialogTest.waitEventLoop(10);
    }

    protected static TabItem[] assertItems(TabFolder tabFolder, String[] expectedTitles) {
        TabItem[] items = tabFolder.getItems();
        AbstractDialogTest.assertEquals((long)expectedTitles.length, (long)items.length);
        int i = 0;
        while (i < items.length) {
            TabItem item = items[i];
            AbstractDialogTest.assertEquals((Object)expectedTitles[i], (Object)item.getText());
            ++i;
        }
        return items;
    }

    protected static void assertItems(List list, String[] expectedTitles) {
        String[] items = list.getItems();
        AbstractDialogTest.assertEquals((long)expectedTitles.length, (long)items.length);
        int i = 0;
        while (i < items.length) {
            String item = items[i];
            AbstractDialogTest.assertEquals((Object)expectedTitles[i], (Object)item);
            ++i;
        }
    }

    protected static void assertColumns(Table table, String[] expectedTitles) {
        TableColumn[] columns = table.getColumns();
        AbstractDialogTest.assertEquals((long)expectedTitles.length, (long)columns.length);
        int i = 0;
        while (i < columns.length) {
            TableColumn column = columns[i];
            AbstractDialogTest.assertEquals((Object)expectedTitles[i], (Object)column.getText());
            ++i;
        }
    }

    protected static void assertItems(Table table, String[][] expectedTitles2) {
        TableItem[] items = table.getItems();
        AbstractDialogTest.assertEquals((long)expectedTitles2.length, (long)items.length);
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            String[] expectedTitles = expectedTitles2[i];
            int j = 0;
            while (j < table.getColumnCount()) {
                AbstractDialogTest.assertEquals((Object)expectedTitles[j], (Object)item.getText(j));
                ++j;
            }
            ++i;
        }
    }

    protected static SourceComposite getSourceComposite(UiContext context, TabItem tabItem) {
        return UiContext.findFirstWidget((Widget)tabItem, SourceComposite.class);
    }

    protected static Table getSourceTable(UiContext context, TabItem tabItem) {
        SourceComposite sourceComposite = AbstractDialogTest.getSourceComposite(context, tabItem);
        return UiContext.findFirstWidget((Widget)sourceComposite, Table.class);
    }

    protected final void openDialogNLS(String initialSource, final NLSDialogRunnable runnable) throws Exception {
        this.openDialogNLS("test", initialSource, new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                Shell activeShell = context.useShell("Externalize strings");
                NlsDialog dialog = (NlsDialog)activeShell.getData("KEY_DIALOG");
                try {
                    TabFolder tabFolder = (TabFolder)ReflectionUtils.getFieldObject((Object)dialog, (String)"m_tabFolder");
                    runnable.run(context, dialog, tabFolder);
                }
                finally {
                    Button okButton = context.getButtonByText("OK");
                    context.click((Widget)okButton);
                }
            }
        });
    }

    protected static interface NLSDialogRunnable {
        public void run(UiContext var1, NlsDialog var2, TabFolder var3) throws Exception;
    }
}

