/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.palette;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.editor.palette.model.PaletteInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.gef.core.requests.ICreationFactory;
import org.eclipse.wb.gef.core.tools.CreationTool;
import org.eclipse.wb.internal.core.editor.palette.model.entry.StaticFactoryEntryInfo;
import org.eclipse.wb.internal.core.model.creation.factory.StaticFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.description.GenericPropertyDescription;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.tests.designer.core.palette.AbstractPaletteTest;
import org.eclipse.wb.tests.designer.tests.Activator;
import org.junit.Test;

public class StaticFactoryEntryInfoTest
extends AbstractPaletteTest {
    @Test
    public void test_access() throws Exception {
        StaticFactoryEntryInfo entry = new StaticFactoryEntryInfo();
        StaticFactoryEntryInfoTest.assertNull((Object)entry.getFactoryClassName());
        entry.setFactoryClassName("test.StaticFactory");
        StaticFactoryEntryInfoTest.assertEquals((Object)"test.StaticFactory", (Object)entry.getFactoryClassName());
        StaticFactoryEntryInfoTest.assertNull((Object)entry.getMethodSignature());
        entry.setMethodSignature("createButton()");
        StaticFactoryEntryInfoTest.assertEquals((Object)"createButton()", (Object)entry.getMethodSignature());
        StaticFactoryEntryInfoTest.assertEquals((Object)"StaticFactoryMethod(class='test.StaticFactory' signature='createButton()')", (Object)entry.toString());
    }

    @Test
    public void test_parse_defaults() throws Exception {
        StaticFactoryEntryInfoTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton createButton() {", "    return new JButton();", "  }", "}"));
        StaticFactoryEntryInfoTest.waitForAutoBuild();
        StaticFactoryEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1' description='category 1'>", "  <static-factory class='test.StaticFactory'>", "    <method signature='createButton()'/>", "  </static-factory>", "</category>"});
        PaletteInfo palette = this.loadPalette();
        CategoryInfo category = palette.getCategory("category_1");
        StaticFactoryEntryInfo entry = (StaticFactoryEntryInfo)category.getEntries().get(0);
        StaticFactoryEntryInfoTest.assertTrue((boolean)entry.initialize(null, this.m_lastParseInfo));
        StaticFactoryEntryInfoTest.assertSame((Object)category, (Object)entry.getCategory());
        StaticFactoryEntryInfoTest.assertEquals((Object)"test.StaticFactory", (Object)entry.getFactoryClassName());
        StaticFactoryEntryInfoTest.assertEquals((Object)"createButton()", (Object)entry.getMethodSignature());
        StaticFactoryEntryInfoTest.assertEquals((Object)"category_1 test.StaticFactory createButton()", (Object)entry.getId());
        StaticFactoryEntryInfoTest.assertEquals((Object)"createButton()", (Object)entry.getName());
        StaticFactoryEntryInfoTest.assertEquals((Object)"Class: test.StaticFactory<br/>Method: createButton()", (Object)entry.getDescription());
    }

    @Test
    public void test_parse_values() throws Exception {
        StaticFactoryEntryInfoTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton createButton() {", "    return new JButton();", "  }", "}"));
        StaticFactoryEntryInfoTest.waitForAutoBuild();
        StaticFactoryEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1' description='category 1'>", "  <static-factory class='test.StaticFactory'>", "    <method signature='createButton()' id='my id' name='my name' description='my description'/>", "  </static-factory>", "</category>"});
        PaletteInfo palette = this.loadPalette();
        CategoryInfo category = palette.getCategory("category_1");
        StaticFactoryEntryInfo entry = (StaticFactoryEntryInfo)category.getEntries().get(0);
        StaticFactoryEntryInfoTest.assertSame((Object)category, (Object)entry.getCategory());
        StaticFactoryEntryInfoTest.assertEquals((Object)"test.StaticFactory", (Object)entry.getFactoryClassName());
        StaticFactoryEntryInfoTest.assertEquals((Object)"createButton()", (Object)entry.getMethodSignature());
        StaticFactoryEntryInfoTest.assertEquals((Object)"my id", (Object)entry.getId());
        StaticFactoryEntryInfoTest.assertEquals((Object)"my name", (Object)entry.getName());
        StaticFactoryEntryInfoTest.assertEquals((Object)"my description", (Object)entry.getDescription());
    }

    @Test
    public void test_parse_presentationName_no() throws Exception {
        this.assertPresentationName_fromFactoryDescription(null);
    }

    @Test
    public void test_parse_presentationName_emptyString() throws Exception {
        this.assertPresentationName_fromFactoryDescription("");
    }

    @Test
    public void test_parse_presentationName_signature() throws Exception {
        this.assertPresentationName_fromFactoryDescription("createButton()");
    }

    private void assertPresentationName_fromFactoryDescription(String nameAttribute) throws Exception {
        StaticFactoryEntryInfoTest.setFileContentSrc("test/MyFactory.java", this.getTestSource("public class MyFactory {", "  public static JButton createButton() {", "    return new JButton();", "  }", "}"));
        StaticFactoryEntryInfoTest.setFileContentSrc("test/MyFactory.wbp-factory.xml", StaticFactoryEntryInfoTest.getSource("<factory>", "  <method name='createButton'>", "    <name>Name in XML</name>", "  </method>", "</factory>"));
        StaticFactoryEntryInfoTest.waitForAutoBuild();
        Object nameAttributeSrc = nameAttribute != null ? "name='" + nameAttribute + "'" : "";
        StaticFactoryEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "    <static-factory class='test.MyFactory'>", "      <method signature='createButton()' " + (String)nameAttributeSrc + "/>", "    </static-factory>", "</category>"});
        PaletteInfo palette = this.loadPalette();
        CategoryInfo category = palette.getCategory("category_1");
        StaticFactoryEntryInfo entry = (StaticFactoryEntryInfo)category.getEntries().get(0);
        StaticFactoryEntryInfoTest.assertTrue((boolean)entry.initialize(null, this.m_lastParseInfo));
        StaticFactoryEntryInfoTest.assertEquals((Object)"Name in XML", (Object)entry.getName());
    }

    @Test
    public void test_parse_descriptionText_emptyString() throws Exception {
        this.assertDescriptionText_fromFactoryDescription("");
    }

    @Test
    public void test_parse_descriptionText_spacesString() throws Exception {
        this.assertDescriptionText_fromFactoryDescription(" \t");
    }

    @Test
    public void test_parse_descriptionText_classAndSignature() throws Exception {
        this.assertDescriptionText_fromFactoryDescription("Class: test.MyFactory Method: createButton()");
    }

    private void assertDescriptionText_fromFactoryDescription(String descriptionAttribute) throws Exception {
        StaticFactoryEntryInfoTest.setFileContentSrc("test/MyFactory.java", this.getTestSource("public class MyFactory {", "  public static JButton createButton() {", "    return new JButton();", "  }", "}"));
        StaticFactoryEntryInfoTest.setFileContentSrc("test/MyFactory.wbp-factory.xml", StaticFactoryEntryInfoTest.getSource("<factory>", "  <method name='createButton'>", "    <description>Description in XML</description>", "  </method>", "</factory>"));
        StaticFactoryEntryInfoTest.waitForAutoBuild();
        StaticFactoryEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "    <static-factory class='test.MyFactory'>", "      <method signature='createButton()' name='f' description='" + descriptionAttribute + "'/>", "    </static-factory>", "</category>"});
        PaletteInfo palette = this.loadPalette();
        CategoryInfo category = palette.getCategory("category_1");
        StaticFactoryEntryInfo entry = (StaticFactoryEntryInfo)category.getEntries().get(0);
        StaticFactoryEntryInfoTest.assertTrue((boolean)entry.initialize(null, this.m_lastParseInfo));
        StaticFactoryEntryInfoTest.assertEquals((Object)"Description in XML", (Object)entry.getDescription());
    }

    @Test
    public void test_initialize_noFactoryClass() throws Exception {
        StaticFactoryEntryInfoTest.waitForAutoBuild();
        JavaInfo panel = this.parseEmptyPanel();
        StaticFactoryEntryInfo entry = new StaticFactoryEntryInfo();
        entry.setFactoryClassName("test.StaticFactory");
        entry.setMethodSignature("createButton()");
        StaticFactoryEntryInfoTest.assertEquals((long)0L, (long)this.m_lastState.getWarnings().size());
        StaticFactoryEntryInfoTest.assertFalse((boolean)entry.initialize(null, panel));
        Assertions.assertThat((List)this.m_lastState.getWarnings()).isEmpty();
    }

    @Test
    public void test_initialize_noFactoryMethod() throws Exception {
        StaticFactoryEntryInfoTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public final class StaticFactory {", "}"));
        StaticFactoryEntryInfoTest.waitForAutoBuild();
        JavaInfo panel = this.parseEmptyPanel();
        StaticFactoryEntryInfo entry = new StaticFactoryEntryInfo();
        entry.setFactoryClassName("test.StaticFactory");
        entry.setMethodSignature("noSuchMethod()");
        StaticFactoryEntryInfoTest.assertEquals((long)0L, (long)this.m_lastState.getWarnings().size());
        StaticFactoryEntryInfoTest.assertFalse((boolean)entry.initialize(null, panel));
        Assertions.assertThat((List)this.m_lastState.getWarnings()).isEmpty();
    }

    @Test
    public void test_initialize() throws Exception {
        StaticFactoryEntryInfoTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton createButton() {", "    return new JButton();", "  }", "}"));
        StaticFactoryEntryInfoTest.waitForAutoBuild();
        JavaInfo panel = this.parseEmptyPanel();
        StaticFactoryEntryInfo entry = new StaticFactoryEntryInfo();
        entry.setFactoryClassName("test.StaticFactory");
        entry.setMethodSignature("createButton()");
        StaticFactoryEntryInfoTest.assertTrue((boolean)entry.initialize(null, panel));
        ImageDescriptor icon = entry.getIcon();
        StaticFactoryEntryInfoTest.assertNotNull((Object)icon);
        StaticFactoryEntryInfoTest.assertEquals((long)16L, (long)icon.getImageData((int)100).width);
        StaticFactoryEntryInfoTest.assertEquals((long)16L, (long)icon.getImageData((int)100).height);
    }

    @Test
    public void test_initialize_iconAndDescription() throws Exception {
        StaticFactoryEntryInfoTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton createButton() {", "    return new JButton();", "  }", "}"));
        StaticFactoryEntryInfoTest.setFileContentSrc("test/StaticFactory.wbp-factory.xml", StaticFactoryEntryInfoTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<factory>", "  <method name='createButton'>", "    <description>Some textual description of method.</description>", "  </method>", "</factory>"));
        IFile iconFile = StaticFactoryEntryInfoTest.getFileSrc("test", "StaticFactory.createButton__.png");
        iconFile.create(Activator.getFile("icons/test.png"), true, null);
        StaticFactoryEntryInfoTest.waitForAutoBuild();
        JavaInfo panel = this.parseEmptyPanel();
        StaticFactoryEntryInfo entry = new StaticFactoryEntryInfo();
        entry.setFactoryClassName("test.StaticFactory");
        entry.setMethodSignature("createButton()");
        StaticFactoryEntryInfoTest.assertTrue((boolean)entry.initialize(null, panel));
        StaticFactoryEntryInfoTest.assertEquals((Object)"Some textual description of method.", (Object)entry.getDescription());
        StaticFactoryEntryInfoTest.assertSame((Object)entry.getMethodDescription().getIcon(), (Object)ReflectionUtils.getFieldObject((Object)entry, (String)"m_icon"));
    }

    @Test
    public void test_createTool() throws Exception {
        StaticFactoryEntryInfoTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton createButton() {", "    return new JButton();", "  }", "}"));
        StaticFactoryEntryInfoTest.waitForAutoBuild();
        StaticFactoryEntryInfoTest.waitEventLoop(10);
        StaticFactoryEntryInfoTest.waitForAutoBuild();
        JavaInfo panel = this.parseEmptyPanel();
        StaticFactoryEntryInfo entry = new StaticFactoryEntryInfo();
        entry.setFactoryClassName("test.StaticFactory");
        entry.setMethodSignature("createButton()");
        StaticFactoryEntryInfoTest.assertTrue((boolean)entry.initialize(null, panel));
        CreationTool creationTool = (CreationTool)entry.createTool();
        ICreationFactory factory = creationTool.getFactory();
        factory.activate();
        JavaInfo javaInfo = (JavaInfo)factory.getNewObject();
        StaticFactoryEntryInfoTest.assertSame((Object)Boolean.TRUE, (Object)javaInfo.getArbitraryValue((Object)"manuallyCreatedComponent"));
        StaticFactoryCreationSupport creationSupport = (StaticFactoryCreationSupport)javaInfo.getCreationSupport();
        StaticFactoryEntryInfoTest.assertEquals((Object)"test.StaticFactory.createButton()", (Object)creationSupport.add_getSource(null));
    }

    @Test
    public void test_createTool_factoryMethodSpecific_ComponentDescription() throws Exception {
        StaticFactoryEntryInfoTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton createButton() {", "    return new JButton();", "  }", "}"));
        StaticFactoryEntryInfoTest.setFileContentSrc("test/StaticFactory.createButton__.wbp-component.xml", StaticFactoryEntryInfoTest.getSource("<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <properties-preferred names='enabled'/>", "</component>"));
        StaticFactoryEntryInfoTest.waitForAutoBuild();
        JavaInfo panel = this.parseEmptyPanel();
        StaticFactoryEntryInfo entry = new StaticFactoryEntryInfo();
        entry.setFactoryClassName("test.StaticFactory");
        entry.setMethodSignature("createButton()");
        StaticFactoryEntryInfoTest.assertTrue((boolean)entry.initialize(null, panel));
        CreationTool creationTool = (CreationTool)entry.createTool();
        ICreationFactory factory = creationTool.getFactory();
        factory.activate();
        JavaInfo javaInfo = (JavaInfo)factory.getNewObject();
        GenericPropertyDescription propertyDescription = javaInfo.getDescription().getProperty("setEnabled(boolean)");
        StaticFactoryEntryInfoTest.assertSame((Object)PropertyCategory.PREFERRED, (Object)propertyDescription.getCategory());
    }
}

