/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.util.jdt.core;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.wb.internal.core.utils.jdt.core.JavaDocUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.tests.designer.core.AbstractJavaTest;
import org.eclipse.wb.tests.designer.core.util.jdt.core.CodeUtilsTest;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class JavaDocUtilsTest
extends AbstractJavaTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        if (m_testProject == null) {
            JavaDocUtilsTest.do_projectCreate();
        }
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Ignore
    @Test
    public void test_getTooltip_basic() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {", "  void test() {", "    foo_1();", "    foo_2();", "    bar();", "    new sun.awt.Mutex().lock();", "  }", "  /**", "  * My   tooltip.", "  */", "  void foo_1() {", "  }", "  /**", "  * My tooltip with <code>tags</code>.", "  */", "  void foo_2() {", "  }", "  void bar() {", "  }", "}");
        IMethodBinding[] methodBindings = CodeUtilsTest.getInvocationBindings(typeDeclaration, 0);
        JavaDocUtilsTest.assertEquals((Object)"My tooltip.", (Object)this.getTooltip(methodBindings[0]));
        JavaDocUtilsTest.assertEquals((Object)"My tooltip with <code>tags</code>.", (Object)this.getTooltip(methodBindings[1]));
        JavaDocUtilsTest.assertNull((Object)this.getTooltip(methodBindings[2]));
        JavaDocUtilsTest.assertNull((Object)this.getTooltip(methodBindings[2]));
    }

    @Test
    public void test_getTooltip_shortenTypeReferences() throws Exception {
        IType type = this.createModelType("test", "Test.java", JavaDocUtilsTest.getSource("package test;", "class Test {", "  /**", "  * Method {@link java.util.List#add(Object)} reference with long type.", "  */", "  void foo() {", "  }", "}"));
        String tooltip = JavaDocUtils.getTooltip((IMember)type.getMethods()[0]);
        JavaDocUtilsTest.assertEquals((Object)"Method {@link List#add(Object)} reference with long type.", (Object)tooltip);
    }

    private String getTooltip(IMethodBinding methodBinding) throws Exception {
        return JavaDocUtils.getTooltip((IJavaProject)this.m_lastEditor.getJavaProject(), (IMethodBinding)methodBinding);
    }

    @Test
    public void test_getTooltip_useInherited() throws Exception {
        this.createModelCompilationUnit("test", "A.java", JavaDocUtilsTest.getSource("package test;", "class A {", "  /**", "  * Inherited Javadoc.", "  */", "  void foo() {", "  }", "}"));
        ICompilationUnit bUnit = this.createModelCompilationUnit("test", "B.java", JavaDocUtilsTest.getSource("package test;", "class B extends A {", "  void foo() {", "  }", "}"));
        IMethod method = bUnit.getTypes()[0].getMethods()[0];
        String javaDoc = JavaDocUtils.getTooltip((IMember)method);
        JavaDocUtilsTest.assertEquals((Object)"Inherited Javadoc.", (Object)javaDoc);
    }

    @Test
    public void test_getTooltip_useShortTypeNames() throws Exception {
        String input;
        String expected = input = "";
        String actual = JavaDocUtilsTest.call_getTooltip_useShortTypeNames(input);
        JavaDocUtilsTest.assertEquals((Object)expected, (Object)actual);
        expected = input = "The {@link java.util.List#add(Object) method.";
        actual = JavaDocUtilsTest.call_getTooltip_useShortTypeNames(input);
        JavaDocUtilsTest.assertEquals((Object)expected, (Object)actual);
        expected = input = "The {@link List#add(Object)} method.";
        actual = JavaDocUtilsTest.call_getTooltip_useShortTypeNames(input);
        JavaDocUtilsTest.assertEquals((Object)expected, (Object)actual);
        input = "The {@link java.util.List#add(Object)} method.";
        expected = "The {@link List#add(Object)} method.";
        actual = JavaDocUtilsTest.call_getTooltip_useShortTypeNames(input);
        JavaDocUtilsTest.assertEquals((Object)expected, (Object)actual);
    }

    private static String call_getTooltip_useShortTypeNames(String s) {
        return (String)ReflectionUtils.invokeMethodEx(JavaDocUtils.class, (String)"getTooltip_useShortTypeNames(java.lang.String)", (Object[])new Object[]{s});
    }
}

