/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.widgets;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.generic.FlowContainer;
import org.eclipse.wb.internal.core.model.generic.FlowContainerFactory;
import org.eclipse.wb.internal.rcp.model.widgets.CoolBarInfo;
import org.eclipse.wb.internal.rcp.model.widgets.CoolItemInfo;
import org.eclipse.wb.internal.swt.model.layout.RowLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.BTestUtils;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Test;

public class CoolBarTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_isHorizontal() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    CoolBar toolBar_1 = new CoolBar(this, SWT.NONE);", "    CoolBar toolBar_2 = new CoolBar(this, SWT.VERTICAL);", "  }", "}");
        shell.refresh();
        CoolBarInfo toolBar_1 = (CoolBarInfo)shell.getChildren(CoolBarInfo.class).get(0);
        CoolBarTest.assertTrue((boolean)toolBar_1.isHorizontal());
        CoolBarTest.assertTrue((boolean)CoolBarTest.getFlowContainer(toolBar_1).isHorizontal());
        CoolBarInfo toolBar_2 = (CoolBarInfo)shell.getChildren(CoolBarInfo.class).get(1);
        CoolBarTest.assertFalse((boolean)toolBar_2.isHorizontal());
        CoolBarTest.assertFalse((boolean)CoolBarTest.getFlowContainer(toolBar_2).isHorizontal());
    }

    @Test
    public void test_parseItems() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      CoolBar coolBar = new CoolBar(this, SWT.FLAT);", "      {", "        CoolItem item = new CoolItem(coolBar, SWT.NONE);", "        item.setText('000');", "      }", "      {", "        CoolItem item = new CoolItem(coolBar, SWT.NONE);", "        item.setText('111');", "      }", "    }", "  }", "}");
        shell.refresh();
        CoolBarInfo coolBar = (CoolBarInfo)shell.getChildrenControls().get(0);
        List items = coolBar.getItems();
        CoolBarTest.assertEquals((long)2L, (long)items.size());
        CoolItemInfo item_0 = (CoolItemInfo)items.get(0);
        CoolItemInfo item_1 = (CoolItemInfo)items.get(1);
        CoolBarTest.assertEquals((Object)"000", (Object)item_0.getWidget().getText());
        CoolBarTest.assertEquals((Object)"111", (Object)item_1.getWidget().getText());
        Rectangle modelBounds = item_0.getModelBounds();
        Assertions.assertThat((int)modelBounds.width).isGreaterThan(15);
        Assertions.assertThat((int)modelBounds.height).isGreaterThan(20);
        CoolBarTest.assertNull((Object)item_0.getControl());
        Assertions.assertThat((List)item_0.getPresentation().getChildrenTree()).containsOnly((Object[])new ObjectInfo[0]);
    }

    @Test
    public void test_setControl_get() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    CoolBar coolBar = new CoolBar(this, SWT.FLAT);", "    {", "      CoolItem item = new CoolItem(coolBar, SWT.SEPARATOR);", "      {", "        Button button = new Button(coolBar, SWT.NONE);", "        item.setControl(button);", "        button.setText('My Button');", "      }", "    }", "  }", "}");
        shell.refresh();
        CoolBarInfo coolBar = (CoolBarInfo)shell.getChildrenControls().get(0);
        CoolItemInfo item = (CoolItemInfo)coolBar.getItems().get(0);
        ControlInfo button = (ControlInfo)coolBar.getChildrenControls().get(0);
        CoolBarTest.assertSame((Object)button, (Object)item.getControl());
        Assertions.assertThat((List)item.getSimpleContainerChildren()).containsExactly((Object[])new ObjectInfo[]{button});
        Assertions.assertThat((int)button.getBounds().width).isGreaterThan(70);
        Assertions.assertThat((int)item.getBounds().width).isGreaterThan(80);
        Assertions.assertThat((List)item.getPresentation().getChildrenTree()).containsExactly((Object[])new ObjectInfo[]{button});
        Assertions.assertThat((List)item.getPresentation().getChildrenGraphical()).containsExactly((Object[])new ObjectInfo[]{button});
        Assertions.assertThat((List)coolBar.getPresentation().getChildrenTree()).containsExactly((Object[])new ObjectInfo[]{item});
        Assertions.assertThat((List)coolBar.getPresentation().getChildrenGraphical()).containsExactly((Object[])new ObjectInfo[]{item});
    }

    @Test
    public void test_setControl_CREATE() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    CoolBar coolBar = new CoolBar(this, SWT.FLAT);", "    {", "      CoolItem item = new CoolItem(coolBar, SWT.SEPARATOR);", "    }", "  }", "}");
        shell.refresh();
        CoolBarInfo coolBar = (CoolBarInfo)shell.getChildrenControls().get(0);
        CoolItemInfo item = (CoolItemInfo)coolBar.getItems().get(0);
        CoolBarTest.assertNull((Object)item.getControl());
        Assertions.assertThat((List)item.getSimpleContainerChildren()).isEmpty();
        ControlInfo button = BTestUtils.createButton();
        CoolBarTest.simpleContainer_CREATE((JavaInfo)item, button);
        CoolBarTest.assertSame((Object)button, (Object)item.getControl());
        Assertions.assertThat((List)item.getSimpleContainerChildren()).containsExactly((Object[])new ObjectInfo[]{button});
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    CoolBar coolBar = new CoolBar(this, SWT.FLAT);", "    {", "      CoolItem item = new CoolItem(coolBar, SWT.SEPARATOR);", "      {", "        Button button = new Button(coolBar, SWT.NONE);", "        item.setControl(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_setControl_ADD() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    CoolBar coolBar = new CoolBar(this, SWT.FLAT);", "    {", "      CoolItem item = new CoolItem(coolBar, SWT.SEPARATOR);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        CoolBarInfo coolBar = (CoolBarInfo)shell.getChildrenControls().get(0);
        CoolItemInfo item = (CoolItemInfo)coolBar.getItems().get(0);
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(1);
        CoolBarTest.assertNull((Object)item.getControl());
        CoolBarTest.simpleContainer_ADD((JavaInfo)item, button);
        CoolBarTest.assertSame((Object)button, (Object)item.getControl());
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    CoolBar coolBar = new CoolBar(this, SWT.FLAT);", "    {", "      CoolItem item = new CoolItem(coolBar, SWT.SEPARATOR);", "      {", "        Button button = new Button(coolBar, SWT.NONE);", "        item.setControl(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_setControl_MOVE() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    CoolBar coolBar = new CoolBar(this, SWT.FLAT);", "    {", "      CoolItem item_1 = new CoolItem(coolBar, SWT.SEPARATOR);", "    }", "    {", "      CoolItem item_2 = new CoolItem(coolBar, SWT.SEPARATOR);", "      {", "        Button button = new Button(coolBar, SWT.NONE);", "        item_2.setControl(button);", "      }", "    }", "  }", "}");
        shell.refresh();
        CoolBarInfo coolBar = (CoolBarInfo)shell.getChildrenControls().get(0);
        CoolItemInfo item_1 = (CoolItemInfo)coolBar.getItems().get(0);
        CoolItemInfo item_2 = (CoolItemInfo)coolBar.getItems().get(1);
        ControlInfo button = item_2.getControl();
        CoolBarTest.assertEquals((long)(coolBar.getChildrenJava().indexOf(item_2) + 1), (long)coolBar.getChildrenJava().indexOf(button));
        CoolBarTest.simpleContainer_ADD((JavaInfo)item_1, button);
        CoolBarTest.assertNull((Object)item_2.getControl());
        CoolBarTest.assertSame((Object)button, (Object)item_1.getControl());
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    CoolBar coolBar = new CoolBar(this, SWT.FLAT);", "    {", "      CoolItem item_1 = new CoolItem(coolBar, SWT.SEPARATOR);", "      {", "        Button button = new Button(coolBar, SWT.NONE);", "        item_1.setControl(button);", "      }", "    }", "    {", "      CoolItem item_2 = new CoolItem(coolBar, SWT.SEPARATOR);", "    }", "  }", "}");
        CoolBarTest.assertEquals((long)(coolBar.getChildrenJava().indexOf(item_1) + 1), (long)coolBar.getChildrenJava().indexOf(button));
    }

    @Test
    public void test_setControl_MOVEItem() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    CoolBar coolBar = new CoolBar(this, SWT.FLAT);", "    {", "      CoolItem item_1 = new CoolItem(coolBar, SWT.NONE);", "    }", "    {", "      CoolItem item_2 = new CoolItem(coolBar, SWT.SEPARATOR);", "      {", "        Button button = new Button(coolBar, SWT.NONE);", "        item_2.setControl(button);", "      }", "    }", "  }", "}");
        shell.refresh();
        CoolBarInfo coolBar = (CoolBarInfo)shell.getChildrenControls().get(0);
        CoolItemInfo item_1 = (CoolItemInfo)coolBar.getItems().get(0);
        CoolItemInfo item_2 = (CoolItemInfo)coolBar.getItems().get(1);
        ControlInfo button = item_2.getControl();
        CoolBarTest.assertEquals((long)(coolBar.getChildrenJava().indexOf(item_2) + 1), (long)coolBar.getChildrenJava().indexOf(button));
        CoolBarTest.flowContainer_MOVE((JavaInfo)coolBar, item_2, item_1);
        CoolBarTest.assertSame((Object)button, (Object)item_2.getControl());
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    CoolBar coolBar = new CoolBar(this, SWT.FLAT);", "    {", "      CoolItem item_2 = new CoolItem(coolBar, SWT.SEPARATOR);", "      {", "        Button button = new Button(coolBar, SWT.NONE);", "        item_2.setControl(button);", "      }", "    }", "    {", "      CoolItem item_1 = new CoolItem(coolBar, SWT.NONE);", "    }", "  }", "}");
        CoolBarTest.assertEquals((long)(coolBar.getChildrenJava().indexOf(item_2) + 1), (long)coolBar.getChildrenJava().indexOf(button));
    }

    @Test
    public void test_setControl_moveOut() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    CoolBar coolBar = new CoolBar(this, SWT.FLAT);", "    {", "      CoolItem item = new CoolItem(coolBar, SWT.SEPARATOR);", "      {", "        Button button = new Button(coolBar, SWT.NONE);", "        item.setControl(button);", "      }", "    }", "  }", "}");
        shell.refresh();
        RowLayoutInfo rowLayout = (RowLayoutInfo)shell.getLayout();
        CoolBarInfo coolBar = (CoolBarInfo)shell.getChildrenControls().get(0);
        CoolItemInfo item = (CoolItemInfo)coolBar.getItems().get(0);
        ControlInfo button = item.getControl();
        CoolBarTest.flowContainer_MOVE((JavaInfo)rowLayout, button, null);
        CoolBarTest.assertNull((Object)item.getControl());
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    CoolBar coolBar = new CoolBar(this, SWT.FLAT);", "    {", "      CoolItem item = new CoolItem(coolBar, SWT.SEPARATOR);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      CoolBar coolBar = new CoolBar(this, SWT.FLAT);", "    }", "  }", "}");
        shell.refresh();
        CoolBarInfo coolBar = (CoolBarInfo)shell.getChildrenControls().get(0);
        CoolItemInfo coolItem = (CoolItemInfo)CoolBarTest.createJavaInfo("org.eclipse.swt.widgets.CoolItem", null);
        CoolBarTest.flowContainer_CREATE((JavaInfo)coolBar, coolItem, null);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      CoolBar coolBar = new CoolBar(this, SWT.FLAT);", "      {", "        CoolItem coolItem = new CoolItem(coolBar, SWT.NONE);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      CoolBar coolBar = new CoolBar(this, SWT.FLAT);", "      {", "        CoolItem item = new CoolItem(coolBar, SWT.NONE);", "        item.setText('000');", "      }", "      {", "        CoolItem item = new CoolItem(coolBar, SWT.NONE);", "        item.setText('111');", "      }", "    }", "  }", "}");
        shell.refresh();
        CoolBarInfo coolBar = (CoolBarInfo)shell.getChildrenControls().get(0);
        List items = coolBar.getItems();
        CoolItemInfo item_2 = (CoolItemInfo)items.get(1);
        CoolItemInfo item_1 = (CoolItemInfo)items.get(0);
        CoolBarTest.flowContainer_MOVE((JavaInfo)coolBar, item_2, item_1);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      CoolBar coolBar = new CoolBar(this, SWT.FLAT);", "      {", "        CoolItem item = new CoolItem(coolBar, SWT.NONE);", "        item.setText('111');", "      }", "      {", "        CoolItem item = new CoolItem(coolBar, SWT.NONE);", "        item.setText('000');", "      }", "    }", "  }", "}");
    }

    private static FlowContainer getFlowContainer(CoolBarInfo coolBar) {
        return (FlowContainer)new FlowContainerFactory((JavaInfo)coolBar, true).get().get(0);
    }
}

