/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.widgets;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.rcp.model.widgets.ExpandBarInfo;
import org.eclipse.wb.internal.rcp.model.widgets.ExpandItemInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.BTestUtils;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Ignore;
import org.junit.Test;

public class ExpandBarTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Ignore
    @Test
    public void test_parseItems() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setSize(500, 350);", "    setLayout(new FillLayout());", "    {", "      ExpandBar expandBar = new ExpandBar(this, SWT.NONE);", "      {", "        ExpandItem item = new ExpandItem(expandBar, SWT.NONE);", "        item.setText('000');", "      }", "      {", "        ExpandItem item = new ExpandItem(expandBar, SWT.NONE);", "        item.setText('111');", "        item.setHeight(200);", "        item.setExpanded(true);", "      }", "    }", "  }", "}");
        shell.refresh();
        ExpandBarInfo expandBar = (ExpandBarInfo)shell.getChildrenControls().get(0);
        List items = expandBar.getItems();
        Assertions.assertThat((List)items).hasSize(2);
        ExpandItemInfo item_0 = (ExpandItemInfo)items.get(0);
        ExpandItemInfo item_1 = (ExpandItemInfo)items.get(1);
        ExpandBarTest.assertEquals((Object)"000", (Object)item_0.getWidget().getText());
        ExpandBarTest.assertEquals((Object)"111", (Object)item_1.getWidget().getText());
        Rectangle modelBounds_0 = item_0.getModelBounds();
        Assertions.assertThat((int)modelBounds_0.width).isGreaterThan(450);
        Assertions.assertThat((int)modelBounds_0.height).isGreaterThan(20);
        Rectangle modelBounds_1 = item_1.getModelBounds();
        Assertions.assertThat((int)modelBounds_1.width).isGreaterThan(450);
        Assertions.assertThat((int)modelBounds_1.height).isGreaterThan(220);
        ExpandBarTest.assertNull((Object)item_0.getControl());
        Assertions.assertThat((List)item_0.getPresentation().getChildrenTree()).isEmpty();
    }

    @Test
    public void test_presentationChildrenGraphical() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ExpandBar expandBar = new ExpandBar(this, SWT.NONE);", "    {", "      ExpandItem item_1 = new ExpandItem(expandBar, SWT.NONE);", "      item_1.setExpanded(true);", "      {", "        Button button_1 = new Button(expandBar, SWT.NONE);", "        item_1.setControl(button_1);", "      }", "    }", "    {", "      ExpandItem item_2 = new ExpandItem(expandBar, SWT.NONE);", "      item_2.setExpanded(false);", "      {", "        Button button_2 = new Button(expandBar, SWT.NONE);", "        item_2.setControl(button_2);", "      }", "    }", "  }", "}");
        shell.refresh();
        ExpandBarInfo expandBar = (ExpandBarInfo)ExpandBarTest.getJavaInfoByName("expandBar");
        ExpandItemInfo item_1 = (ExpandItemInfo)ExpandBarTest.getJavaInfoByName("item_1");
        ExpandItemInfo item_2 = (ExpandItemInfo)ExpandBarTest.getJavaInfoByName("item_2");
        ControlInfo button_1 = (ControlInfo)ExpandBarTest.getJavaInfoByName("button_1");
        ExpandBarTest.assertEquals((Object)true, (Object)item_1.getPropertyByTitle("expanded").getValue());
        ExpandBarTest.assertEquals((Object)false, (Object)item_2.getPropertyByTitle("expanded").getValue());
        Assertions.assertThat((List)expandBar.getPresentation().getChildrenGraphical()).containsExactly((Object[])new ObjectInfo[]{item_1, item_2});
        Assertions.assertThat((List)item_1.getPresentation().getChildrenGraphical()).containsExactly((Object[])new ObjectInfo[]{button_1});
        Assertions.assertThat((List)item_2.getPresentation().getChildrenGraphical()).isEmpty();
    }

    @Test
    public void test_setControl_get() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ExpandBar expandBar = new ExpandBar(this, SWT.NONE);", "    {", "      ExpandItem item = new ExpandItem(expandBar, SWT.NONE);", "      item.setExpanded(true);", "      item.setHeight(200);", "      {", "        Button button = new Button(expandBar, SWT.NONE);", "        item.setControl(button);", "      }", "    }", "  }", "}");
        shell.refresh();
        ExpandBarInfo expandBar = (ExpandBarInfo)shell.getChildrenControls().get(0);
        ExpandItemInfo item = (ExpandItemInfo)expandBar.getItems().get(0);
        ControlInfo button = (ControlInfo)expandBar.getChildrenControls().get(0);
        ExpandBarTest.assertSame((Object)button, (Object)item.getControl());
        Assertions.assertThat((int)item.getBounds().height).isGreaterThan(200);
        Assertions.assertThat((int)button.getBounds().height).isGreaterThanOrEqualTo(195);
        Assertions.assertThat((int)button.getBounds().height).isLessThanOrEqualTo(205);
        Assertions.assertThat((List)item.getPresentation().getChildrenTree()).containsExactly((Object[])new ObjectInfo[]{button});
        Assertions.assertThat((List)item.getPresentation().getChildrenGraphical()).containsExactly((Object[])new ObjectInfo[]{button});
        Assertions.assertThat((List)expandBar.getPresentation().getChildrenTree()).containsExactly((Object[])new ObjectInfo[]{item});
        Assertions.assertThat((List)expandBar.getPresentation().getChildrenGraphical()).containsExactly((Object[])new ObjectInfo[]{item});
    }

    @Test
    public void test_setControl_CREATE() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ExpandBar expandBar = new ExpandBar(this, SWT.NONE);", "    {", "      ExpandItem item = new ExpandItem(expandBar, SWT.NONE);", "      item.setHeight(200);", "    }", "  }", "}");
        shell.refresh();
        ExpandBarInfo expandBar = (ExpandBarInfo)shell.getChildrenControls().get(0);
        ExpandItemInfo item = (ExpandItemInfo)expandBar.getItems().get(0);
        ExpandBarTest.assertNull((Object)item.getControl());
        ControlInfo button = BTestUtils.createButton();
        ExpandBarTest.simpleContainer_CREATE((JavaInfo)item, button);
        ExpandBarTest.assertSame((Object)button, (Object)item.getControl());
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ExpandBar expandBar = new ExpandBar(this, SWT.NONE);", "    {", "      ExpandItem item = new ExpandItem(expandBar, SWT.NONE);", "      item.setExpanded(true);", "      {", "        Button button = new Button(expandBar, SWT.NONE);", "        item.setControl(button);", "      }", "      item.setHeight(200);", "    }", "  }", "}");
    }

    @Test
    public void test_setControl_CREATE2() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ExpandBar expandBar = new ExpandBar(this, SWT.NONE);", "    {", "      ExpandItem item = new ExpandItem(expandBar, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        ExpandBarInfo expandBar = (ExpandBarInfo)shell.getChildrenControls().get(0);
        ExpandItemInfo item = (ExpandItemInfo)expandBar.getItems().get(0);
        ExpandBarTest.assertNull((Object)item.getControl());
        ControlInfo button = BTestUtils.createButton();
        ExpandBarTest.simpleContainer_CREATE((JavaInfo)item, button);
        ExpandBarTest.assertSame((Object)button, (Object)item.getControl());
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ExpandBar expandBar = new ExpandBar(this, SWT.NONE);", "    {", "      ExpandItem item = new ExpandItem(expandBar, SWT.NONE);", "      item.setExpanded(true);", "      {", "        Button button = new Button(expandBar, SWT.NONE);", "        item.setControl(button);", "      }", "      item.setHeight(item.getControl().computeSize(SWT.DEFAULT, SWT.DEFAULT).y);", "    }", "  }", "}");
    }

    @Test
    public void test_setControl_ADD() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ExpandBar expandBar = new ExpandBar(this, SWT.NONE);", "    {", "      ExpandItem item = new ExpandItem(expandBar, SWT.NONE);", "      item.setHeight(200);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        ExpandBarInfo expandBar = (ExpandBarInfo)shell.getChildrenControls().get(0);
        ExpandItemInfo item = (ExpandItemInfo)expandBar.getItems().get(0);
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(1);
        ExpandBarTest.assertNull((Object)item.getControl());
        ExpandBarTest.simpleContainer_ADD((JavaInfo)item, button);
        ExpandBarTest.assertSame((Object)button, (Object)item.getControl());
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ExpandBar expandBar = new ExpandBar(this, SWT.NONE);", "    {", "      ExpandItem item = new ExpandItem(expandBar, SWT.NONE);", "      item.setExpanded(true);", "      {", "        Button button = new Button(expandBar, SWT.NONE);", "        item.setControl(button);", "      }", "      item.setHeight(200);", "    }", "  }", "}");
    }

    @Test
    public void test_setControl_MOVE() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ExpandBar expandBar = new ExpandBar(this, SWT.NONE);", "    {", "      ExpandItem item_1 = new ExpandItem(expandBar, SWT.NONE);", "      item_1.setHeight(200);", "    }", "    {", "      ExpandItem item_2 = new ExpandItem(expandBar, SWT.NONE);", "      {", "        Button button = new Button(expandBar, SWT.NONE);", "        item_2.setControl(button);", "      }", "      item_2.setHeight(200);", "    }", "  }", "}");
        shell.refresh();
        ExpandBarInfo expandBar = (ExpandBarInfo)shell.getChildrenControls().get(0);
        ExpandItemInfo item_1 = (ExpandItemInfo)expandBar.getItems().get(0);
        ExpandItemInfo item_2 = (ExpandItemInfo)expandBar.getItems().get(1);
        ControlInfo button = item_2.getControl();
        Assertions.assertThat((List)expandBar.getChildrenJava()).containsSequence((Object[])new JavaInfo[]{item_2, button});
        ExpandBarTest.simpleContainer_ADD((JavaInfo)item_1, button);
        ExpandBarTest.assertNull((Object)item_2.getControl());
        ExpandBarTest.assertSame((Object)button, (Object)item_1.getControl());
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ExpandBar expandBar = new ExpandBar(this, SWT.NONE);", "    {", "      ExpandItem item_1 = new ExpandItem(expandBar, SWT.NONE);", "      item_1.setExpanded(true);", "      {", "        Button button = new Button(expandBar, SWT.NONE);", "        item_1.setControl(button);", "      }", "      item_1.setHeight(200);", "    }", "    {", "      ExpandItem item_2 = new ExpandItem(expandBar, SWT.NONE);", "    }", "  }", "}");
        ExpandBarTest.assertEquals((long)(expandBar.getChildrenJava().indexOf(item_1) + 1), (long)expandBar.getChildrenJava().indexOf(button));
    }

    @Test
    public void test_setControl_MOVEItem() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ExpandBar expandBar = new ExpandBar(this, SWT.NONE);", "    {", "      ExpandItem item_1 = new ExpandItem(expandBar, SWT.NONE);", "      item_1.setHeight(200);", "    }", "    {", "      ExpandItem item_2 = new ExpandItem(expandBar, SWT.NONE);", "      {", "        Button button = new Button(expandBar, SWT.NONE);", "        item_2.setControl(button);", "      }", "      item_2.setHeight(200);", "    }", "  }", "}");
        shell.refresh();
        ExpandBarInfo expandBar = (ExpandBarInfo)shell.getChildrenControls().get(0);
        ExpandItemInfo item_1 = (ExpandItemInfo)expandBar.getItems().get(0);
        ExpandItemInfo item_2 = (ExpandItemInfo)expandBar.getItems().get(1);
        ControlInfo button = item_2.getControl();
        ExpandBarTest.assertEquals((long)(expandBar.getChildrenJava().indexOf(item_2) + 1), (long)expandBar.getChildrenJava().indexOf(button));
        ExpandBarTest.flowContainer_MOVE((JavaInfo)expandBar, item_2, item_1);
        ExpandBarTest.assertSame((Object)button, (Object)item_2.getControl());
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ExpandBar expandBar = new ExpandBar(this, SWT.NONE);", "    {", "      ExpandItem item_2 = new ExpandItem(expandBar, SWT.NONE);", "      {", "        Button button = new Button(expandBar, SWT.NONE);", "        item_2.setControl(button);", "      }", "      item_2.setHeight(200);", "    }", "    {", "      ExpandItem item_1 = new ExpandItem(expandBar, SWT.NONE);", "      item_1.setHeight(200);", "    }", "  }", "}");
        ExpandBarTest.assertEquals((long)(expandBar.getChildrenJava().indexOf(item_2) + 1), (long)expandBar.getChildrenJava().indexOf(button));
    }

    @Test
    public void test_setControl_moveOut() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ExpandBar expandBar = new ExpandBar(this, SWT.NONE);", "    {", "      ExpandItem item = new ExpandItem(expandBar, SWT.NONE);", "      {", "        Button button = new Button(expandBar, SWT.NONE);", "        item.setControl(button);", "      }", "      item.setHeight(200);", "    }", "  }", "}");
        shell.refresh();
        ExpandBarInfo expandBar = (ExpandBarInfo)shell.getChildrenControls().get(0);
        ExpandItemInfo item = (ExpandItemInfo)expandBar.getItems().get(0);
        ControlInfo button = item.getControl();
        ExpandBarTest.flowContainer_MOVE((JavaInfo)shell.getLayout(), button, null);
        ExpandBarTest.assertNull((Object)item.getControl());
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ExpandBar expandBar = new ExpandBar(this, SWT.NONE);", "    {", "      ExpandItem item = new ExpandItem(expandBar, SWT.NONE);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      ExpandBar expandBar = new ExpandBar(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        ExpandBarInfo expandBar = (ExpandBarInfo)shell.getChildrenControls().get(0);
        ExpandItemInfo newItem = (ExpandItemInfo)ExpandBarTest.createJavaInfo("org.eclipse.swt.widgets.ExpandItem");
        ExpandBarTest.flowContainer_CREATE((JavaInfo)expandBar, newItem, null);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      ExpandBar expandBar = new ExpandBar(this, SWT.NONE);", "      {", "        ExpandItem expandItem = new ExpandItem(expandBar, SWT.NONE);", "        expandItem.setText('New ExpandItem');", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      ExpandBar expandBar = new ExpandBar(this, SWT.NONE);", "      {", "        ExpandItem item = new ExpandItem(expandBar, SWT.NONE);", "        item.setText('000');", "      }", "      {", "        ExpandItem item = new ExpandItem(expandBar, SWT.NONE);", "        item.setText('111');", "      }", "    }", "  }", "}");
        shell.refresh();
        ExpandBarInfo expandBar = (ExpandBarInfo)shell.getChildrenControls().get(0);
        List items = expandBar.getItems();
        ExpandItemInfo item_1 = (ExpandItemInfo)items.get(1);
        ExpandItemInfo item_0 = (ExpandItemInfo)items.get(0);
        ExpandBarTest.flowContainer_MOVE((JavaInfo)expandBar, item_1, item_0);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      ExpandBar expandBar = new ExpandBar(this, SWT.NONE);", "      {", "        ExpandItem item = new ExpandItem(expandBar, SWT.NONE);", "        item.setText('111');", "      }", "      {", "        ExpandItem item = new ExpandItem(expandBar, SWT.NONE);", "        item.setText('000');", "      }", "    }", "  }", "}");
    }
}

