/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.widgets;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.internal.rcp.model.widgets.TableCursorInfo;
import org.eclipse.wb.internal.rcp.model.widgets.TableInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Test;

public class TableTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_TableCursor_parse() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    Table table = new Table(this, SWT.BORDER);", "    {", "      TableCursor tableCursor = new TableCursor(table, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        Assertions.assertThat((List)table.getChildren(TableCursorInfo.class)).hasSize(1);
        TableTest.assertTrue((boolean)table.hasTableCursor());
    }

    @Test
    public void test_TableCursor_new() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    Table table = new Table(this, SWT.BORDER);", "  }", "}");
        shell.refresh();
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        TableTest.assertFalse((boolean)table.hasTableCursor());
        TableCursorInfo tableCursor = (TableCursorInfo)TableTest.createJavaInfo("org.eclipse.swt.custom.TableCursor");
        table.command_CREATE(tableCursor);
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    Table table = new Table(this, SWT.BORDER);", "    {", "      TableCursor tableCursor = new TableCursor(table, SWT.NONE);", "    }", "  }", "}");
        TableTest.assertTrue((boolean)table.hasTableCursor());
    }
}

