/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.model;

import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.gef.AbstractLayoutPolicyTest;
import org.junit.Test;

public class FlowLayoutGefTest
extends AbstractLayoutPolicyTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_setLayout() throws Exception {
        String[] source = new String[]{"public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      final JButton button = new JButton('New button');", "      add(button, BorderLayout.SOUTH);", "    }", "  }", "}"};
        String[] source2 = new String[]{"public class Test extends JPanel {", "  public Test() {", "    setLayout(new FlowLayout(FlowLayout.CENTER, 5, 5));", "    {", "      final JButton button = new JButton('New button');", "      add(button);", "    }", "  }", "}"};
        this.check_setLayout(source, "java.awt.FlowLayout", source2, 10, 10);
    }

    @Test
    public void test_setLayout2() throws Exception {
        String[] source = new String[]{"public class Test extends JFrame {", "  public Test() {", "    {", "      final JButton button = new JButton('New button');", "      getContentPane().add(button, BorderLayout.SOUTH);", "    }", "  }", "}"};
        String[] source2 = new String[]{"public class Test extends JFrame {", "  public Test() {", "    getContentPane().setLayout(new FlowLayout(FlowLayout.CENTER, 5, 5));", "    {", "      final JButton button = new JButton('New button');", "      getContentPane().add(button);", "    }", "  }", "}"};
        this.check_setLayout(source, "java.awt.FlowLayout", source2, 10, 50);
    }

    @Test
    public void test_CREATE_onEmpty() throws Exception {
        ContainerInfo panel = this.openContainer("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        this.loadCreationTool("javax.swing.JButton");
        this.canvas.moveTo((Object)panel, 10, 10);
        this.canvas.click();
        this.assertEditor("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton('New button');", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_beforeExisting() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton('Button');", "      add(button);", "    }", "  }", "}");
        this.loadCreationTool("javax.swing.JButton");
        this.canvas.moveTo((Object)panel, 10, 10);
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton('New button');", "      add(button);", "    }", "    {", "      JButton button = new JButton('Button');", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_afterExisting() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton('Button');", "      add(button);", "    }", "  }", "}");
        this.loadCreationTool("javax.swing.JButton");
        this.canvas.moveTo((Object)panel, -10, 10);
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton('Button');", "      add(button);", "    }", "    {", "      JButton button = new JButton('New button');", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_hasExposed() throws Exception {
        FlowLayoutGefTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  protected final JButton m_button;", "  public MyPanel() {", "    {", "      m_button = new JButton('Button');", "      add(m_button);", "    }", "  }", "}"));
        FlowLayoutGefTest.waitForAutoBuild();
        ContainerInfo panel = this.openContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        this.loadCreationTool("javax.swing.JButton");
        this.canvas.moveTo((Object)panel, 10, 10);
        this.canvas.click();
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    {", "      JButton button = new JButton('New button');", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_RTL_onEmpty() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);", "  }", "}");
        this.loadCreationTool("javax.swing.JButton");
        this.canvas.moveTo((Object)panel, 10, 10);
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);", "    {", "      JButton button = new JButton('New button');", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_RTL_last() throws Exception {
        this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);", "    {", "      JButton existing = new JButton('Button');", "      add(existing);", "    }", "  }", "}");
        ComponentInfo existing = (ComponentInfo)FlowLayoutGefTest.getJavaInfoByName("existing");
        this.loadCreationTool("javax.swing.JButton");
        this.canvas.target(existing).outX(-5).inY(5).move();
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);", "    {", "      JButton existing = new JButton('Button');", "      add(existing);", "    }", "    {", "      JButton button = new JButton('New button');", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_RTL_beforeExisting() throws Exception {
        this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);", "    {", "      JButton existing = new JButton('Button');", "      add(existing);", "    }", "  }", "}");
        ComponentInfo existing = (ComponentInfo)FlowLayoutGefTest.getJavaInfoByName("existing");
        this.loadCreationTool("javax.swing.JButton");
        this.canvas.target(existing).in(-5, 5).move();
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);", "    {", "      JButton button = new JButton('New button');", "      add(button);", "    }", "    {", "      JButton existing = new JButton('Button');", "      add(existing);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_RTL_betweenExisting() throws Exception {
        this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);", "    {", "      JButton buttonA = new JButton('ButtonA');", "      add(buttonA);", "    }", "    {", "      JButton buttonB = new JButton('ButtonB');", "      add(buttonB);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)FlowLayoutGefTest.getJavaInfoByName("buttonA");
        this.loadCreationTool("javax.swing.JButton");
        this.canvas.target(button).outX(-5).inY(5).move();
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);", "    {", "      JButton buttonA = new JButton('ButtonA');", "      add(buttonA);", "    }", "    {", "      JButton button = new JButton('New button');", "      add(button);", "    }", "    {", "      JButton buttonB = new JButton('ButtonB');", "      add(buttonB);", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_twoComponents() throws Exception {
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    {", "      JButton buttonA = new JButton('Button A');", "      add(buttonA);", "    }", "    {", "      JButton buttonB = new JButton('Button B');", "      add(buttonB);", "    }", "  }", "}"};
        this.openContainer(lines);
        ComponentInfo buttonA = (ComponentInfo)FlowLayoutGefTest.getJavaInfoByName("buttonA");
        ComponentInfo buttonB = (ComponentInfo)FlowLayoutGefTest.getJavaInfoByName("buttonB");
        this.canvas.select(buttonA, buttonB);
        FlowLayoutGefTest.assertEquals((long)2L, (long)this.m_viewerCanvas.getSelectedEditParts().size());
        this.canvas.beginDrag(buttonB, 10, 5);
        this.canvas.dragTo((Object)buttonA, -10, 0);
        this.canvas.endDrag();
        this.assertEditor(lines);
    }

    @Test
    public void test_MOVE_localVariable() throws Exception {
        String[] source = new String[]{"public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton('Button 1');", "      add(button);", "    }", "    {", "      JButton button = new JButton('Button 2');", "      add(button);", "    }", "  }", "}"};
        String[] source2 = new String[]{"public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton('Button 2');", "      add(button);", "    }", "    {", "      JButton button = new JButton('Button 1');", "      add(button);", "    }", "  }", "}"};
        this.check_MOVE(source, source2);
    }

    @Test
    public void test_MOVE_lazy() throws Exception {
        String[] source = new String[]{"public class Test extends JPanel {", "  private JButton button_1;", "  private JButton button_2;", "  public Test() {", "    add(getButton_1());", "    add(getButton_2());", "  }", "  private JButton getButton_1() {", "    if (button_1 == null) {", "      button_1 = new JButton('Button 1');", "    }", "    return button_1;", "  }", "  private JButton getButton_2() {", "    if (button_2 == null) {", "      button_2 = new JButton('button 2');", "    }", "    return button_2;", "  }", "}"};
        String[] source2 = new String[]{"public class Test extends JPanel {", "  private JButton button_1;", "  private JButton button_2;", "  public Test() {", "    add(getButton_2());", "    add(getButton_1());", "  }", "  private JButton getButton_1() {", "    if (button_1 == null) {", "      button_1 = new JButton('Button 1');", "    }", "    return button_1;", "  }", "  private JButton getButton_2() {", "    if (button_2 == null) {", "      button_2 = new JButton('button 2');", "    }", "    return button_2;", "  }", "}"};
        this.check_MOVE(source, source2);
    }

    private void check_MOVE(String[] source, String[] source2) throws Exception {
        ContainerInfo panel = this.openContainer(source);
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        this.canvas.beginDrag(button_2);
        this.canvas.dragTo((Object)button_2, -10, 0);
        this.canvas.endDrag();
        this.canvas.assertNoFeedbackFigures();
        this.assertEditor(source);
        this.canvas.beginDrag(button_1);
        this.canvas.dragTo((Object)button_2, 10, 0);
        this.canvas.endDrag();
        this.canvas.assertNoFeedbackFigures();
        this.assertEditor(source);
        this.canvas.beginDrag(button_2);
        this.canvas.dragTo((Object)button_1, 10, 0);
        this.canvas.endDrag();
        this.canvas.assertNoFeedbackFigures();
        this.assertEditor(source2);
    }

    @Test
    public void test_ADD() throws Exception {
        this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JButton button = new JButton('Button');", "      add(button, BorderLayout.NORTH);", "    }", "    {", "      JPanel panel = new JPanel();", "      panel.setBackground(Color.PINK);", "      panel.setPreferredSize(new Dimension(0, 150));", "      add(panel, BorderLayout.SOUTH);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)FlowLayoutGefTest.getJavaInfoByName("button");
        ComponentInfo inner = (ComponentInfo)FlowLayoutGefTest.getJavaInfoByName("panel");
        this.canvas.beginDrag(button);
        this.canvas.dragTo((Object)inner, 10, 10);
        this.canvas.endDrag();
        this.canvas.assertFeedbackFigures(0);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JPanel panel = new JPanel();", "      panel.setBackground(Color.PINK);", "      panel.setPreferredSize(new Dimension(0, 150));", "      add(panel, BorderLayout.SOUTH);", "      {", "        JButton button = new JButton('Button');", "        panel.add(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_ADD_twoComponents() throws Exception {
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JButton buttonA = new JButton('ButtonA');", "      add(buttonA, BorderLayout.NORTH);", "    }", "    {", "      JButton buttonB = new JButton('ButtonB');", "      add(buttonB, BorderLayout.SOUTH);", "    }", "    {", "      JPanel panel = new JPanel();", "      panel.setBackground(Color.PINK);", "      panel.setPreferredSize(new Dimension(0, 150));", "      add(panel, BorderLayout.CENTER);", "    }", "  }", "}"};
        this.openContainer(lines);
        ComponentInfo buttonA = (ComponentInfo)FlowLayoutGefTest.getJavaInfoByName("buttonA");
        ComponentInfo buttonB = (ComponentInfo)FlowLayoutGefTest.getJavaInfoByName("buttonB");
        ComponentInfo inner = (ComponentInfo)FlowLayoutGefTest.getJavaInfoByName("panel");
        this.canvas.select(buttonA, buttonB);
        FlowLayoutGefTest.assertEquals((long)2L, (long)this.m_viewerCanvas.getSelectedEditParts().size());
        this.canvas.beginDrag(buttonB, 10, 5);
        this.canvas.dragTo((Object)inner, 10, 10);
        this.canvas.endDrag();
        this.canvas.assertFeedbackFigures(0);
        this.assertEditor(lines);
    }
}

