/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.property;

import org.eclipse.wb.internal.core.model.clipboard.IClipboardSourceProvider;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.core.model.parser.AbstractJavaInfoTest;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class BorderPropertyEditorTest
extends SwingModelTest {
    @Test
    public void test_getText_defaultBorder() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        Property borderProperty = panel.getPropertyByTitle("border");
        BorderPropertyEditorTest.assertEquals(null, (Object)BorderPropertyEditorTest.getPropertyText(borderProperty));
    }

    @Test
    public void test_getText_noBorder() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setBorder(null);", "  }", "}");
        panel.refresh();
        Property borderProperty = panel.getPropertyByTitle("border");
        BorderPropertyEditorTest.assertEquals((Object)"(no border)", (Object)BorderPropertyEditorTest.getPropertyText(borderProperty));
    }

    @Test
    public void test_getText_EmptyBorder() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setBorder(new EmptyBorder(0, 0, 0, 0));", "  }", "}");
        panel.refresh();
        Property borderProperty = panel.getPropertyByTitle("border");
        BorderPropertyEditorTest.assertEquals((Object)"EmptyBorder", (Object)BorderPropertyEditorTest.getPropertyText(borderProperty));
    }

    @Test
    public void test_getClipboardSource_EmptyBorder() throws Exception {
        final ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      button.setBorder(new EmptyBorder(1, 2, 3, 4));", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)BorderPropertyEditorTest.getJavaInfoByName("button");
        GenericProperty borderProperty = (GenericProperty)button.getPropertyByTitle("border");
        PropertyEditor propertyEditor = borderProperty.getEditor();
        BorderPropertyEditorTest.assertEquals((Object)"new javax.swing.border.EmptyBorder(1, 2, 3, 4)", (Object)((IClipboardSourceProvider)propertyEditor).getClipboardSource(borderProperty));
        BorderPropertyEditorTest.doCopyPaste(button, new AbstractJavaInfoTest.PasteProcedure<ComponentInfo>(){

            @Override
            public void run(ComponentInfo copy) throws Exception {
                ((FlowLayoutInfo)panel.getLayout()).add(copy, null);
            }
        });
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      button.setBorder(new EmptyBorder(1, 2, 3, 4));", "      add(button);", "    }", "    {", "      JButton button = new JButton();", "      button.setBorder(new EmptyBorder(1, 2, 3, 4));", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_getClipboardSource_hasNotConstants() throws Exception {
        final ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      int notConst = 4;", "      button.setBorder(new EmptyBorder(1, 2, 3, notConst));", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)BorderPropertyEditorTest.getJavaInfoByName("button");
        GenericProperty borderProperty = (GenericProperty)button.getPropertyByTitle("border");
        PropertyEditor propertyEditor = borderProperty.getEditor();
        IClipboardSourceProvider pe = (IClipboardSourceProvider)propertyEditor;
        String cs = pe.getClipboardSource(borderProperty);
        BorderPropertyEditorTest.assertEquals(null, (Object)cs);
        BorderPropertyEditorTest.doCopyPaste(button, new AbstractJavaInfoTest.PasteProcedure<ComponentInfo>(){

            @Override
            public void run(ComponentInfo copy) throws Exception {
                ((FlowLayoutInfo)panel.getLayout()).add(copy, null);
            }
        });
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      int notConst = 4;", "      button.setBorder(new EmptyBorder(1, 2, 3, notConst));", "      add(button);", "    }", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
    }
}

