/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.top;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.Expectations;
import org.eclipse.wb.tests.designer.TestUtils;
import org.eclipse.wb.tests.designer.swing.SwingGefTest;
import org.junit.Ignore;
import org.junit.Test;

public class JFrameTopBoundsTest
extends SwingGefTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_defaultSize() throws Exception {
        Dimension oldSize = new Dimension(450, 300);
        Dimension resizeSize = new Dimension(350, 200);
        ICompilationUnit unit = this.check_resize("// no size", "// none", oldSize, resizeSize, resizeSize, "// no size");
        this.assert_sameSizeAfterReparse(unit, resizeSize);
    }

    @Test
    public void test_JFrame_bigSize_setInSuperclass() throws Exception {
        JFrameTopBoundsTest.setFileContentSrc("test/MyBigFrame.java", this.getTestSource("public class MyBigFrame extends JFrame {", "  public MyBigFrame() {", "    setSize(500, 400);", "  }", "}"));
        JFrameTopBoundsTest.waitForAutoBuild();
        Dimension oldSize = new Dimension(500, 400);
        Dimension resizeSize = new Dimension(350, 200);
        ICompilationUnit unit = this.check_resize("MyBigFrame", "// no size", "// none", oldSize, resizeSize, resizeSize, "// no size");
        this.assert_sameSizeAfterReparse(unit, resizeSize);
    }

    @Test
    public void test_JFrame_veryBig() throws Exception {
        JFrameTopBoundsTest.setFileContentSrc("test/MyVeryBigFrame.java", this.getTestSource("public class MyVeryBigFrame extends JFrame {", "  public MyVeryBigFrame() {", "    setSize(500, 400);", "  }", "}"));
        JFrameTopBoundsTest.waitForAutoBuild();
        Dimension oldSize = new Dimension(500, 400);
        Dimension resizeSize = new Dimension(5000, 400);
        ICompilationUnit unit = this.check_resize("MyVeryBigFrame", "// no size", "// none", oldSize, resizeSize, resizeSize, "// no size");
        this.assert_sameSizeAfterReparse(unit, resizeSize);
        oldSize = new Dimension(5000, 400);
        resizeSize = new Dimension(500, 4000);
        unit = this.check_resize("MyVeryBigFrame", "// no size", "// none", oldSize, resizeSize, resizeSize, "// no size");
        this.assert_sameSizeAfterReparse(unit, resizeSize);
    }

    @Test
    public void test_JInternalFrame_bigSize_setInSuperclass() throws Exception {
        JFrameTopBoundsTest.setFileContentSrc("test/MyBigFrame.java", this.getTestSource("public class MyBigFrame extends JInternalFrame {", "  public MyBigFrame() {", "    setSize(500, 400);", "  }", "}"));
        JFrameTopBoundsTest.waitForAutoBuild();
        Dimension oldSize = new Dimension(500, 400);
        Dimension resizeSize = new Dimension(350, 200);
        ICompilationUnit unit = this.check_resize("MyBigFrame", "// no size", "// none", oldSize, resizeSize, resizeSize, "// no size");
        this.assert_sameSizeAfterReparse(unit, resizeSize);
    }

    @Ignore
    @Test
    public void test_resize_pack() throws Exception {
        Dimension packSize = Expectations.get(new Dimension(132, 89), new Expectations.DimValue("flanker-windows", new Dimension(132, 83)), new Expectations.DimValue("scheglov-win", new Dimension(132, 83)));
        Dimension resizeSize = new Dimension(450, 300);
        ICompilationUnit unit = this.check_resize("// no size", "pack();", packSize, resizeSize, packSize, "// no size");
        this.assert_sameSizeAfterReparse(unit, packSize);
    }

    @Test
    public void test_packAlways() throws Exception {
        JFrameTopBoundsTest.setFileContentSrc("test/MyFrame.java", this.getTestSource("public class MyFrame extends JFrame {", "  protected void finishInit() {", "    pack();", "  }", "}"));
        JFrameTopBoundsTest.setFileContentSrc("test/MyFrame.wbp-component.xml", JFrameTopBoundsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='finishInit'/>", "  </methods>", "  <parameters>", "    <parameter name='topBounds.pack'>true</parameter>", "  </parameters>", "</component>"));
        JFrameTopBoundsTest.waitForAutoBuild();
        ContainerInfo frame = this.openContainer("// filler filler filler filler filler", "public class Test extends MyFrame {", "  public Test() {", "    finishInit();", "  }", "}");
        Dimension size = frame.getBounds().getSize();
        JFrameTopBoundsTest.assertNotEquals((long)size.width, (long)450L);
        JFrameTopBoundsTest.assertNotEquals((long)size.height, (long)300L);
    }

    @Test
    public void test_resize_setSize_ints() throws Exception {
        Dimension oldSize = new Dimension(300, 200);
        Dimension newSize = new Dimension(400, 300);
        this.check_resize("setSize(300, 200);", "", oldSize, newSize, newSize, "setSize(400, 300);");
    }

    @Test
    public void test_resize_setBounds_ints() throws Exception {
        Dimension oldSize = new Dimension(300, 200);
        Dimension newSize = new Dimension(400, 300);
        this.check_resize("setBounds(0, 0, 300, 200);", "", oldSize, newSize, newSize, "setBounds(0, 0, 400, 300);");
    }

    private ICompilationUnit check_resize(String oldSizeLine, String addSizeString, Dimension oldSize, Dimension resizeSize, Dimension newSize, String newSizeLine) throws Exception {
        return this.check_resize("JFrame", oldSizeLine, addSizeString, oldSize, resizeSize, newSize, newSizeLine);
    }

    private ICompilationUnit check_resize(String superClassName, String oldSizeLine, String addSizeString, Dimension oldSize, Dimension resizeSize, Dimension newSize, String newSizeLine) throws Exception {
        ContainerInfo frame = this.openContainer("public class Test extends " + superClassName + " {", "  public Test() {", "    " + oldSizeLine, "    getContentPane().add(new JButton('Swing JButton'), BorderLayout.NORTH);", "    getContentPane().add(new Button('AWT Button'), BorderLayout.WEST);", "    " + addSizeString, "  }", "}");
        JFrameTopBoundsTest.assertEquals(oldSize, this.canvas.getSize(frame));
        JFrameTopBoundsTest.waitEventLoop(50);
        this.canvas.beginResize(frame, 16);
        this.canvas.dragTo((Object)frame, resizeSize.width, 0).endDrag();
        this.canvas.beginResize(frame, 4);
        this.canvas.dragTo((Object)frame, 0, resizeSize.height).endDrag();
        JFrameTopBoundsTest.assertEquals(newSize, this.canvas.getSize(frame));
        this.assertEditor("public class Test extends " + superClassName + " {", "  public Test() {", "    " + newSizeLine, "    getContentPane().add(new JButton('Swing JButton'), BorderLayout.NORTH);", "    getContentPane().add(new Button('AWT Button'), BorderLayout.WEST);", "    " + addSizeString, "  }", "}");
        return this.m_lastEditor.getModelUnit();
    }

    private void assert_sameSizeAfterReparse(ICompilationUnit unit, Dimension resizeSize) throws Exception {
        TestUtils.closeAllEditors();
        this.openDesign(unit);
        JFrameTopBoundsTest.assertEquals(resizeSize, this.canvas.getSize(this.m_contentEditPart));
    }
}

