/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.top;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.TestUtils;
import org.eclipse.wb.tests.designer.swing.SwingGefTest;
import org.junit.Test;

public class JPanelTopBoundsTest
extends SwingGefTest {
    @Test
    public void test_resize_properties() throws Exception {
        Dimension oldSize = new Dimension(450, 300);
        Dimension newSize = new Dimension(400, 350);
        ICompilationUnit unit = this.check_resize_JPanel("// no size", oldSize, newSize, "// no size");
        TestUtils.closeAllEditors();
        this.openDesign(unit);
        JPanelTopBoundsTest.assertEquals(newSize, this.canvas.getSize(this.m_contentEditPart));
    }

    @Test
    public void test_resize_setPreferredSize() throws Exception {
        Dimension oldSize = new Dimension(300, 200);
        Dimension newSize = new Dimension(400, 300);
        this.check_resize_JPanel("setPreferredSize(new Dimension(300, 200));", oldSize, newSize, "setPreferredSize(new Dimension(400, 300));");
    }

    @Test
    public void test_resize_setSize_Dimension() throws Exception {
        Dimension oldSize = new Dimension(300, 200);
        Dimension newSize = new Dimension(400, 300);
        this.check_resize_JPanel("setSize(new Dimension(300, 200));", oldSize, newSize, "setSize(new Dimension(400, 300));");
    }

    @Test
    public void test_resize_setSize_ints() throws Exception {
        Dimension oldSize = new Dimension(300, 200);
        Dimension newSize = new Dimension(400, 300);
        this.check_resize_JPanel("setSize(300, 200);", oldSize, newSize, "setSize(400, 300);");
    }

    @Test
    public void test_resize_veryBig() throws Exception {
        Dimension oldSize = new Dimension(500, 400);
        Dimension newSize = new Dimension(5000, 400);
        this.check_resize_JPanel("setSize(new Dimension(500, 400));", oldSize, newSize, "setSize(new Dimension(5000, 400));");
        oldSize = new Dimension(5000, 400);
        newSize = new Dimension(500, 4000);
        this.check_resize_JPanel("setSize(new Dimension(5000, 400));", oldSize, newSize, "setSize(new Dimension(500, 4000));");
    }

    private ICompilationUnit check_resize_JPanel(String oldSizeLine, Dimension oldSize, Dimension newSize, String newSizeLine) throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    " + oldSizeLine, "    add(new JButton('Swing JButton'));", "    add(new Button('AWT Button'));", "  }", "}");
        JPanelTopBoundsTest.assertEquals(oldSize, this.canvas.getSize(panel));
        JPanelTopBoundsTest.waitEventLoop(50);
        this.canvas.beginResize(panel, 16);
        this.canvas.dragTo((Object)panel, newSize.width, 0).endDrag();
        this.canvas.beginResize(panel, 4);
        this.canvas.dragTo((Object)panel, 0, newSize.height).endDrag();
        JPanelTopBoundsTest.assertEquals(newSize, this.canvas.getSize(panel));
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    " + newSizeLine, "    add(new JButton('Swing JButton'));", "    add(new Button('AWT Button'));", "  }", "}");
        return this.m_lastEditor.getModelUnit();
    }
}

