/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.layouts;

import org.eclipse.wb.core.model.association.ImplicitObjectAssociation;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.variable.EmptyVariableSupport;
import org.eclipse.wb.internal.core.model.variable.LocalUniqueVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.swt.model.layout.FillLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.ImplicitLayoutDataCreationSupport;
import org.eclipse.wb.internal.swt.model.layout.ImplicitLayoutDataVariableSupport;
import org.eclipse.wb.internal.swt.model.layout.LayoutDataInfo;
import org.eclipse.wb.internal.swt.model.layout.LayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.GridDataInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Test;

public class ImplicitLayoutDataTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_implicitData() throws Exception {
        this.prepareGridComposite_forImplicit();
        CompositeInfo composite = this.parseComposite("public class Test extends GridComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
        composite.refresh();
        ControlInfo button = (ControlInfo)composite.getChildrenControls().get(0);
        GridDataInfo gridData = (GridDataInfo)button.getChildrenJava().get(0);
        CreationSupport creationSupport = gridData.getCreationSupport();
        ImplicitLayoutDataTest.assertInstanceOf(ImplicitLayoutDataCreationSupport.class, (Object)creationSupport);
        ImplicitLayoutDataTest.assertEquals((Object)"implicit-layout-data: org.eclipse.swt.layout.GridData", (Object)creationSupport.toString());
        ImplicitLayoutDataTest.assertTrue((boolean)creationSupport.canDelete());
        ImplicitLayoutDataTest.assertEquals((Object)button.getCreationSupport().getNode(), (Object)creationSupport.getNode());
        VariableSupport variableSupport = gridData.getVariableSupport();
        ImplicitLayoutDataTest.assertInstanceOf(ImplicitLayoutDataVariableSupport.class, (Object)variableSupport);
        ImplicitLayoutDataTest.assertEquals((Object)"implicit-layout-data", (Object)variableSupport.toString());
        ImplicitLayoutDataTest.assertEquals((Object)"(implicit layout data)", (Object)variableSupport.getTitle());
        ImplicitLayoutDataTest.assertTrue((boolean)variableSupport.isDefault());
        ImplicitLayoutDataTest.assertInstanceOf(ImplicitObjectAssociation.class, (Object)gridData.getAssociation());
        Property property = gridData.getPropertyByTitle("widthHint");
        ImplicitLayoutDataTest.assertNotNull((Object)property);
        ImplicitLayoutDataTest.assertEquals((Object)100, (Object)property.getValue());
        property.setValue((Object)110);
        ImplicitLayoutDataTest.assertEquals((Object)110, (Object)property.getValue());
        this.assertEditor("public class Test extends GridComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    ((GridData) getButton().getLayoutData()).widthHint = 110;", "  }", "}");
        ImplicitLayoutDataTest.assertSame((Object)creationSupport, (Object)gridData.getCreationSupport());
        ImplicitLayoutDataTest.assertNotSame((Object)variableSupport, (Object)gridData.getVariableSupport());
        ImplicitLayoutDataTest.assertNotInstanceOf(ImplicitLayoutDataVariableSupport.class, gridData.getVariableSupport());
        ImplicitLayoutDataTest.assertInstanceOf(ImplicitObjectAssociation.class, (Object)gridData.getAssociation());
        gridData.delete();
        this.assertEditor("public class Test extends GridComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
        ImplicitLayoutDataTest.assertSame((Object)creationSupport, (Object)gridData.getCreationSupport());
        ImplicitLayoutDataTest.assertInstanceOf(ImplicitLayoutDataVariableSupport.class, (Object)gridData.getVariableSupport());
        ImplicitLayoutDataTest.assertInstanceOf(ImplicitObjectAssociation.class, (Object)gridData.getAssociation());
        ImplicitLayoutDataTest.assertEquals((Object)100, (Object)gridData.getPropertyByTitle("widthHint").getValue());
    }

    @Test
    public void test_implicitData_advanced() throws Exception {
        this.prepareGridComposite_forImplicit();
        CompositeInfo composite = this.parseComposite("public class Test extends GridComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
        composite.refresh();
        ControlInfo button = (ControlInfo)composite.getChildrenControls().get(0);
        GridDataInfo gridData = (GridDataInfo)button.getChildrenJava().get(0);
        CreationSupport creationSupport = gridData.getCreationSupport();
        ImplicitLayoutDataTest.assertInstanceOf(ImplicitLayoutDataCreationSupport.class, (Object)creationSupport);
        ImplicitLayoutDataTest.assertEquals((Object)"implicit-layout-data: org.eclipse.swt.layout.GridData", (Object)creationSupport.toString());
        ImplicitLayoutDataTest.assertTrue((boolean)creationSupport.canDelete());
        ImplicitLayoutDataTest.assertEquals((Object)button.getCreationSupport().getNode(), (Object)creationSupport.getNode());
        VariableSupport variableSupport = gridData.getVariableSupport();
        ImplicitLayoutDataTest.assertInstanceOf(ImplicitLayoutDataVariableSupport.class, (Object)variableSupport);
        ImplicitLayoutDataTest.assertEquals((Object)"implicit-layout-data", (Object)variableSupport.toString());
        ImplicitLayoutDataTest.assertEquals((Object)"(implicit layout data)", (Object)variableSupport.getTitle());
        ImplicitLayoutDataTest.assertTrue((boolean)variableSupport.isDefault());
        ImplicitLayoutDataTest.assertInstanceOf(ImplicitObjectAssociation.class, (Object)gridData.getAssociation());
        Property property = gridData.getPropertyByTitle("widthHint");
        ImplicitLayoutDataTest.assertNotNull((Object)property);
        ImplicitLayoutDataTest.assertEquals((Object)100, (Object)property.getValue());
        property.setValue((Object)110);
        ImplicitLayoutDataTest.assertEquals((Object)110, (Object)property.getValue());
        this.assertEditor("public class Test extends GridComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    ((GridData) getButton().getLayoutData()).widthHint = 110;", "  }", "}");
        ImplicitLayoutDataTest.assertSame((Object)creationSupport, (Object)gridData.getCreationSupport());
        ImplicitLayoutDataTest.assertNotSame((Object)variableSupport, (Object)gridData.getVariableSupport());
        ImplicitLayoutDataTest.assertNotInstanceOf(ImplicitLayoutDataVariableSupport.class, gridData.getVariableSupport());
        ImplicitLayoutDataTest.assertInstanceOf(ImplicitObjectAssociation.class, (Object)gridData.getAssociation());
        property = gridData.getPropertyByTitle("heightHint");
        ImplicitLayoutDataTest.assertEquals((Object)50, (Object)property.getValue());
        property.setValue((Object)60);
        ImplicitLayoutDataTest.assertEquals((Object)60, (Object)property.getValue());
        this.assertEditor("public class Test extends GridComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      GridData gridData = (GridData) getButton().getLayoutData();", "      gridData.heightHint = 60;", "      gridData.widthHint = 110;", "    }", "  }", "}");
        property.setValue(Property.UNKNOWN_VALUE);
        ImplicitLayoutDataTest.assertEquals((Object)50, (Object)property.getValue());
        this.assertEditor("public class Test extends GridComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    ((GridData) getButton().getLayoutData()).widthHint = 110;", "  }", "}");
    }

    private void prepareGridComposite_forImplicit() throws Exception {
        ImplicitLayoutDataTest.setFileContentSrc("test/GridComposite.java", this.getTestSource("public class GridComposite extends Composite {", "  private Button m_button;", "  public GridComposite(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout());", "    {", "      m_button = new Button(this, SWT.NONE);", "      GridData data = new GridData();", "      data.widthHint = 100;", "      data.heightHint = 50;", "      m_button.setLayoutData(data);", "    }", "  }", "  public Button getButton() {", "    return m_button;", "  }", "}"));
        ImplicitLayoutDataTest.waitForAutoBuild();
    }

    @Test
    public void test_implicitReplace_withExplicitData() throws Exception {
        this.createASTCompilationUnit("test", "MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  private Button m_button;", "  public MyComposite(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(1, false));", "    m_button = new Button(this, SWT.NONE);", "    m_button.setLayoutData(new GridData(GridData.FILL, GridData.CENTER, true, false));", "  }", "  public Button getButton() {", "    return m_button;", "  }", "}"));
        ImplicitLayoutDataTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    MyComposite myComposite = new MyComposite(this, SWT.NONE);", "    myComposite.getButton().setLayoutData(new GridData());", "  }", "}");
        shell.refresh();
        CompositeInfo myComposite = (CompositeInfo)shell.getChildrenControls().get(0);
        ControlInfo button = (ControlInfo)myComposite.getChildrenControls().get(0);
        LayoutDataInfo gridData = LayoutInfo.getLayoutData((ControlInfo)button);
        ImplicitLayoutDataTest.assertInstanceOf(ConstructorCreationSupport.class, (Object)gridData.getCreationSupport());
        ImplicitLayoutDataTest.assertInstanceOf(EmptyVariableSupport.class, (Object)gridData.getVariableSupport());
    }

    @Test
    public void test_delete_shouldKeepSameInstance() throws Exception {
        this.createASTCompilationUnit("test", "MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  private Button m_button;", "  public MyComposite(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(1, false));", "    m_button = new Button(this, SWT.NONE);", "    m_button.setLayoutData(new GridData(GridData.FILL, GridData.CENTER, true, false));", "  }", "  public Button getButton() {", "    return m_button;", "  }", "}"));
        ImplicitLayoutDataTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    MyComposite myComposite = new MyComposite(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        CompositeInfo myComposite = (CompositeInfo)shell.getChildrenControls().get(0);
        ControlInfo button = (ControlInfo)myComposite.getChildrenControls().get(0);
        LayoutDataInfo initialData = LayoutInfo.getLayoutData((ControlInfo)button);
        ImplicitLayoutDataTest.assertInstanceOf(ImplicitLayoutDataCreationSupport.class, (Object)initialData.getCreationSupport());
        ImplicitLayoutDataTest.assertInstanceOf(ImplicitLayoutDataVariableSupport.class, (Object)initialData.getVariableSupport());
        ImplicitLayoutDataTest.assertEquals((Object)Boolean.TRUE, (Object)initialData.getPropertyByTitle("grabExcessHorizontalSpace").getValue());
        ImplicitLayoutDataTest.assertEquals((Object)Boolean.FALSE, (Object)initialData.getPropertyByTitle("grabExcessVerticalSpace").getValue());
        ImplicitLayoutDataTest.assertTrue((boolean)button.canDelete());
        button.delete();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    MyComposite myComposite = new MyComposite(this, SWT.NONE);", "  }", "}");
        LayoutDataInfo newData = LayoutInfo.getLayoutData((ControlInfo)button);
        ImplicitLayoutDataTest.assertSame((Object)initialData, (Object)newData);
        ImplicitLayoutDataTest.assertInstanceOf(ImplicitLayoutDataCreationSupport.class, (Object)newData.getCreationSupport());
        ImplicitLayoutDataTest.assertInstanceOf(ImplicitLayoutDataVariableSupport.class, (Object)newData.getVariableSupport());
    }

    @Test
    public void test_delete_removeMaterialized() throws Exception {
        this.createASTCompilationUnit("test", "MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  private Button m_button;", "  public MyComposite(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(1, false));", "    m_button = new Button(this, SWT.NONE);", "    m_button.setLayoutData(new GridData(GridData.FILL, GridData.CENTER, true, false));", "  }", "  public Button getButton() {", "    return m_button;", "  }", "}"));
        ImplicitLayoutDataTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    MyComposite myComposite = new MyComposite(this, SWT.NONE);", "    GridData gridData = (GridData) myComposite.getButton().getLayoutData();", "    gridData.grabExcessVerticalSpace = true;", "  }", "}");
        shell.refresh();
        CompositeInfo myComposite = (CompositeInfo)shell.getChildrenControls().get(0);
        ControlInfo button = (ControlInfo)myComposite.getChildrenControls().get(0);
        LayoutDataInfo initialData = LayoutInfo.getLayoutData((ControlInfo)button);
        ImplicitLayoutDataTest.assertInstanceOf(ImplicitLayoutDataCreationSupport.class, (Object)initialData.getCreationSupport());
        ImplicitLayoutDataTest.assertInstanceOf(LocalUniqueVariableSupport.class, (Object)initialData.getVariableSupport());
        ImplicitLayoutDataTest.assertEquals((Object)Boolean.TRUE, (Object)initialData.getPropertyByTitle("grabExcessHorizontalSpace").getValue());
        ImplicitLayoutDataTest.assertEquals((Object)Boolean.TRUE, (Object)initialData.getPropertyByTitle("grabExcessVerticalSpace").getValue());
        ImplicitLayoutDataTest.assertTrue((boolean)button.canDelete());
        button.delete();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    MyComposite myComposite = new MyComposite(this, SWT.NONE);", "  }", "}");
        LayoutDataInfo newData = LayoutInfo.getLayoutData((ControlInfo)button);
        ImplicitLayoutDataTest.assertSame((Object)initialData, (Object)newData);
        ImplicitLayoutDataTest.assertInstanceOf(ImplicitLayoutDataCreationSupport.class, (Object)newData.getCreationSupport());
        ImplicitLayoutDataTest.assertInstanceOf(ImplicitLayoutDataVariableSupport.class, (Object)newData.getVariableSupport());
        ImplicitLayoutDataTest.assertEquals((Object)Boolean.TRUE, (Object)initialData.getPropertyByTitle("grabExcessHorizontalSpace").getValue());
        ImplicitLayoutDataTest.assertEquals((Object)Boolean.FALSE, (Object)initialData.getPropertyByTitle("grabExcessVerticalSpace").getValue());
    }

    @Test
    public void test_addNewComposite_withExposedControl_andImplicitLayoutData() throws Exception {
        ImplicitLayoutDataTest.setFileContentSrc("test/MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  private Button m_button;", "  public MyComposite(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout());", "    {", "      m_button = new Button(this, SWT.NONE);", "      m_button.setLayoutData(new GridData());", "    }", "  }", "  public Button getButton() {", "    return m_button;", "  }", "}"));
        ImplicitLayoutDataTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new FillLayout());", "  }", "}");
        FillLayoutInfo layout = (FillLayoutInfo)shell.getLayout();
        CompositeInfo myComposite = (CompositeInfo)ImplicitLayoutDataTest.createJavaInfo("test.MyComposite");
        layout.command_CREATE((ControlInfo)myComposite, null);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new FillLayout());", "    {", "      MyComposite myComposite = new MyComposite(this, SWT.NONE);", "    }", "  }", "}");
        ImplicitLayoutDataTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/setLayout(new FillLayout())/ /new MyComposite(this, SWT.NONE)/}", "  {new: org.eclipse.swt.layout.FillLayout} {empty} {/setLayout(new FillLayout())/}", "  {new: test.MyComposite} {local-unique: myComposite} {/new MyComposite(this, SWT.NONE)/}", "    {implicit-layout: org.eclipse.swt.layout.GridLayout} {implicit-layout} {}", "    {method: public org.eclipse.swt.widgets.Button test.MyComposite.getButton()} {property} {}", "      {implicit-layout-data: org.eclipse.swt.layout.GridData} {implicit-layout-data} {}");
    }
}

