/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.menu;

import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.internal.swt.model.widgets.menu.MenuInfo;
import org.eclipse.wb.tests.designer.rcp.RcpGefTest;
import org.junit.Test;

public class MenuProblemsTest
extends RcpGefTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_AsyncMessagesSupport_andMenuGEF() throws Exception {
        MenuProblemsTest.setFileContentSrc("test/MyButton.java", this.getTestSource2("public class MyButton extends Button {", "  public MyButton(Composite parent, int style) {", "    super(parent, style);", "  }", "  protected void checkSubclass() {", "  }", "}"));
        MenuProblemsTest.setFileContentSrc("test/MyButton.wbp-component.xml", MenuProblemsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='SWT.runAsyncMessages'>true</parameter>", "  </parameters>", "</component>"));
        MenuProblemsTest.waitForAutoBuild();
        CompositeInfo shellInfo = this.openComposite("public class Test extends Shell {", "  public Test() {", "    new MyButton(this, SWT.NONE);", "  }", "}");
        GraphicalEditPart shellPart = this.canvas.getEditPart(shellInfo);
        MenuInfo barInfo = (MenuInfo)this.loadCreationTool("org.eclipse.swt.widgets.Menu", "bar");
        this.canvas.moveTo(shellPart);
        this.canvas.click();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    new MyButton(this, SWT.NONE);", "    {", "      Menu menu = new Menu(this, SWT.BAR);", "      setMenuBar(menu);", "    }", "  }", "}");
        GraphicalEditPart barPart = this.canvas.getEditPart(barInfo);
        this.loadCreationTool("org.eclipse.swt.widgets.MenuItem");
        this.canvas.moveTo(barPart);
        this.canvas.click();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    new MyButton(this, SWT.NONE);", "    {", "      Menu menu = new Menu(this, SWT.BAR);", "      setMenuBar(menu);", "      {", "        MenuItem menuItem = new MenuItem(menu, SWT.NONE);", "        menuItem.setText('New Item');", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_cascadeSubMenu_andRCP() throws Exception {
        CompositeInfo shellInfo = this.openComposite("public class Test extends Shell {", "  public Test() {", "    {", "      Menu menu = new Menu(this, SWT.BAR);", "      setMenuBar(menu);", "    }", "  }", "}");
        MenuInfo barInfo = (MenuInfo)shellInfo.getChildren(MenuInfo.class).get(0);
        GraphicalEditPart barPart = this.canvas.getEditPart(barInfo);
        this.loadCreationTool("org.eclipse.swt.widgets.MenuItem", "cascade");
        this.canvas.moveTo(barPart);
        this.canvas.click();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    {", "      Menu menu = new Menu(this, SWT.BAR);", "      setMenuBar(menu);", "      {", "        MenuItem menuItem = new MenuItem(menu, SWT.CASCADE);", "        menuItem.setText('New SubMenu');", "        {", "          Menu menu_1 = new Menu(menuItem);", "          menuItem.setMenu(menu_1);", "        }", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_TableColumn_PopupMenu_menuFirst() throws Exception {
        this.check_TableColumn_PopupMenu("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Table table = new Table(this, SWT.BORDER);", "      table.setHeaderVisible(true);", "      {", "        Menu popup = new Menu(table);", "        table.setMenu(popup);", "      }", "      {", "        TableColumn tableColumn = new TableColumn(table, SWT.NONE);", "        tableColumn.setWidth(100);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_TableColumn_PopupMenu_menuSecond() throws Exception {
        this.check_TableColumn_PopupMenu("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Table table = new Table(this, SWT.BORDER);", "      table.setHeaderVisible(true);", "      {", "        TableColumn tableColumn = new TableColumn(table, SWT.NONE);", "        tableColumn.setWidth(100);", "      }", "      {", "        Menu popup = new Menu(table);", "        table.setMenu(popup);", "      }", "    }", "  }", "}");
    }

    private void check_TableColumn_PopupMenu(String ... lines) throws Exception {
        CompositeInfo shell = this.openComposite(lines);
        ControlInfo table = (ControlInfo)shell.getChildrenControls().get(0);
        MenuInfo popup = (MenuInfo)table.getChildren(MenuInfo.class).get(0);
        this.canvas.target(popup).in(10, 10).move().click();
        this.canvas.assertPrimarySelected(popup);
    }
}

