/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.swtbot.designer;

import java.util.Arrays;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.wb.tests.swtbot.designer.AbstractSWTBotTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;

public abstract class AbstractWizardTest
extends AbstractSWTBotTest {
    private SWTBotShell shell;
    protected SWTBot editor;

    @AfterEach
    public void tearDown() {
        this.bot.resetWorkbench();
    }

    protected final void testTemplateViaProjectExplorer(String ... fullPath) {
        this.shell = this.bot.getProjectExplorer().openNewWizard();
        this.createTemplate(fullPath);
    }

    protected final void testTemplateViaMenu(String ... fullPath) {
        this.shell = this.bot.openNewWizard();
        this.createTemplate(fullPath);
    }

    private void createTemplate(String ... fullPath) {
        Assertions.assertTrue((fullPath.length > 1 ? 1 : 0) != 0, (String)"path requires at least one argument (template name)");
        String[] path = Arrays.copyOf(fullPath, fullPath.length - 1);
        String name = fullPath[fullPath.length - 1];
        String fileName = name.replaceAll(" ", "_");
        SWTBot newWizard = this.shell.bot();
        newWizard.tree().expandNode(path).getNode(name).select();
        newWizard.button("Next >").click();
        newWizard.text(1).setText("test");
        newWizard.text(2).setText(fileName);
        newWizard.button("Finish").click();
        this.bot.addFile("test", fileName + ".java");
        this.editor = this.bot.editorByTitle(fileName + ".java").bot();
        this.editor.cTabItem("Design").activate();
    }
}

