/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.core.utils.reflect.ProjectClassLoader;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.PdeProjectConversionUtils;
import org.eclipse.wb.tests.designer.core.TestProject;
import org.eclipse.wb.tests.designer.core.annotations.DisposeProjectAfter;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Before;
import org.junit.Test;

public class ProjectClassLoaderTest
extends SwingModelTest {
    private static IWorkspace workspace = ResourcesPlugin.getWorkspace();
    private static IWorkspaceRoot workspaceRoot = workspace.getRoot();
    private static final String workspaceLocation = workspaceRoot.getLocation().toPortableString();

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        if (m_project != null) {
            m_project.refreshLocal(2, null);
        }
    }

    @Test
    public void test_getPackage() throws Exception {
        ProjectClassLoaderTest.setFileContentSrc("test/SuperPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "abstract public class SuperPanel extends JPanel {", "}"));
        ProjectClassLoaderTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "abstract class Test extends SuperPanel {", "  public Test() {", "  }", "}");
        Class superPanelClass = panel.getDescription().getComponentClass();
        ProjectClassLoaderTest.assertNotNull((Object)superPanelClass.getPackage());
        ProjectClassLoaderTest.assertEquals((Object)"test", (Object)superPanelClass.getPackage().getName());
    }

    @Test
    public void test_inheritanceWithAbstractMethod_noInvocation() throws Exception {
        ProjectClassLoaderTest.setFileContentSrc("test/AbstractPanel.java", this.getTestSource("abstract public class AbstractPanel extends JPanel {", "  protected abstract int myAbstractMethod();", "}"));
        ProjectClassLoaderTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "abstract class Test extends AbstractPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_inheritanceWithAbstractMethod_withInvocation() throws Exception {
        ProjectClassLoaderTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public abstract class MyPanel extends JPanel {", "  private final String m_foo;", "  public MyPanel() {", "    m_foo = getFoo();", "  }", "  protected abstract String getFoo();", "}"));
        ProjectClassLoaderTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public abstract class Test extends MyPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        ProjectClassLoaderTest.assertNoErrors((JavaInfo)panel);
        ProjectClassLoaderTest.assertEquals((Object)"<dynamic>", (Object)ReflectionUtils.getFieldObject((Object)panel.getObject(), (String)"m_foo"));
    }

    @Test
    public void test_inheritanceWithAbstractMethod_voidInvocation() throws Exception {
        ProjectClassLoaderTest.setFileContentSrc("test/AbstractPanel.java", this.getTestSource("abstract public class AbstractPanel extends JPanel {", "  public AbstractPanel() {", "    myAbstractMethod();", "  }", "  protected abstract void myAbstractMethod();", "}"));
        ProjectClassLoaderTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "abstract class Test extends AbstractPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_inheritanceWithInterfaces() throws Exception {
        ProjectClassLoaderTest.setFileContentSrc("test/ValueProvider2.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public interface ValueProvider2 {", "  int getValue();", "}"));
        ProjectClassLoaderTest.setFileContentSrc("test/AbstractPanel.java", this.getTestSource("abstract public class AbstractPanel extends JPanel implements ValueProvider2 {", "}"));
        ProjectClassLoaderTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "abstract class Test extends AbstractPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_inheritanceImplementCall() throws Exception {
        ProjectClassLoaderTest.setFileContentSrc("test/ValueProvider.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public interface ValueProvider {", "  int getValue();", "}"));
        ProjectClassLoaderTest.setFileContentSrc("test/MyAbstractButton.java", this.getTestSource("public abstract class MyAbstractButton extends JButton implements ValueProvider {", "  public void setHorizontalAlignment(int alignment) {", "    super.setHorizontalAlignment( getValue() );", "  }", "}"));
        ProjectClassLoaderTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends MyAbstractButton {", "  public int getValue() {", "    return 0;", "  }", "}"));
        ProjectClassLoaderTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("abstract class Test extends JPanel {", "  public Test() {", "  MyButton button = new MyButton();", "    add( button );", "    button.setHorizontalAlignment(0);", "  }", "}");
        ProjectClassLoaderTest.assertNoErrors((JavaInfo)panel);
    }

    @DisposeProjectAfter
    @Test
    public void test_importPackage() throws Exception {
        PdeProjectConversionUtils.convertToPDE(m_project, null);
        TestProject projectWithPackage = new TestProject("SomeProject");
        try {
            PdeProjectConversionUtils.convertToPDE(projectWithPackage.getProject(), null);
            ProjectClassLoaderTest.setFileContentSrc(projectWithPackage.getProject(), "my/classes/MyClass.java", ProjectClassLoaderTest.getSource("// filler filler filler filler filler", "package my.classes;", "public class MyClass {", "}"));
            IFile manifestFile = ProjectClassLoaderTest.getFile(projectWithPackage.getProject(), "META-INF/MANIFEST.MF");
            Object manifest = ProjectClassLoaderTest.getFileContent(manifestFile);
            manifest = ((String)manifest).trim() + "\nExport-Package: my.classes\n\n";
            ProjectClassLoaderTest.setFileContent(manifestFile, (String)manifest);
            manifestFile = ProjectClassLoaderTest.getFile(m_testProject.getProject(), "META-INF/MANIFEST.MF");
            manifest = ProjectClassLoaderTest.getFileContent(manifestFile);
            manifest = ((String)manifest).trim() + "\nImport-Package: my.classes\n\n";
            ProjectClassLoaderTest.setFileContent(manifestFile, (String)manifest);
            ProjectClassLoaderTest.waitForAutoBuild();
            ProjectClassLoader classLoader = ProjectClassLoader.create(null, (IJavaProject)m_javaProject);
            classLoader.loadClass("my.classes.MyClass");
        }
        finally {
            projectWithPackage.dispose();
        }
    }

    @DisposeProjectAfter
    @Test
    public void test_fragments() throws Exception {
        PdeProjectConversionUtils.convertToPDE(m_testProject.getProject(), null);
        TestProject fragmentProject = new TestProject("TestProject_ru");
        try {
            PdeProjectConversionUtils.convertToPDE(fragmentProject.getProject(), "TestProject");
            ProjectClassLoaderTest.setFileContent(m_testProject.getProject(), "src/com/test", "Application.properties", ProjectClassLoaderTest.getSourceDQ("shell.text=Hello!"));
            ProjectClassLoaderTest.setFileContent(fragmentProject.getProject(), "src/com/test", "Application_ru.properties", ProjectClassLoaderTest.getSourceDQ("shell.text=Privet!"));
            ProjectClassLoaderTest.waitForAutoBuild();
            ProjectClassLoader classLoader = ProjectClassLoader.create(null, (IJavaProject)m_testProject.getJavaProject());
            ProjectClassLoaderTest.assertNotNull((Object)classLoader.getResource("com/test/Application.properties"));
            ProjectClassLoaderTest.assertNotNull((Object)classLoader.getResource("com/test/Application_ru.properties"));
        }
        finally {
            fragmentProject.dispose();
        }
    }

    @DisposeProjectAfter
    @Test
    public void test_fragments_cycle() throws Exception {
        PdeProjectConversionUtils.convertToPDE(m_testProject.getProject(), null);
        TestProject fragmentProject = new TestProject("TestProject_ru");
        try {
            PdeProjectConversionUtils.convertToPDE(fragmentProject.getProject(), "TestProject");
            ProjectClassLoaderTest.setFileContent(m_testProject.getProject(), "src/com/test", "Application.properties", ProjectClassLoaderTest.getSourceDQ("shell.text=Hello!"));
            ProjectClassLoaderTest.setFileContent(fragmentProject.getProject(), "src/com/test", "Application_ru.properties", ProjectClassLoaderTest.getSourceDQ("shell.text=Privet!"));
            ProjectClassLoaderTest.waitForAutoBuild();
            m_testProject.addRequiredProject(fragmentProject);
            ProjectClassLoader classLoader = ProjectClassLoader.create(null, (IJavaProject)m_testProject.getJavaProject());
            ProjectClassLoaderTest.assertNotNull((Object)classLoader.getResource("com/test/Application.properties"));
            ProjectClassLoaderTest.assertNotNull((Object)classLoader.getResource("com/test/Application_ru.properties"));
        }
        finally {
            fragmentProject.dispose();
        }
    }

    @DisposeProjectAfter
    @Test
    public void test_fragments_notJavaFragment() throws Exception {
        PdeProjectConversionUtils.convertToPDE(m_testProject.getProject(), null);
        TestProject fragmentProject = new TestProject("TestProject_ru");
        try {
            PdeProjectConversionUtils.convertToPDE(fragmentProject.getProject(), "TestProject");
            ProjectUtils.removeNature((IProject)fragmentProject.getProject(), (String)"org.eclipse.jdt.core.javanature");
            ProjectClassLoaderTest.setFileContent(m_testProject.getProject(), "src/com/test", "Application.properties", ProjectClassLoaderTest.getSourceDQ("shell.text=Hello!"));
            ProjectClassLoaderTest.setFileContent(fragmentProject.getProject(), "com/test", "Application_ru.properties", ProjectClassLoaderTest.getSourceDQ("shell.text=Privet!"));
            ProjectClassLoaderTest.waitForAutoBuild();
            ProjectClassLoader classLoader = ProjectClassLoader.create(null, (IJavaProject)m_testProject.getJavaProject());
            ProjectClassLoaderTest.assertNotNull((Object)classLoader.getResource("com/test/Application.properties"));
            ProjectClassLoaderTest.assertNotNull((Object)classLoader.getResource("com/test/Application_ru.properties"));
        }
        finally {
            fragmentProject.dispose();
        }
    }

    @DisposeProjectAfter
    @Test
    public void test_fragments_ofRequiredProject() throws Exception {
        PdeProjectConversionUtils.convertToPDE(m_testProject.getProject(), null);
        TestProject requiredProject = new TestProject("RequiredProject");
        TestProject fragmentProject = new TestProject("RequiredProject_ru");
        try {
            PdeProjectConversionUtils.convertToPDE(requiredProject.getProject(), null);
            PdeProjectConversionUtils.convertToPDE(fragmentProject.getProject(), "RequiredProject");
            ProjectClassLoaderTest.setFileContent(requiredProject.getProject(), "src/com/test", "Application.properties", ProjectClassLoaderTest.getSourceDQ("shell.text=Hello!"));
            ProjectClassLoaderTest.setFileContent(fragmentProject.getProject(), "src/com/test", "Application_ru.properties", ProjectClassLoaderTest.getSourceDQ("shell.text=Privet!"));
            m_testProject.addRequiredProject(requiredProject);
            ProjectClassLoaderTest.waitForAutoBuild();
            ProjectClassLoader classLoader = ProjectClassLoader.create(null, (IJavaProject)m_testProject.getJavaProject());
            ProjectClassLoaderTest.assertNotNull((Object)classLoader.getResource("com/test/Application.properties"));
            ProjectClassLoaderTest.assertNotNull((Object)classLoader.getResource("com/test/Application_ru.properties"));
        }
        finally {
            fragmentProject.dispose();
            requiredProject.dispose();
        }
    }

    @Test
    public void test_addSourceLocations_normalProject() throws Exception {
        List<String> locations = this.getSourceLocations();
        Assertions.assertThat(locations).containsExactly((Object[])new String[]{workspaceLocation + "/TestProject/src"});
    }

    @DisposeProjectAfter
    @Test
    public void test_addSourceLocations_noSuchProject() throws Exception {
        m_project.delete(true, null);
        List<String> locations = this.getSourceLocations();
        Assertions.assertThat(locations).isEmpty();
    }

    @DisposeProjectAfter
    @Test
    public void test_addSourceLocations_notJavaProject() throws Exception {
        ProjectUtils.removeNature((IProject)m_project, (String)"org.eclipse.jdt.core.javanature");
        List<String> locations = this.getSourceLocations();
        Assertions.assertThat(locations).isEmpty();
    }

    @DisposeProjectAfter
    @Test
    public void test_addSourceLocations_projectNotInWorkspace() throws Exception {
        String newProjectLocation = ProjectClassLoaderTest.moveProjectIntoWorkspaceSubFolder();
        List<String> locations = this.getSourceLocations();
        Assertions.assertThat(locations).containsExactly((Object[])new String[]{newProjectLocation + "/src"});
    }

    @DisposeProjectAfter
    @Test
    public void test_addSourceLocations_recursion() throws Exception {
        TestProject myProject = new TestProject("myProject");
        IJavaProject myJavaProject = myProject.getJavaProject();
        try {
            ProjectUtils.requireProject((IJavaProject)m_javaProject, (IJavaProject)myJavaProject);
            ProjectUtils.requireProject((IJavaProject)myJavaProject, (IJavaProject)m_javaProject);
            List<String> locations = this.getSourceLocations();
            Assertions.assertThat(locations).containsExactly((Object[])new String[]{workspaceLocation + "/TestProject/src", workspaceLocation + "/myProject/src"});
        }
        finally {
            myProject.dispose();
        }
    }

    @DisposeProjectAfter
    @Test
    public void test_addSourceLocations_oldProjectStyle() throws Exception {
        ProjectClassLoaderTest.setFileContent(".classpath", ProjectClassLoaderTest.getSourceDQ("<classpath>", "  <classpathentry kind='con' path='org.eclipse.jdt.launching.JRE_CONTAINER'/>", "  <classpathentry kind='src' path=''/>", "  <classpathentry kind='output' path='bin'/>", "</classpath>"));
        List<String> locations = this.getSourceLocations();
        Assertions.assertThat(locations).containsExactly((Object[])new String[]{workspaceLocation + "/TestProject"});
    }

    public static String moveProjectIntoWorkspaceSubFolder() throws Exception {
        String newProjectLocation = workspaceLocation + "/subFolder/Test";
        File oldProjectFile = new File(m_project.getLocation().toPortableString());
        File newProjectFile = new File(newProjectLocation);
        FileUtils.deleteQuietly((File)newProjectFile);
        FileUtils.copyDirectory((File)oldProjectFile, (File)newProjectFile);
        m_project.delete(true, null);
        IProjectDescription projectDescription = workspace.newProjectDescription("Test");
        projectDescription.setLocation((IPath)new Path(newProjectLocation));
        m_project = workspaceRoot.getProject("Test");
        m_project.create(projectDescription, null);
        m_project.open(null);
        m_testProject = new TestProject(m_project);
        m_javaProject = m_testProject.getJavaProject();
        return newProjectLocation;
    }

    private List<String> getSourceLocations() throws Exception {
        ArrayList<String> locations = new ArrayList<String>();
        ProjectClassLoader.addSourceLocations(new HashSet(), locations, (IProject)m_project);
        return locations;
    }

    @Test
    public void test_addOutputLocations_normalProject() throws Exception {
        List<String> locations = this.getOutputLocations();
        Assertions.assertThat(locations).containsExactly((Object[])new String[]{workspaceLocation + "/TestProject/bin"});
    }

    @DisposeProjectAfter
    @Test
    public void test_addOutputLocations_noSuchProject() throws Exception {
        m_project.delete(true, null);
        List<String> locations = this.getOutputLocations();
        Assertions.assertThat(locations).isEmpty();
    }

    @DisposeProjectAfter
    @Test
    public void test_addOutputLocations_notJavaProject() throws Exception {
        ProjectUtils.removeNature((IProject)m_project, (String)"org.eclipse.jdt.core.javanature");
        List<String> locations = this.getOutputLocations();
        Assertions.assertThat(locations).isEmpty();
    }

    @DisposeProjectAfter
    @Test
    public void test_addOutputLocations_projectNotInWorkspace() throws Exception {
        String newProjectLocation = ProjectClassLoaderTest.moveProjectIntoWorkspaceSubFolder();
        List<String> locations = this.getOutputLocations();
        Assertions.assertThat(locations).containsExactly((Object[])new String[]{newProjectLocation + "/bin"});
    }

    @DisposeProjectAfter
    @Test
    public void test_addOutputLocations_recursion() throws Exception {
        TestProject myProject = new TestProject("myProject");
        IJavaProject myJavaProject = myProject.getJavaProject();
        try {
            ProjectUtils.requireProject((IJavaProject)m_javaProject, (IJavaProject)myJavaProject);
            ProjectUtils.requireProject((IJavaProject)myJavaProject, (IJavaProject)m_javaProject);
            List<String> locations = this.getOutputLocations();
            Assertions.assertThat(locations).containsExactly((Object[])new String[]{workspaceLocation + "/TestProject/bin", workspaceLocation + "/myProject/bin"});
        }
        finally {
            myProject.dispose();
        }
    }

    private List<String> getOutputLocations() throws Exception {
        ArrayList<String> locations = new ArrayList<String>();
        ProjectClassLoader.addOutputLocations(new HashSet(), locations, (IProject)m_project);
        return locations;
    }
}

