/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.structure.property;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.wb.core.editor.IDesignPageSite;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.Messages;
import org.eclipse.wb.internal.core.editor.structure.property.IPropertiesToolBarContributor;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;

public final class JavaPropertiesToolBarContributor
implements IPropertiesToolBarContributor {
    public static final IPropertiesToolBarContributor INSTANCE = new JavaPropertiesToolBarContributor();

    private JavaPropertiesToolBarContributor() {
    }

    public void contributeToolBar(IToolBarManager manager, List<ObjectInfo> objects) throws Exception {
        this.addGotoDefinitionAction(manager, objects);
        this.addVariableConvertAction(manager, objects);
    }

    private void addGotoDefinitionAction(IToolBarManager manager, List<ObjectInfo> objects) {
        if (objects.size() == 1 && objects.get(0) instanceof JavaInfo) {
            final JavaInfo javaInfo = (JavaInfo)objects.get(0);
            Action gotoDefinitionAction = new Action(){

                public void run() {
                    int position = javaInfo.getCreationSupport().getNode().getStartPosition();
                    IDesignPageSite site = IDesignPageSite.Helper.getSite((ObjectInfo)javaInfo);
                    site.openSourcePosition(position);
                }
            };
            gotoDefinitionAction.setImageDescriptor(DesignerPlugin.getImageDescriptor((String)"structure/goto_definition.gif"));
            gotoDefinitionAction.setToolTipText(Messages.ComponentsPropertiesPage_goDefinition);
            manager.appendToGroup("org.eclipse.wb.component-properties.group.edit", (IAction)gotoDefinitionAction);
        }
    }

    private void addVariableConvertAction(IToolBarManager manager, List<ObjectInfo> objects) {
        if (objects.size() == 1 && objects.get(0) instanceof JavaInfo) {
            final JavaInfo javaInfo = (JavaInfo)objects.get(0);
            final VariableSupport variableSupport = javaInfo.getVariableSupport();
            Action variableConvertAction = new Action(){

                public void run() {
                    ExecutionUtils.run((ObjectInfo)javaInfo, (RunnableEx)new RunnableEx(){

                        public void run() throws Exception {
                            if (variableSupport.canConvertLocalToField()) {
                                variableSupport.convertLocalToField();
                            } else if (variableSupport.canConvertFieldToLocal()) {
                                variableSupport.convertFieldToLocal();
                            }
                        }
                    });
                }
            };
            boolean enabled = false;
            if (variableSupport.canConvertLocalToField()) {
                variableConvertAction.setImageDescriptor(DesignerPlugin.getImageDescriptor((String)"structure/local_to_field.gif"));
                variableConvertAction.setToolTipText(Messages.ComponentsPropertiesPage_convertLocalToFieldAction);
                enabled = true;
            }
            if (!enabled && variableSupport.canConvertFieldToLocal()) {
                variableConvertAction.setImageDescriptor(DesignerPlugin.getImageDescriptor((String)"structure/field_to_local.gif"));
                variableConvertAction.setToolTipText(Messages.ComponentsPropertiesPage_convertFieldToLocalAction);
                enabled = true;
            }
            if (enabled) {
                manager.appendToGroup("org.eclipse.wb.component-properties.group.edit", (IAction)variableConvertAction);
            }
        }
    }
}

