/* GLE - The GTK+ Layout Editor
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include	"config.h"

#include	"glemenus.h"
#include	"glepopups.h"
#include	"glemainwindow.h"
#include	"gleeditor.h"
#include	"gleprivate.h"


/* --- typedefs --- */
typedef struct _GleMenuPos	GleMenuPos;
struct _GleMenuPos
{
  guint x;
  guint y;
};


/* --- variables --- */
static GtkMenu	*gle_menu_widget_ops = NULL;
static gchar	*gle_key_menu_widget = "gle-menu-widget";


/* --- functions --- */
static void
gle_menu_edit_widget (GtkWidget *item,
		      gpointer   func_data)
{
  GtkWidget *widget;
  GtkWidget *dialog;

  widget = func_data;
  widget = gtk_object_get_data (GTK_OBJECT (gle_menu_widget_ops), gle_key_menu_widget);
  dialog = gle_widget_editor_popup (widget);
  gle_widget_set_life_time (dialog);
}

static void
gle_menu_dump_tree (GtkWidget *item,
		    gpointer   func_data)
{
  GtkWidget *widget;
  GtkWidget *dialog;

  widget = func_data;
  widget = gtk_object_get_data (GTK_OBJECT (gle_menu_widget_ops), gle_key_menu_widget);
  dialog = gle_popup_dialog (NULL,
			     NULL,
			     "Button Remove" /* FIXME */,
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     NULL,
			     "Tree dump requested for\n<%s>\n",
			     gtk_type_name (GTK_OBJECT (widget)->klass->type));
  gle_widget_set_life_time (dialog);
}

static void
gle_menu_show_signals (GtkWidget *item,
		       gpointer   func_data)
{
  GtkWidget *widget;
  GtkWidget *dialog;

  widget = func_data;
  widget = gtk_object_get_data (GTK_OBJECT (gle_menu_widget_ops), gle_key_menu_widget);
  dialog = gle_class_show_signals (GTK_OBJECT (widget)->klass, "");
  gle_widget_set_life_time (dialog);
}

static void
gle_menu_show_flags (GtkWidget *item,
		     gpointer   func_data)
{
  GtkWidget *widget;
  GtkWidget *dialog;

  widget = func_data;
  widget = gtk_object_get_data (GTK_OBJECT (gle_menu_widget_ops), gle_key_menu_widget);
  dialog = gle_widget_show_flags (widget);
  gle_widget_set_life_time (dialog);
}

static void
gle_menu_widegt_ops_create (void)
{
  GtkWidget *item;
  GtkWidget *menu;

  g_assert (gle_menu_widget_ops == NULL);

  menu = gtk_menu_new ();
  gle_object_set_gle_tag (GTK_OBJECT (menu));

  item = gtk_menu_item_new_with_label ("Widget Operations");
  gtk_widget_set_sensitive (item, FALSE);
  gtk_menu_append (GTK_MENU (menu), item);
  gtk_widget_show (item);

  item = gtk_menu_item_new ();
  gtk_widget_set_sensitive (item, FALSE);
  gtk_menu_append (GTK_MENU (menu), item);
  gtk_widget_show (item);

  item = gtk_menu_item_new_with_label ("Popup Editor");
  gtk_signal_connect(GTK_OBJECT (item), "activate",
		     GTK_SIGNAL_FUNC (gle_menu_edit_widget),
		     menu);
  gtk_menu_append (GTK_MENU (menu), item);
  gtk_widget_show (item);

  item = gtk_menu_item_new_with_label ("Show Signals");
  gtk_signal_connect(GTK_OBJECT (item), "activate",
		     GTK_SIGNAL_FUNC (gle_menu_show_signals),
		     menu);
  gtk_menu_append (GTK_MENU (menu), item);
  gtk_widget_show (item);

  item = gtk_menu_item_new_with_label ("Show Flags");
  gtk_signal_connect(GTK_OBJECT (item), "activate",
		     GTK_SIGNAL_FUNC (gle_menu_show_flags),
		     menu);
  gtk_menu_append (GTK_MENU (menu), item);
  gtk_widget_show (item);

  item = gtk_menu_item_new_with_label ("Dump Tree");
  gtk_signal_connect(GTK_OBJECT (item), "activate",
		     GTK_SIGNAL_FUNC (gle_menu_dump_tree),
		     menu);
  gtk_menu_append (GTK_MENU (menu), item);
  gtk_widget_show (item);

  item = gtk_menu_item_new ();
  gtk_widget_set_sensitive (item, FALSE);
  gtk_menu_append (GTK_MENU (menu), item);
  gtk_widget_show (item);

  gle_menu_widget_ops = GTK_MENU (menu);
}

static void
gle_menu_position_func (GtkMenu        *menu,
			gint           *x,
			gint           *y,
			gpointer       func_data)
{
  GleMenuPos *mpos;

  mpos = func_data;

  *x = mpos->x;
  *y = mpos->y;
}

GtkWidget*
gle_menu_widegt_ops_popup (GtkWidget      *widget,
			   guint	   x,
			   guint	   y,
			   guint32	   time)
{
  GleMenuPos mpos;

  g_return_val_if_fail (widget != NULL, NULL);
  g_return_val_if_fail (GTK_IS_WIDGET (widget), NULL);
  
  if (!gle_menu_widget_ops)
    gle_menu_widegt_ops_create ();

  mpos.x = x;
  mpos.y = y;

  gtk_object_set_data (GTK_OBJECT (gle_menu_widget_ops), gle_key_menu_widget, widget);
  gtk_menu_popup (gle_menu_widget_ops,
		  NULL, NULL,
		  gle_menu_position_func, &mpos,
		  0, time);
  return GTK_WIDGET (gle_menu_widget_ops);
}
