/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.BitVector;
import com.sun.electric.tool.simulation.test.ChainControl;
import com.sun.electric.tool.simulation.test.ChainNode;
import com.sun.electric.tool.simulation.test.Infrastructure;
import com.sun.electric.tool.simulation.test.ManualPowerChannel;
import com.sun.electric.tool.simulation.test.PowerChannel;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Random;

public class ChainTest {
    public boolean readEnable = false;
    public boolean writeEnable = false;
    public static final int DEFAULT_KHZ_STEP = 1000;
    public static final int LENGTH_MULTIPLIER = 100;
    static int seed = 1256;
    static Random rand = new Random(seed);
    static int count = 1;
    private ChainControl control;
    private int numTests = 5;
    PowerChannel vddSupply;
    private int mvLow;
    private int mvHigh;
    private int mvStep = 100;
    private int khzLow;
    private int khzHigh;
    private int khzStep = 1000;

    public ChainTest(ChainControl control, PowerChannel vddSupply) {
        this.control = control;
        this.vddSupply = vddSupply;
        this.mvLow = ChainTest.roundMillivolts(950.0f * control.getJtagVolts());
        this.mvHigh = ChainTest.roundMillivolts(1050.0f * control.getJtagVolts());
        if (this.mvLow == this.mvHigh) {
            this.mvLow = this.mvHigh - 100;
        }
        this.khzLow = ChainTest.roundKHz(0.8f * (float)control.getJtagKhz());
        this.khzHigh = control.getJtagKhz();
        if (this.khzLow == this.khzHigh) {
            this.khzLow = this.khzHigh - 1000;
        }
    }

    public ChainTest(ChainControl control) {
        this(control, null);
        this.vddSupply = new ManualPowerChannel("fake", false);
    }

    public int measureLength(String chainRoot, int severity) {
        if (this.readEnable || this.writeEnable) {
            System.err.println("ChainTest.measureLength() warning: results may be incorrect when readEnable or writeEnable is true");
        }
        int expectedLength = this.control.getLength(chainRoot);
        BitVector inBits = new BitVector(expectedLength, "measureLength()-expectedLength");
        inBits.set(0, expectedLength, false);
        this.control.setInBits(chainRoot, inBits);
        for (int ind = 0; ind < 100; ++ind) {
            this.control.shift(chainRoot, this.readEnable, this.writeEnable, 3, 0, 0);
        }
        BitVector outBits = this.control.getOutBits(chainRoot);
        if (!outBits.isEmpty()) {
            Infrastructure.fatal("Have shifted " + expectedLength + " zeroes into chain " + chainRoot + " " + 100 + " times in a row, and the final shift scanned out at " + "least one non-zero bit.  The chain is broken or its" + "true length is more than " + 100 + "times the claimed length of " + expectedLength);
        }
        inBits.set(expectedLength - 1);
        this.control.setInBits(chainRoot, inBits);
        int ind = 0;
        boolean bit = false;
        do {
            bit = this.control.shiftOneBit(chainRoot, this.readEnable, this.writeEnable, 3);
            ++ind;
        } while (!bit);
        if (--ind != expectedLength) {
            Infrastructure.error(severity, "Chain " + chainRoot + " has claimed length of " + expectedLength + ", but measured length is " + ind);
        }
        return ind;
    }

    public boolean testLengths(int severity) {
        boolean status = true;
        String[] roots = this.control.getChainPaths();
        for (int iroot = 0; iroot < roots.length; ++iroot) {
            System.out.print("Verifying length, chain " + iroot + ": " + roots[iroot] + " ");
            int length = this.measureLength(roots[iroot], severity);
            if (length == this.control.getLength(roots[iroot])) {
                System.out.println("passed");
                continue;
            }
            if (severity != 0) continue;
            System.out.println("failed; change length to " + length);
            status = false;
        }
        return status;
    }

    public boolean testOneChain(String chainRoot, int errTestSeverity) {
        int len = this.control.getLength(chainRoot);
        this.control.setInBits(chainRoot, ChainTest.getRandomBits(len));
        this.control.shift(chainRoot, this.readEnable, this.writeEnable, 0, 0, 0);
        for (int iTest = 0; iTest < this.numTests; ++iTest) {
            this.control.setInBits(chainRoot, ChainTest.getRandomBits(len));
            boolean result2 = this.control.shift(chainRoot, this.readEnable, this.writeEnable, 0, 3, errTestSeverity);
            if (result2) continue;
            return false;
        }
        return true;
    }

    public boolean testOneChainShadow(String chainRoot, int errTestSeverity) {
        ChainNode chain2 = (ChainNode)this.control.findNode(chainRoot);
        if (!(chain2.isReadable() && chain2.isWriteable() && chain2.usesShadow())) {
            Infrastructure.fatal("Chain " + chain2 + " does not have RW shadow register, as required" + " to use testOneChainShadow()");
        }
        int len = this.control.getLength(chainRoot);
        this.control.setInBits(chainRoot, ChainTest.getRandomBits(len));
        this.control.shift(chainRoot, false, false, 0, 0, 0);
        for (int iTest = 0; iTest < this.numTests; ++iTest) {
            this.control.setInBits(chainRoot, ChainTest.getRandomBits(len));
            this.control.shift(chainRoot, false, true, 0, 0, 0);
            this.control.setInBits(chainRoot, ChainTest.getRandomBits(len));
            if (this.control.shift(chainRoot, true, false, 0, 3, errTestSeverity)) continue;
            return false;
        }
        return true;
    }

    public int testAllChains(String chipName, int errTestSeverity) {
        int numFail = 0;
        String[] roots = this.control.getChainPaths(chipName);
        for (int iroot = 0; iroot < roots.length; ++iroot) {
            System.out.print("Trying dual shift to chain " + iroot + ": " + roots[iroot] + "... ");
            if (this.testOneChain(roots[iroot], errTestSeverity)) {
                System.out.println(" passed.");
                continue;
            }
            ++numFail;
            System.out.println(" failed.");
        }
        if (numFail > 0) {
            System.err.println(numFail + " out of " + roots.length + " chains failed on chip " + chipName);
        }
        return numFail;
    }

    public int testAllChains(int errTestSeverity) {
        int numFail = 0;
        String[] chips = this.control.getChips();
        for (int ichip = 0; ichip < chips.length; ++ichip) {
            numFail += this.testAllChains(chips[ichip], errTestSeverity);
        }
        if (numFail > 0) {
            System.err.println(numFail + " chains failed in system!");
        }
        return numFail;
    }

    public void schmooPlot(String chainRoot, String failFile, String passFile) {
        this.schmooPlot(chainRoot, failFile, passFile, false, false);
    }

    public void schmooPlot(String chainRoot, String failFile, String passFile, boolean pulseReset) {
        this.schmooPlot(chainRoot, failFile, passFile, false, pulseReset);
    }

    public void schmooPlotShadow(String chainRoot, String failFile, String passFile, boolean pulseReset) {
        this.schmooPlot(chainRoot, failFile, passFile, true, pulseReset);
    }

    private void schmooPlot(String chainRoot, String failFile, String passFile, boolean shadow, boolean pulseReset) {
        System.out.println("Generating Schmoo plot for chain " + chainRoot);
        try {
            PrintWriter fail = new PrintWriter(new FileWriter(failFile));
            fail.println("# voltage, frequency pairs that failed in Schmoo of " + chainRoot);
            PrintWriter pass = new PrintWriter(new FileWriter(passFile));
            pass.println("# voltage, frequency pairs that passed in Schmoo of " + chainRoot);
            for (int vdd_mV = this.mvLow; vdd_mV <= this.mvHigh; vdd_mV += this.mvStep) {
                float vdd = (float)vdd_mV / 1000.0f;
                this.vddSupply.setVoltageWait(vdd);
                System.out.println("Setting Vdd = " + vdd + " V");
                if (pulseReset) {
                    System.out.println("Resetting Jtag Tester");
                    this.control.jtag.reset();
                }
                for (int kiloHerz = this.khzLow; kiloHerz <= this.khzHigh; kiloHerz += this.khzStep) {
                    this.control.jtag.configure(this.control.getJtagVolts(), kiloHerz);
                    boolean status = shadow ? this.testOneChainShadow(chainRoot, 0) : this.testOneChain(chainRoot, 0);
                    if (status) {
                        pass.println(vdd_mV + " " + kiloHerz);
                    } else {
                        fail.println(vdd_mV + " " + kiloHerz);
                    }
                    System.out.println("freq " + kiloHerz + "kHz, voltage " + vdd + " V");
                }
            }
            fail.close();
            pass.close();
        }
        catch (Exception e) {
            System.err.println("exception occurred" + e);
        }
        System.out.println("Please set vdd back to something correct");
        this.control.jtag.configure(this.control.getJtagVolts(), this.control.getJtagKhz());
        ++count;
        System.out.println("finished testing " + chainRoot);
    }

    public void bringup(boolean testLengths) {
        if (testLengths && !this.testLengths(2)) {
            Infrastructure.fatal("Fix lengths in xml file and run again");
        }
        this.testAllChains(3);
        int maxLength = -1;
        String maxName = null;
        String[] chains = this.control.getChainPaths();
        for (int ichain = 0; ichain < chains.length; ++ichain) {
            int length = this.control.getLength(chains[ichain]);
            if (length <= maxLength) continue;
            maxLength = length;
            maxName = chains[ichain];
        }
        this.schmooPlot(maxName, "fail." + maxName + ".dat", "pass." + maxName + ".dat", false);
    }

    public int getKhzHigh() {
        return this.khzHigh;
    }

    public int getKhzLow() {
        return this.khzLow;
    }

    public int getKhzStep() {
        return this.khzStep;
    }

    public int getNumTests() {
        return this.numTests;
    }

    public float getVddHigh() {
        return (float)this.mvHigh / 1000.0f;
    }

    public float getVddLow() {
        return (float)this.mvLow / 1000.0f;
    }

    public float getVddStep() {
        return (float)this.mvStep / 1000.0f;
    }

    public void setKhzRange(int khzLow, int khzHigh, int khzStep) {
        this.khzLow = khzLow;
        this.khzHigh = khzHigh;
        this.khzStep = khzStep;
    }

    public void setNumTests(int numTests) {
        this.numTests = numTests;
    }

    public void setVddRange(float vddLow, float vddHigh, float vddStep) {
        this.mvLow = Math.round(vddLow * 1000.0f);
        this.mvHigh = Math.round(vddHigh * 1000.0f);
        this.mvStep = Math.round(vddStep * 1000.0f);
    }

    public static BitVector getRandomBits(int numBits) {
        BitVector bits2 = new BitVector(numBits, "getRandomBits()-bits");
        for (int ind = 0; ind < numBits; ++ind) {
            if (rand.nextBoolean()) {
                bits2.set(ind);
                continue;
            }
            bits2.clear(ind);
        }
        return bits2;
    }

    private static int roundMillivolts(float mV) {
        return Math.round(mV / 100.0f) * 100;
    }

    private static int roundKHz(float kHz) {
        return Math.round(kHz / 1000.0f) * 1000;
    }
}

