/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.CompiledExpression;
import gnu.jel.ImageLoader;
import gnu.jel.IntegerStack;
import gnu.jel.Library;
import gnu.jel.OP;
import gnu.jel.OPbinary;
import gnu.jel.OPcall;
import gnu.jel.OPcondtnl;
import gnu.jel.OPlist;
import gnu.jel.OPload;
import gnu.jel.OPunary;
import gnu.jel.PatchableByteArrayOutputStream;
import gnu.jel.TypesStack;
import gnu.jel.debug.Debug;
import gnu.jel.debug.Tester;
import gnu.jel.reflect.LocalField;
import gnu.jel.reflect.LocalMethod;
import gnu.jel.reflect.Member;
import gnu.jel.reflect.Method;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Stack;

public class ClassFile
implements Cloneable {
    private int poolEntries = 1;
    private ByteArrayOutputStream constPoolData;
    private DataOutputStream constPool;
    private Hashtable Items = new Hashtable();
    private Hashtable UTFs = new Hashtable();
    int nMethods = 0;
    int nMethodsPatch;
    protected PatchableByteArrayOutputStream textData;
    private DataOutputStream text;
    private boolean isInterface;
    private int startCodeAttr = 0;
    private int startCode = 0;
    private static final byte[] prologue = new byte[]{-54, -2, -70, -66, 0, 3, 0, 45};
    protected LocalMethod currMethod = null;
    int[] paramsVars = null;
    protected TypesStack typesStk = new TypesStack();
    protected int currJump = 0;
    protected boolean invert_next_jump = false;
    private IntegerStack jumps = new IntegerStack();
    private IntegerStack jumps0 = new IntegerStack();
    private IntegerStack jumps1 = new IntegerStack();
    private IntegerStack blocks0 = new IntegerStack();
    private IntegerStack blocks1 = new IntegerStack();
    private IntegerStack branchStack = new IntegerStack();
    private static final int[] load_ints = new int[]{2, 3, 4, 5, 6, 7, 8};
    private static final int[] load_long_ints = new int[]{34050, 9, 10, 34053, 34054, 34055, 34056};

    public ClassFile(int modifiers, String name, Class superClass, Class[] interfaces, LocalField[] fields) {
        this.constPoolData = new ByteArrayOutputStream();
        this.constPool = new DataOutputStream(this.constPoolData);
        this.textData = new PatchableByteArrayOutputStream();
        this.text = new DataOutputStream(this.textData);
        try {
            this.getUTFIndex(ClassFile.toHistoricalForm(name));
            Debug.assert((modifiers & 0xFFFFF9EE) == 0);
            this.isInterface = (modifiers & 0x200) > 0;
            this.text.writeShort(modifiers | 0x20);
            Debug.assert(this.poolEntries == 2);
            ++this.poolEntries;
            this.constPool.write(7);
            this.constPool.writeShort(1);
            this.text.writeShort(2);
            this.text.writeShort(this.getIndex(superClass, 9));
            int nInterfaces = interfaces == null ? 0 : interfaces.length;
            this.text.writeShort(nInterfaces);
            int i = 0;
            while (i < nInterfaces) {
                Debug.assert(interfaces[i].isInterface());
                this.text.writeShort(this.getIndex(interfaces[i], 9));
                ++i;
            }
            int nFields = fields == null ? 0 : fields.length;
            this.text.writeShort(nFields);
            int i2 = 0;
            while (i2 < nFields) {
                LocalField cLF = fields[i2];
                Debug.assert(cLF.getModifiers() >>> 16 == 1);
                Debug.assert(cLF.getDeclaringClass() == null);
                this.text.writeShort(cLF.getModifiers() & 0xFFFF);
                String nameLM = cLF.getName();
                this.text.writeShort(this.getUTFIndex(nameLM));
                this.text.writeShort(this.getUTFIndex(ClassFile.getSignature(cLF.getType())));
                this.text.writeShort(0);
                ++i2;
            }
            this.nMethodsPatch = this.textData.size();
            this.text.writeShort(0);
        }
        catch (IOException exc) {
            // empty catch block
        }
    }

    public Object clone() {
        ClassFile res = null;
        try {
            res = (ClassFile)super.clone();
            res.Items = (Hashtable)res.Items.clone();
            res.UTFs = (Hashtable)res.UTFs.clone();
            res.paramsVars = (int[])res.paramsVars.clone();
            res.typesStk = (TypesStack)res.typesStk.clone();
            res.jumps = (IntegerStack)res.jumps.clone();
            res.jumps0 = (IntegerStack)res.jumps0.clone();
            res.jumps1 = (IntegerStack)res.jumps1.clone();
            res.blocks0 = (IntegerStack)res.blocks0.clone();
            res.blocks1 = (IntegerStack)res.blocks1.clone();
            res.branchStack = (IntegerStack)res.branchStack.clone();
            res.constPoolData = new ByteArrayOutputStream();
            this.constPool.flush();
            this.constPoolData.writeTo(res.constPoolData);
            res.constPool = new DataOutputStream(res.constPoolData);
            res.textData = new PatchableByteArrayOutputStream();
            this.text.flush();
            this.textData.writeTo(res.textData);
            res.text = new DataOutputStream(res.textData);
        }
        catch (IOException exc) {
            Debug.reportThrowable(exc);
        }
        catch (CloneNotSupportedException exc) {
            Debug.reportThrowable(exc);
        }
        return res;
    }

    public void newMethod(LocalMethod m, Class[] vars) {
        Debug.assert(this.typesStk.size() == 0);
        Debug.assert(this.jumps0.size() == 0);
        Debug.assert(this.jumps1.size() == 0);
        Debug.assert(this.blocks0.size() == 0);
        Debug.assert(this.blocks1.size() == 0);
        Debug.assert(this.currJump == 0);
        try {
            this.finishMethod();
            ++this.nMethods;
            int mdfrs = m.getModifiers() & 0xFFFF;
            if (this.isInterface) {
                mdfrs |= 0x400;
            }
            boolean isAbstract = (mdfrs & 0x400) > 0;
            this.text.writeShort(mdfrs);
            this.text.writeShort(this.getUTFIndex(m.getName()));
            this.text.writeShort(this.getUTFIndex(ClassFile.getSignature(m)));
            int temp = 0;
            Class[] exceptions = m.getExceptionTypes();
            if (exceptions.length > 0) {
                ++temp;
            }
            if (!isAbstract) {
                ++temp;
            }
            this.text.writeShort(temp);
            temp = exceptions.length;
            if (temp > 0) {
                this.text.writeShort(this.getUTFIndex("Exceptions"));
                this.text.writeInt((temp + 1) * 2);
                this.text.writeShort(temp);
                int i = 0;
                while (i < temp) {
                    this.text.writeShort(this.getIndex(exceptions[i], 9));
                    ++i;
                }
            }
            if (!isAbstract) {
                this.startCodeAttr = this.textData.size();
                this.text.writeShort(this.getUTFIndex("Code"));
                this.text.writeInt(0);
                this.text.writeShort(0);
                Class[] params = m.getParameterTypes();
                int parlen = params == null ? 0 : params.length;
                int varlen = vars == null ? 0 : vars.length;
                int this_num = (mdfrs & 8) == 0 ? 1 : 0;
                int nLocalVars = parlen + varlen + this_num;
                this.paramsVars = new int[nLocalVars];
                int localsSize = 0;
                int i = 0;
                while (i < this.paramsVars.length) {
                    int j = i - this_num;
                    int typeID = i < this_num ? 8 : TypesStack.primitiveID(j < parlen ? params[j] : vars[j - parlen]);
                    this.paramsVars[i] = localsSize;
                    localsSize += TypesStack.stkoccup[typeID];
                    ++i;
                }
                this.text.writeShort(localsSize);
                this.text.writeInt(0);
                this.startCode = this.textData.size();
            }
            this.typesStk.resetStats();
            if (!isAbstract) {
                this.currMethod = m;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void finishMethod() throws IOException {
        if (this.currMethod != null) {
            int codeEnd = this.textData.size();
            this.text.writeShort(0);
            this.text.writeShort(0);
            int currPos = this.textData.size();
            this.textData.patchAddressInt(this.startCodeAttr + 2, currPos - this.startCodeAttr - 6);
            this.textData.patchAddress(this.startCodeAttr + 6, this.typesStk.getMaxOccupation());
            this.textData.patchAddress(this.startCode - 2, codeEnd - this.startCode);
            this.currMethod = null;
        }
    }

    public byte[] getImage() {
        ByteArrayOutputStream image = new ByteArrayOutputStream();
        try {
            this.finishMethod();
            this.text.writeShort(0);
            this.textData.patchAddress(this.nMethodsPatch, this.nMethods);
            image.write(prologue);
            image.write(this.poolEntries >>> 8 & 0xFF);
            image.write(this.poolEntries >>> 0 & 0xFF);
            this.constPoolData.writeTo(image);
            this.textData.writeTo(image);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return image.toByteArray();
    }

    private static final int invert_jump_bytecode(int jmp) {
        Debug.assert(jmp >= 153 && jmp <= 164, "Attempt to invert non jump bytecode (" + jmp + ")");
        return (jmp - 1 ^ 1) + 1;
    }

    protected void labels_block() {
        this.blocks0.push(this.jumps0.size());
        this.blocks1.push(this.jumps1.size());
    }

    protected void labels_unblock() {
        this.blocks0.pop_throw();
        this.blocks1.pop_throw();
    }

    protected void labels_unblock_not() {
        this.ensure_jump();
        IntegerStack.swap(this.jumps1, this.blocks1.pop(), this.jumps0, this.blocks0.pop());
        this.invert_next_jump = !this.invert_next_jump;
    }

    protected final void ensure_jump() {
        if (this.currJump != 0) {
            return;
        }
        Class a1 = this.typesStk.pop();
        Debug.assert(a1 == Boolean.TYPE, "Only booleans can generate jumps in ensurejump()");
        this.currJump = 157;
    }

    protected final void ensure_value() {
        if (this.currJump == 0) {
            boolean noPendingJumps;
            int blocked0 = 0;
            if (this.blocks0.size() > 0) {
                blocked0 = this.blocks0.peek();
            }
            int blocked1 = 0;
            if (this.blocks1.size() > 0) {
                blocked1 = this.blocks1.peek();
            }
            boolean bl = noPendingJumps = this.jumps0.size() == blocked0 && this.jumps1.size() == blocked1;
            if (noPendingJumps) {
                return;
            }
        }
        this.branch_true();
        this.codeLDC(Boolean.TRUE, 0);
        this.branch_false();
        this.codeLDC(Boolean.FALSE, 0);
        this.branch_end();
    }

    private final void mkLabel(IntegerStack jumps) {
        int currpos = this.textData.size();
        jumps.push(currpos);
        this.codeI(0);
    }

    private final void landLabel(IntegerStack jumps) {
        int currpos = this.textData.size();
        int addrpos = jumps.pop();
        this.textData.patchAddress(addrpos, currpos - addrpos + 1);
    }

    private final void landLabels(IntegerStack jumps, IntegerStack blocks) {
        int blocked_at = 0;
        if (blocks.size() > 0) {
            blocked_at = blocks.peek();
        }
        while (jumps.size() > blocked_at) {
            this.landLabel(jumps);
        }
    }

    public void branch_true() {
        this.ensure_jump();
        if (!this.invert_next_jump) {
            this.currJump = ClassFile.invert_jump_bytecode(this.currJump);
        }
        this.invert_next_jump = false;
        this.code(this.currJump);
        this.currJump = 0;
        this.mkLabel(this.jumps0);
        this.landLabels(this.jumps1, this.blocks1);
        this.blocks0.push(this.jumps0.size());
        this.branchStack.push(this.typesStk.size());
    }

    public void branch_false() {
        this.ensure_value();
        this.blocks0.pop_throw();
        int beforeStk = this.branchStack.pop();
        this.branchStack.push(this.typesStk.currWords);
        while (beforeStk < this.typesStk.size()) {
            this.typesStk.pop();
        }
        this.code(167);
        this.mkLabel(this.jumps);
        this.landLabels(this.jumps0, this.blocks0);
    }

    public void branch_end() {
        this.ensure_value();
        Debug.assert(this.branchStack.pop() == this.typesStk.currWords, "Stack mismatch when compiling conditional");
        this.landLabel(this.jumps);
    }

    protected void logical_param(boolean and) {
        IntegerStack b1;
        IntegerStack b0;
        IntegerStack j1;
        IntegerStack j0;
        if (and) {
            j0 = this.jumps0;
            j1 = this.jumps1;
            b0 = this.blocks0;
            b1 = this.blocks1;
        } else {
            j0 = this.jumps1;
            j1 = this.jumps0;
            b0 = this.blocks1;
            b1 = this.blocks0;
        }
        this.ensure_jump();
        if (this.invert_next_jump ^ and) {
            this.currJump = ClassFile.invert_jump_bytecode(this.currJump);
        }
        this.invert_next_jump = false;
        this.code(this.currJump);
        this.currJump = 0;
        this.mkLabel(j0);
        this.landLabels(j1, b1);
        b0.push(j0.size());
    }

    protected void logical_end(boolean and) {
        if (and) {
            this.blocks0.pop_throw();
        } else {
            this.blocks1.pop_throw();
        }
    }

    protected final void code(int op) {
        try {
            while (op != 0) {
                Debug.assert((op & 0xFF) != 255);
                this.text.write(op & 0xFF);
                op >>>= 8;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected final void codeLDC(Object o, int primitiveID) {
        block23: {
            Debug.assert(primitiveID >= 0 && primitiveID <= 8 && (primitiveID != 8 || o == null || o instanceof String));
            int short_opcodes = 0;
            int iv = -1;
            switch (primitiveID) {
                case 0: {
                    iv = (Boolean)o != false ? 1 : 0;
                }
                case 2: {
                    if (iv < 0) {
                        iv = ((Character)o).charValue();
                    }
                }
                case 1: 
                case 3: 
                case 4: {
                    if (iv < 0) {
                        iv = ((Number)o).intValue();
                    }
                    if (iv >= -1 && iv <= 5) {
                        short_opcodes = iv + 3;
                        break;
                    }
                    if (iv < -128 || iv > 127) break;
                    short_opcodes = 0x10 | (iv & 0xFF) << 8;
                    break;
                }
                case 5: {
                    long lv = (Long)o;
                    if (lv < -1L || lv > 5L) break;
                    short_opcodes = load_long_ints[(int)lv + 1];
                    break;
                }
                case 6: {
                    float fv = ((Float)o).floatValue();
                    if (fv == 0.0f) {
                        short_opcodes = 11;
                        break;
                    }
                    if (fv == 1.0f) {
                        short_opcodes = 12;
                        break;
                    }
                    if (fv != 2.0f) break;
                    short_opcodes = 13;
                    break;
                }
                case 7: {
                    double dv = (Double)o;
                    if (dv == 0.0) {
                        short_opcodes = 14;
                        break;
                    }
                    if (dv != 1.0) break;
                    short_opcodes = 15;
                    break;
                }
                case 8: {
                    if (o != null) break;
                    short_opcodes = 1;
                    break;
                }
                default: {
                    Debug.assert(false, "Loading of object constants is not supported by the Java class files.");
                }
            }
            if (short_opcodes == 0) {
                try {
                    boolean dword_const = primitiveID == 5 || primitiveID == 7;
                    int cpindex = this.getIndex(o, primitiveID);
                    Debug.assert(cpindex >= 0 && cpindex <= 65535);
                    if (!dword_const && cpindex <= 255) {
                        this.text.write(18);
                        this.text.write(cpindex);
                        break block23;
                    }
                    int opc = 19;
                    if (dword_const) {
                        ++opc;
                    }
                    this.text.write(opc);
                    this.text.writeShort(cpindex);
                }
                catch (IOException e) {}
            } else {
                this.code(short_opcodes);
            }
        }
        if (primitiveID != 8) {
            this.typesStk.pushID(primitiveID);
        } else {
            this.typesStk.push(o != null ? o.getClass() : null);
        }
    }

    protected final void codeI(int ind) {
        Debug.assert(ind >= 0 && ind <= 65535);
        try {
            this.text.writeShort(ind);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int getUTFIndex(String str) {
        Integer index = (Integer)this.UTFs.get(str);
        if (index == null) {
            index = new Integer(this.poolEntries++);
            try {
                this.constPool.write(1);
                this.constPool.writeUTF(str);
            }
            catch (IOException e) {
                Debug.reportThrowable(e);
            }
            this.UTFs.put(str, index);
        }
        return index;
    }

    private int typeID(Object item) {
        int id = TypesStack.primitiveID(item);
        if (id < 8) {
            return id;
        }
        if (item instanceof String) {
            return 8;
        }
        if (item instanceof Class) {
            return 9;
        }
        if (item instanceof Member) {
            return 10;
        }
        return -1;
    }

    private final int getIndex(Object item) {
        return this.getIndex(item, this.typeID(item));
    }

    protected int getIndex(Object item, int typeid) {
        Integer index = (Integer)this.Items.get(item);
        if (index == null) {
            int newIndex = -1;
            try {
                int ival = -1;
                switch (typeid) {
                    case 0: {
                        ival = (Boolean)item != false ? 1 : 0;
                    }
                    case 2: {
                        if (ival < 0) {
                            ival = ((Character)item).charValue();
                        }
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        if (ival < 0) {
                            ival = ((Number)item).intValue();
                        }
                        newIndex = this.poolEntries++;
                        this.constPool.write(3);
                        this.constPool.writeInt(ival);
                        break;
                    }
                    case 5: {
                        newIndex = this.poolEntries;
                        this.constPool.write(5);
                        this.constPool.writeLong((Long)item);
                        this.poolEntries += 2;
                        break;
                    }
                    case 6: {
                        newIndex = this.poolEntries++;
                        this.constPool.write(4);
                        this.constPool.writeFloat(((Float)item).floatValue());
                        break;
                    }
                    case 7: {
                        newIndex = this.poolEntries;
                        this.constPool.write(6);
                        this.constPool.writeDouble((Double)item);
                        this.poolEntries += 2;
                        break;
                    }
                    case 8: {
                        int UTFIndex = this.getUTFIndex((String)item);
                        newIndex = this.poolEntries++;
                        this.constPool.write(8);
                        this.constPool.writeShort(UTFIndex);
                        break;
                    }
                    case 9: {
                        String histNameStr = ClassFile.toHistoricalForm(((Class)item).getName());
                        int UTFIndex = this.getUTFIndex(histNameStr);
                        newIndex = this.poolEntries++;
                        this.constPool.write(7);
                        this.constPool.writeShort(UTFIndex);
                        break;
                    }
                    case 10: 
                    case 11: 
                    case 12: {
                        Member member = (Member)item;
                        Class<?> dClass = member.getDeclaringClass();
                        int entryType = member.getModifiers() >>> 16 == 1 ? 9 : (dClass != null && dClass.isInterface() ? 11 : 10);
                        newIndex = this.writeMemberRef(member, entryType);
                        break;
                    }
                    default: {
                        Debug.println("Can't place an item of type \"" + item.getClass().getName() + "\" to the constant pool.");
                        break;
                    }
                }
            }
            catch (IOException e) {
                Debug.reportThrowable(e);
            }
            index = new Integer(newIndex);
            this.Items.put(item, index);
        }
        return index;
    }

    private int writeMemberRef(Member member, int entry) throws IOException {
        Debug.assert(entry == 10 || entry == 9 || entry == 11);
        int name_ind = this.getUTFIndex(member.getName());
        int sign_ind = this.getUTFIndex(ClassFile.getSignature(member));
        Class<?> dClass = member.getDeclaringClass();
        int cls_ind = dClass == null ? 2 : this.getIndex(dClass, 9);
        int nat_ind = this.poolEntries++;
        this.constPool.write(12);
        this.constPool.writeShort(name_ind);
        this.constPool.writeShort(sign_ind);
        int index = this.poolEntries++;
        this.constPool.write(entry);
        this.constPool.writeShort(cls_ind);
        this.constPool.writeShort(nat_ind);
        return index;
    }

    public static String getSignature(Member m) {
        StringBuffer signature = new StringBuffer();
        if (m.getModifiers() >>> 16 > 1) {
            Class[] parameters = m.getParameterTypes();
            signature.append('(');
            int i = 0;
            while (i < parameters.length) {
                ClassFile.appendSignature(signature, parameters[i]);
                ++i;
            }
            signature.append(')');
        }
        ClassFile.appendSignature(signature, m.getType());
        return signature.toString();
    }

    public static String getSignature(Class cls) {
        return ClassFile.appendSignature(new StringBuffer(), cls).toString();
    }

    private static StringBuffer appendSignature(StringBuffer buff, Class cls) {
        if (cls.isPrimitive()) {
            buff.append(TypesStack.primitiveCodes[TypesStack.primitiveID(cls)]);
        } else if (cls.isArray()) {
            buff.append('[');
            ClassFile.appendSignature(buff, cls.getComponentType());
        } else {
            buff.append('L');
            ClassFile.appendHistoricalForm(buff, cls.getName());
            buff.append(';');
        }
        return buff;
    }

    private static String toHistoricalForm(String className) {
        return ClassFile.appendHistoricalForm(new StringBuffer(), className).toString();
    }

    private static StringBuffer appendHistoricalForm(StringBuffer buff, String className) {
        int namelen = className.length();
        int i = 0;
        while (i < className.length()) {
            char cch = className.charAt(i);
            if (cch == '.') {
                cch = '/';
            }
            buff.append(cch);
            ++i;
        }
        return buff;
    }

    public static void main(String[] args) {
        Tester t = new Tester(System.out);
        ClassFile.test(t);
        t.summarize();
    }

    static void dumpImage(ClassFile cf) {
        try {
            FileOutputStream fos = new FileOutputStream("dump.class");
            fos.write(cf.getImage());
            fos.close();
        }
        catch (Exception e) {
            Debug.println("Can't dump generated class file.");
        }
    }

    public static void test(Tester t) {
        int i;
        t.startTest("toHistoricalForm(\"java.lang.String\")");
        t.compare(ClassFile.toHistoricalForm("java.lang.String"), "java/lang/String");
        t.startTest("getSignature((\"a string\").getClass())");
        t.compare(ClassFile.getSignature("a string".getClass()), "Ljava/lang/String;");
        t.startTest("getSignature((new int[10]).getClass())");
        t.compare(ClassFile.getSignature(new int[10].getClass()), "[I");
        t.startTest("getSignature((new Object[10]).getClass())");
        t.compare(ClassFile.getSignature(new Object[10].getClass()), "[Ljava/lang/Object;");
        LocalField[] lf = new LocalField[]{new LocalField(2, new Object[0].getClass(), "e", null)};
        ClassFile cf = new ClassFile(1, "dump", new Object().getClass(), null, lf);
        t.startTest("Add UTF twice");
        String s1 = "some string";
        int si = cf.getUTFIndex(s1);
        int sii = cf.getUTFIndex(s1);
        t.compare(sii, si);
        t.startTest("Add Long twice");
        int li = cf.getIndex(new Long(15L), 5);
        int lii = cf.getIndex(new Long(15L), 5);
        t.compare(lii, li);
        t.startTest("Add Integer twice");
        int ii = cf.getIndex(new Integer(15), 4);
        int iii = cf.getIndex(new Integer(15), 4);
        t.compare(iii, ii);
        t.startTest("Add Float twice");
        int ff = cf.getIndex(new Float(15.0f), 6);
        int fff = cf.getIndex(new Float(15.0f), 6);
        t.compare(fff, ff);
        t.startTest("Add Double twice");
        int di = cf.getIndex(new Double(15.0), 7);
        int dii = cf.getIndex(new Double(15.0), 7);
        t.compare(dii, di);
        t.startTest("Add a new String twice");
        String s2 = "some other string";
        int s2i = cf.getIndex(s2, 8);
        int s2ii = cf.getIndex(s2, 8);
        t.compare(s2ii, s2i);
        t.startTest("Add a string with existing UTF twice");
        int s3i = cf.getIndex(s1, 8);
        int s3ii = cf.getIndex(s1, 8);
        t.compare(s3ii, s3i);
        t.startTest("Add a class twice");
        int ci = cf.getIndex(cf.getClass(), 9);
        int cii = cf.getIndex(cf.getClass(), 9);
        t.compare(cii, ci);
        t.startTest("Add a method twice");
        Class[] params = new Class[1];
        try {
            params[0] = Class.forName("gnu.jel.debug.Tester");
            Method a_method = new Method(cf.getClass().getMethod("test", params));
            int mi = cf.getIndex(a_method, 10);
            int mii = cf.getIndex(a_method, 10);
            t.compare(mii, mi);
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        Library lib = null;
        Object[] dynalib = null;
        t.startTest("Construct a library of java.lang.Math functions");
        try {
            Class[] stat = new Class[]{Class.forName("java.lang.Math")};
            Class[] dyn = new Class[]{Class.forName("java.lang.Double")};
            lib = new Library(stat, dyn);
            dynalib = new Object[]{new Double(100.0)};
            t.testOK();
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        byte[] image = null;
        LocalMethod[] eval_methods = new LocalMethod[TypesStack.primitiveTypes.length];
        ClassFile cf_orig = null;
        int retID_patchback = 0;
        t.startTest("Construct a compiled expression subclass");
        try {
            Class[] paramsE = new Class[]{new Object[0].getClass()};
            i = 0;
            while (i < TypesStack.primitiveTypes.length - 1) {
                String name = "evaluate";
                Class<?> cls = TypesStack.primitiveTypes[i];
                if (i != 8) {
                    name = name + '_' + TypesStack.primitiveTypeNames[i];
                } else {
                    cls = new Object().getClass();
                }
                eval_methods[i] = new LocalMethod(1, cls, name, paramsE, null);
                ++i;
            }
            Class<?> cmplExpr = Class.forName("gnu.jel.CompiledExpression");
            cf = new ClassFile(1, "dump", cmplExpr, null, lf);
            LocalMethod cnstr = new LocalMethod(1, Void.TYPE, "<init>", null, null);
            cf.newMethod(cnstr, null);
            cf.code(42);
            cf.typesStk.push(null);
            Method supInit = new Method(cmplExpr.getConstructor(new Class[0]));
            cf.code(183);
            cf.codeI(cf.getIndex(supInit));
            cf.typesStk.pop();
            cf.code(177);
            LocalMethod getType = new LocalMethod(1, Integer.TYPE, "getType", null, null);
            cf.newMethod(getType, null);
            cf.code(16);
            retID_patchback = cf.textData.size();
            cf.code(8);
            cf.typesStk.push(Integer.TYPE);
            cf.code(172);
            cf.typesStk.pop();
            cf_orig = (ClassFile)cf.clone();
            cf.newMethod(eval_methods[8], null);
            cf.code(1);
            cf.typesStk.push(null);
            cf.code(176);
            cf.typesStk.pop();
            image = cf.getImage();
            t.testOK();
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        t.startTest("Load and execute constructed class");
        try {
            boolean ok;
            ClassFile.dumpImage(cf);
            CompiledExpression expr = (CompiledExpression)ImageLoader.load(image).newInstance();
            boolean bl = ok = expr.getType() == 8 && expr.evaluate(null) == null;
            if (ok) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        ClassFile.exprTest("1 (I)", dynalib, lib, new Integer(1), cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("1 -- (I)", dynalib, lib, new Integer(-1), cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("1 --", dynalib, lib, new Integer(-1), cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("1L --", dynalib, lib, new Long(-1L), cf_orig, retID_patchback, eval_methods, t, false);
        byte i2 = 0;
        while (i2 <= 6) {
            ClassFile.exprTest(String.valueOf(i2), dynalib, lib, new Byte(i2), cf_orig, retID_patchback, eval_methods, t, false);
            ClassFile.exprTest(String.valueOf(i2) + 'L', dynalib, lib, new Long(i2), cf_orig, retID_patchback, eval_methods, t, false);
            i2 = (byte)(i2 + 1);
        }
        i = 0;
        while (i <= 3) {
            ClassFile.exprTest(String.valueOf(i) + ".0F", dynalib, lib, new Float(i), cf_orig, retID_patchback, eval_methods, t, false);
            ClassFile.exprTest(String.valueOf(i) + ".0", dynalib, lib, new Double(i), cf_orig, retID_patchback, eval_methods, t, false);
            i = (byte)(i + 1);
        }
        ClassFile.exprTest("true", dynalib, lib, Boolean.TRUE, cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("false", dynalib, lib, Boolean.FALSE, cf_orig, retID_patchback, eval_methods, t, false);
        int i3 = 126;
        while (i3 <= 128) {
            ClassFile.exprTest(String.valueOf(i3) + " (I)", dynalib, lib, new Integer(i3), cf_orig, retID_patchback, eval_methods, t, false);
            ClassFile.exprTest(String.valueOf(i3) + " -- (I)", dynalib, lib, new Integer(-i3), cf_orig, retID_patchback, eval_methods, t, false);
            ++i3;
        }
        ClassFile.exprTest("( 1 , 2 , min)", dynalib, lib, new Integer(1), cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("( ( E) , sin)", dynalib, lib, new Double(Math.sin(Math.E)), cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("2 , 2 , *", dynalib, lib, new Integer(4), cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("3 , 2 , * , 1 , -", dynalib, lib, new Integer(5), cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("3 , 2 , * , 1 , - , 3 , - , 2 , *", dynalib, lib, new Integer(4), cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("3 , 2 , * , 1 , - , 3 , - , 2 , * , 4 , ==", dynalib, lib, Boolean.TRUE, cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("\"a\" , \"b\" , + , 4 , + , true , +", dynalib, lib, "ab4true", cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("2 , 3 , > , 3 , 2 , >= , ||", dynalib, lib, Boolean.TRUE, cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("( isNaN)", dynalib, lib, Boolean.FALSE, cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("1 , ( doubleValue) , + , 101 , ==", dynalib, lib, Boolean.TRUE, cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("( true ? 1 : 2 ) (I)", dynalib, lib, new Integer(1), cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("( false ? 1 : 2 ) (I)", dynalib, lib, new Integer(2), cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("( false ? 1 : 2 , 2 , + ) (I)", dynalib, lib, new Integer(4), cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("( true ? ( 1 , 3 , + , 5 , min) : 2 ) (I)", dynalib, lib, new Integer(4), cf_orig, retID_patchback, eval_methods, t, true);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static void exprTest(String expr, Object[] thisPtrs, Library lib, Object expRes, ClassFile cf_orig, int retID_patchback, LocalMethod[] eval_methods, Tester t, boolean verbose) {
        try {
            testTitle = new StringBuffer();
            i = 0;
            while (i < expr.length()) {
                if (expr.charAt(i) != ' ') {
                    testTitle.append(expr.charAt(i));
                }
                ++i;
            }
            testTitle.append(" == ");
            id = TypesStack.primitiveID(expRes);
            if (id < 8) {
                testTitle.append(expRes);
                testTitle.append(TypesStack.primitiveCodes[id]);
            } else if (expRes instanceof String) {
                testTitle.append('\"');
                testTitle.append(expRes);
                testTitle.append('\"');
            } else {
                testTitle.append(expRes);
            }
            t.startTest(testTitle.toString());
            typesStk = new TypesStack();
            paramOPs = new Stack<OP>();
            list = new OPlist();
            paramsStart = new IntegerStack();
            oldLists = new Stack<OPlist>();
            branchStack = new IntegerStack();
            try {
                sr = new StringReader(expr);
                cToken = new StringBuffer();
                block57: while ((cChar = sr.read()) > 0) {
                    while ((char)var19_23 == ' ' && (cChar = sr.read()) > 0) {
                    }
                    cToken.setLength(0);
                    while (cChar > 0 && (char)cChar != ' ') {
                        cToken.append((char)cChar);
                        cChar = sr.read();
                    }
                    if (cToken.length() <= 0) continue;
                    cTok = cToken.charAt(0);
                    switch (cTok) {
                        case '~': {
                            list.addLast(new OPunary(typesStk, 1));
                            break;
                        }
                        case ',': {
                            paramOPs.push(list.getLast());
                            break;
                        }
                        case '(': {
                            if (cToken.length() == 1) {
                                if (list.size() > 0) {
                                    paramOPs.push(list.getLast());
                                } else {
                                    paramOPs.push(null);
                                }
                                paramsStart.push(typesStk.size());
                                break;
                            }
                            if (cToken.length() == 3) {
                                ttype = cToken.charAt(1);
                                tid = 0;
                                while (tid < TypesStack.primitiveCodes.length && ttype != TypesStack.primitiveCodes[tid]) {
                                    ++tid;
                                }
                                list.addLast(new OPunary(typesStk, tid, null, true));
                                break;
                            }
                            Debug.println("Wrong bracketed token \"" + cToken + "\".");
                            break;
                        }
                        case '?': {
                            paramOPs.pop();
                            branchStack.push(typesStk.size());
                            oldLists.push(list);
                            list = new OPlist();
                            break;
                        }
                        case ':': {
                            branchStack.push(typesStk.size());
                            oldLists.push(list);
                            list = new OPlist();
                            break;
                        }
                        case ')': {
                            if (branchStack.peek() + 1 != typesStk.size() || branchStack.pop() != branchStack.pop() + 1) {
                                Debug.println("Stack mismatch when compiling conditional.");
                            }
                            opcond = new OPcondtnl(typesStk, (OPlist)oldLists.pop(), list);
                            list = (OPlist)oldLists.pop();
                            list.addLast(opcond);
                            break;
                        }
                        case '+': {
                            list.addLast(new OPbinary(typesStk, paramOPs, 0, list));
                            break;
                        }
                        case '-': {
                            if (cToken.length() == 1) {
                                list.addLast(new OPbinary(typesStk, paramOPs, 1, list));
                                break;
                            }
                            if (cToken.length() == 2 && cToken.charAt(1) == '-') {
                                list.addLast(new OPunary(typesStk, 0));
                                break;
                            }
                            Debug.println("Wrong token \"" + cTok + "\".");
                            break;
                        }
                        case '*': {
                            list.addLast(new OPbinary(typesStk, paramOPs, 2, list));
                            break;
                        }
                        case '/': {
                            list.addLast(new OPbinary(typesStk, paramOPs, 3, list));
                            break;
                        }
                        case '%': {
                            list.addLast(new OPbinary(typesStk, paramOPs, 4, list));
                            break;
                        }
                        case '^': {
                            list.addLast(new OPbinary(typesStk, paramOPs, 7, list));
                            break;
                        }
                        case '=': {
                            if (cToken.charAt(1) != '=') continue block57;
                            list.addLast(new OPbinary(typesStk, paramOPs, 8, list));
                            break;
                        }
                        case '!': {
                            if (cToken.length() == 1) {
                                list.addLast(new OPunary(typesStk, 2));
                                break;
                            }
                            if (cToken.length() == 2 && cToken.charAt(1) == '=') {
                                list.addLast(new OPbinary(typesStk, paramOPs, 9, list));
                                break;
                            }
                            Debug.println("Wrong ! token \"" + cTok + "\".");
                            break;
                        }
                        case '<': {
                            if (cToken.length() == 1) {
                                list.addLast(new OPbinary(typesStk, paramOPs, 10, list));
                                break;
                            }
                            if (cToken.length() == 2 && cToken.charAt(1) == '=') {
                                list.addLast(new OPbinary(typesStk, paramOPs, 13, list));
                                break;
                            }
                            if (cToken.length() == 2 && cToken.charAt(1) == '<') {
                                list.addLast(new OPbinary(typesStk, paramOPs, 14, list));
                                break;
                            }
                            Debug.println("Wrong < token \"" + cTok + "\".");
                            break;
                        }
                        case '>': {
                            if (cToken.length() == 1) {
                                list.addLast(new OPbinary(typesStk, paramOPs, 11, list));
                                break;
                            }
                            if (cToken.length() == 2 && cToken.charAt(1) == '=') {
                                list.addLast(new OPbinary(typesStk, paramOPs, 12, list));
                                break;
                            }
                            if (cToken.length() == 2 && cToken.charAt(1) == '>') {
                                list.addLast(new OPbinary(typesStk, paramOPs, 15, list));
                                break;
                            }
                            if (cToken.length() == 3 && cToken.charAt(2) == '>') {
                                list.addLast(new OPbinary(typesStk, paramOPs, 16, list));
                                break;
                            }
                            Debug.println("Wrong > token \"" + cTok + "\".");
                            break;
                        }
                        case '&': {
                            if (cToken.length() == 1) {
                                list.addLast(new OPbinary(typesStk, paramOPs, 5, list));
                                break;
                            }
                            if (cToken.length() == 3 && cToken.charAt(1) == '&') {
                                list.addLast(new OPbinary(typesStk, paramOPs, 17, list));
                                break;
                            }
                            Debug.println("Wrong & token \"" + cTok + "\".");
                            break;
                        }
                        case '|': {
                            if (cToken.length() == 1) {
                                list.addLast(new OPbinary(typesStk, paramOPs, 6, list));
                                break;
                            }
                            if (cToken.length() == 2 && cToken.charAt(1) == '|') {
                                list.addLast(new OPbinary(typesStk, paramOPs, 18, list));
                                break;
                            }
                            Debug.println("Wrong | token \"" + cTok + "\".");
                            break;
                        }
                        case '[': {
                            if (cToken.length() == 3 && cToken.charAt(1) == ']') {
                                list.addLast(new OPbinary(typesStk, paramOPs, 19, list));
                                break;
                            }
                            Debug.println("Wrong [ token \"" + cTok + "\".");
                            break;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            sval = cToken.toString();
                            if (sval.indexOf(46) > 0) {
                                lc = Character.toUpperCase(sval.charAt(sval.length() - 1));
                                makeFloat = lc == 'F';
                                svalue = sval;
                                if (lc == 'D' || lc == 'F') {
                                    svalue = svalue.substring(0, svalue.length() - 1);
                                }
                                value = null;
                                try {
                                    value = new Double(svalue);
                                }
                                catch (NumberFormatException e) {
                                    Debug.println("Can;t parse \"" + svalue + "\" as a floating point number.");
                                }
                                otl /* !! */  = null;
                                otlc /* !! */  = null;
                                if (makeFloat) {
                                    otl /* !! */  = new Float(value.floatValue());
                                    otlc /* !! */  = Float.TYPE;
                                } else {
                                    otl /* !! */  = value;
                                    otlc /* !! */  = Double.TYPE;
                                }
                                list.addLast(new OPload(typesStk, otlc /* !! */ , otl /* !! */ ));
                                break;
                            }
                            svalue = sval.toUpperCase();
                            value = 0L;
                            makelong = svalue.endsWith("L");
                            if (makelong) {
                                svalue = svalue.substring(0, svalue.length() - 1);
                            }
                            try {
                                if (svalue.startsWith("0X")) {
                                    svalue = svalue.substring(2);
                                    value = Long.parseLong(svalue, 16);
                                } else {
                                    value = svalue.startsWith("0") ? Long.parseLong(svalue, 8) : Long.parseLong(svalue, 10);
                                }
                            }
                            catch (NumberFormatException e) {
                                Debug.println("Number \"" + svalue + "\" is too large, it does not fit even " + "into 64 bit long.");
                            }
                            otl /* !! */  = null;
                            otlc /* !! */  = null;
                            if (!makelong) {
                                if (value <= 127L) {
                                    otl /* !! */  = new Byte((byte)value);
                                    otlc /* !! */  = Byte.TYPE;
                                } else if (value <= 32767L) {
                                    otl /* !! */  = new Short((short)value);
                                    otlc /* !! */  = Short.TYPE;
                                } else if (value <= 0x7FFFFFFFL) {
                                    otl /* !! */  = new Integer((int)value);
                                    otlc /* !! */  = Integer.TYPE;
                                } else {
                                    Debug.println("Integer number \"" + svalue + "\" is too large for type 'int'. Be sure" + " to add 'L' suffix to use 'long' type.");
                                }
                            } else {
                                otl /* !! */  = new Long(value);
                                otlc /* !! */  = Long.TYPE;
                            }
                            list.addLast(new OPload(typesStk, otlc /* !! */ , otl /* !! */ ));
                            break;
                        }
                        case '\'': {
                            sval = cToken.toString().substring(1, cToken.length() - 1);
                            chr = sval.charAt(0);
                            if (sval.length() != 1) {
                                ec = sval.charAt(1);
                                try {
                                    switch (ec) {
                                        case 110: {
                                            ec = 10;
                                            break;
                                        }
                                        case 116: {
                                            ec = 9;
                                            break;
                                        }
                                        case 98: {
                                            ec = 8;
                                            break;
                                        }
                                        case 114: {
                                            ec = 13;
                                            break;
                                        }
                                        case 102: {
                                            ec = 12;
                                            break;
                                        }
                                        case 92: {
                                            ec = 92;
                                            break;
                                        }
                                        case 39: {
                                            ec = 39;
                                            break;
                                        }
                                        case 34: {
                                            ec = 34;
                                            break;
                                        }
                                        default: {
                                            ec = (char)Integer.parseInt(sval.substring(1), 8);
                                            break;
                                        }
                                    }
                                }
                                catch (NumberFormatException e) {
                                    Debug.println("Can;t parse \"" + cToken + "\" as a character literal.");
                                }
                                chr = ec;
                            }
                            list.addLast(new OPload(typesStk, Character.TYPE, new Character((char)chr)));
                            break;
                        }
                        case '\"': {
                            sval = cToken.toString().substring(1, cToken.length() - 1);
                            unescaped = new StringBuffer(sval.length());
                            i = 0;
                            while (i < sval.length()) {
                                ec = sval.charAt(i);
                                if (ec != 92) ** GOTO lbl331
                                ec = sval.charAt(++i);
                                switch (ec) {
                                    case 110: {
                                        ec = 10;
                                        break;
                                    }
                                    case 116: {
                                        ec = 9;
                                        break;
                                    }
                                    case 98: {
                                        ec = 8;
                                        break;
                                    }
                                    case 114: {
                                        ec = 13;
                                        break;
                                    }
                                    case 102: {
                                        ec = 12;
                                        break;
                                    }
                                    case 92: {
                                        ec = 92;
                                        break;
                                    }
                                    case 39: {
                                        ec = 39;
                                        break;
                                    }
                                    case 34: {
                                        ec = 34;
                                        break;
                                    }
                                    default: {
                                        nval = 0;
                                        if (true) ** GOTO lbl325
                                        do {
                                            nval <<= 3 + (ec - 48);
                                            ++i;
lbl325:
                                            // 2 sources

                                            if (i >= sval.length()) break;
                                            v0 = sval.charAt(i);
                                            ec = v0;
                                        } while (v0 >= '0' && ec <= 55);
                                        --i;
                                        ec = (char)nval;
                                    }
                                }
lbl331:
                                // 10 sources

                                unescaped.append((char)ec);
                                ++i;
                            }
                            list.addLast(new OPload(typesStk, unescaped.toString().getClass(), unescaped.toString()));
                            break;
                        }
                        default: {
                            if (cToken.toString().equals("true")) {
                                list.addLast(new OPload(typesStk, Boolean.TYPE, Boolean.TRUE));
                                break;
                            }
                            if (cToken.toString().equals("false")) {
                                list.addLast(new OPload(typesStk, Boolean.TYPE, Boolean.FALSE));
                                break;
                            }
                            cToken.setLength(cToken.length() - 1);
                            ps = paramsStart.pop();
                            np = typesStk.size() - ps;
                            params = new Class[np];
                            paramsOPs = new OP[np];
                            i = np - 1;
                            while (i >= 0) {
                                params[i] = typesStk.pop();
                                paramsOPs[i] = (OP)paramOPs.pop();
                                --i;
                            }
                            m = null;
                            try {
                                m = lib.getMember(cToken.toString(), params);
                            }
                            catch (NoSuchMethodException exc) {
                                Debug.println("Can't find method \"" + cToken + "\".");
                            }
                            thisOP = (OP)paramOPs.pop();
                            if ((m.getModifiers() & 8) == 0) {
                                op /* !! */  = new OPcall(typesStk, 1, new Object[0].getClass());
                                if (thisOP == null) {
                                    list.addFirst(op /* !! */ );
                                } else {
                                    list.addAfter(thisOP, op /* !! */ );
                                }
                                thisOP = op /* !! */ ;
                                paramOPs.push(op /* !! */ );
                                classID = lib.getDynamicMethodClassID(m);
                                op /* !! */  = new OPload(typesStk, Integer.TYPE, new Integer(classID));
                                list.addAfter(thisOP, op /* !! */ );
                                thisOP = op /* !! */ ;
                                paramOPs.push(op /* !! */ );
                                op /* !! */  = new OPbinary(typesStk, paramOPs, 19, list);
                                list.addAfter(thisOP, op /* !! */ );
                                thisOP = op /* !! */ ;
                                paramOPs.push(thisOP);
                            }
                            i = 0;
                            while (i < np) {
                                typesStk.push(params[i]);
                                paramOPs.push(paramsOPs[i]);
                                ++i;
                            }
                            list.addLast(new OPcall(typesStk, paramOPs, m, list, false));
                        }
                    }
                }
            }
            catch (IOException exc) {
                // empty catch block
            }
            if (typesStk.peek() == TypesStack.tsb_class) {
                list.addLast(new OPunary(typesStk, 8, OPunary.string_class, false));
            }
            retID = typesStk.peekID();
            retType = typesStk.peek();
            list.addLast(new OPunary(typesStk, 3));
            if (typesStk.size() != 0) {
                Debug.println("Words left in stack when compiling.");
            }
            name = "evaluate";
            if (retID != 8) {
                name = name + '_' + TypesStack.primitiveTypeNames[retID];
            }
            ok = true;
            i = 0;
            while (i < 2) {
                if (verbose) {
                    t.print(list);
                }
                cf = (ClassFile)cf_orig.clone();
                cf.textData.patchAddress(retID_patchback, (byte)retID);
                cf.newMethod(eval_methods[retID], null);
                list.compile(cf);
                image = cf.getImage();
                ClassFile.dumpImage(cf);
                cexpr = (CompiledExpression)ImageLoader.load(image).newInstance();
                res = cexpr.evaluate(thisPtrs);
                v1 = localOK = expRes == null && expRes == res || expRes.equals(res) != false;
                if (verbose) {
                    t.print(" == ");
                    t.print(res);
                    t.print("  ");
                    if (localOK) {
                        t.print("ok.");
                    } else {
                        t.print("WRONG !!!");
                    }
                    t.println("");
                }
                ok = ok != false && localOK != false;
                list.performCF();
                ++i;
            }
            if (ok) {
                t.testOK();
            } else {
                t.testFail();
            }
            if (!(ok | verbose)) {
                ClassFile.exprTest(expr, thisPtrs, lib, expRes, cf_orig, retID_patchback, eval_methods, t, true);
            }
        }
        catch (Throwable thr) {
            Debug.reportThrowable(thr);
            t.testFail();
        }
    }
}

