/*
 This file is part of GNU Taler
 (C) 2021 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

// From https://en.wikipedia.org/wiki/ISO_4217

//modifications to the original data
// * currency without decimal represented with 0
// * removed 4 with label "No universal currency"
// * numeric as number
// * removed all field except:
//  - c: currency name
//  - a: alphabetic code
//  - n: numeric code
//  - d: minor unit
type CurrencyInfo = {
  /**
   * name
   */
  c: string;
  /**
   * alphabetic code
   */
  a: string;
  /**
   * numeric code
   */
  n: number;
  /**
   * minor unit
   * "0" means that there is no minor unit for that currency, whereas "1", "2"
   * and "3" signify a ratio of 10:1, 100:1 and 1000:1 respectively.
   */
  d: number;
};
export const data: Array<CurrencyInfo> = [
  {
    c: "Afghani",
    a: "AFN",
    n: 971,
    d: 2,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "Lek",
    a: "ALL",
    n: 8,
    d: 2,
  },
  {
    c: "Algerian Dinar",
    a: "DZD",
    n: 12,
    d: 2,
  },
  {
    c: "US Dollar",
    a: "USD",
    n: 840,
    d: 2,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "Kwanza",
    a: "AOA",
    n: 973,
    d: 2,
  },
  {
    c: "East Caribbean Dollar",
    a: "XCD",
    n: 951,
    d: 2,
  },
  {
    c: "East Caribbean Dollar",
    a: "XCD",
    n: 951,
    d: 2,
  },
  {
    c: "Argentine Peso",
    a: "ARS",
    n: 32,
    d: 2,
  },
  {
    c: "Armenian Dram",
    a: "AMD",
    n: 51,
    d: 2,
  },
  {
    c: "Aruban Florin",
    a: "AWG",
    n: 533,
    d: 2,
  },
  {
    c: "Australian Dollar",
    a: "AUD",
    n: 36,
    d: 2,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "Azerbaijan Manat",
    a: "AZN",
    n: 944,
    d: 2,
  },
  {
    c: "Bahamian Dollar",
    a: "BSD",
    n: 44,
    d: 2,
  },
  {
    c: "Bahraini Dinar",
    a: "BHD",
    n: 48,
    d: 3,
  },
  {
    c: "Taka",
    a: "BDT",
    n: 50,
    d: 2,
  },
  {
    c: "Barbados Dollar",
    a: "BBD",
    n: 52,
    d: 2,
  },
  {
    c: "Belarusian Ruble",
    a: "BYN",
    n: 933,
    d: 2,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "Belize Dollar",
    a: "BZD",
    n: 84,
    d: 2,
  },
  {
    c: "CFA Franc BCEAO",
    a: "XOF",
    n: 952,
    d: 0,
  },
  {
    c: "Bermudian Dollar",
    a: "BMD",
    n: 60,
    d: 2,
  },
  {
    c: "Indian Rupee",
    a: "INR",
    n: 356,
    d: 2,
  },
  {
    c: "Ngultrum",
    a: "BTN",
    n: 64,
    d: 2,
  },
  {
    c: "Boliviano",
    a: "BOB",
    n: 68,
    d: 2,
  },
  {
    c: "Mvdol",
    a: "BOV",
    n: 984,
    d: 2,
  },
  {
    c: "US Dollar",
    a: "USD",
    n: 840,
    d: 2,
  },
  {
    c: "Convertible Mark",
    a: "BAM",
    n: 977,
    d: 2,
  },
  {
    c: "Pula",
    a: "BWP",
    n: 72,
    d: 2,
  },
  {
    c: "Norwegian Krone",
    a: "NOK",
    n: 578,
    d: 2,
  },
  {
    c: "Brazilian Real",
    a: "BRL",
    n: 986,
    d: 2,
  },
  {
    c: "US Dollar",
    a: "USD",
    n: 840,
    d: 2,
  },
  {
    c: "Brunei Dollar",
    a: "BND",
    n: 96,
    d: 2,
  },
  {
    c: "Bulgarian Lev",
    a: "BGN",
    n: 975,
    d: 2,
  },
  {
    c: "CFA Franc BCEAO",
    a: "XOF",
    n: 952,
    d: 0,
  },
  {
    c: "Burundi Franc",
    a: "BIF",
    n: 108,
    d: 0,
  },
  {
    c: "Cabo Verde Escudo",
    a: "CVE",
    n: 132,
    d: 2,
  },
  {
    c: "Riel",
    a: "KHR",
    n: 116,
    d: 2,
  },
  {
    c: "CFA Franc BEAC",
    a: "XAF",
    n: 950,
    d: 0,
  },
  {
    c: "Canadian Dollar",
    a: "CAD",
    n: 124,
    d: 2,
  },
  {
    c: "Cayman Islands Dollar",
    a: "KYD",
    n: 136,
    d: 2,
  },
  {
    c: "CFA Franc BEAC",
    a: "XAF",
    n: 950,
    d: 0,
  },
  {
    c: "CFA Franc BEAC",
    a: "XAF",
    n: 950,
    d: 0,
  },
  {
    c: "Chilean Peso",
    a: "CLP",
    n: 152,
    d: 0,
  },
  {
    c: "Unidad de Fomento",
    a: "CLF",
    n: 990,
    d: 4,
  },
  {
    c: "Yuan Renminbi",
    a: "CNY",
    n: 156,
    d: 2,
  },
  {
    c: "Australian Dollar",
    a: "AUD",
    n: 36,
    d: 2,
  },
  {
    c: "Australian Dollar",
    a: "AUD",
    n: 36,
    d: 2,
  },
  {
    c: "Colombian Peso",
    a: "COP",
    n: 170,
    d: 2,
  },
  {
    c: "Unidad de Valor Real",
    a: "COU",
    n: 970,
    d: 2,
  },
  {
    c: "Comorian Franc",
    a: "KMF",
    n: 174,
    d: 0,
  },
  {
    c: "Congolese Franc",
    a: "CDF",
    n: 976,
    d: 2,
  },
  {
    c: "CFA Franc BEAC",
    a: "XAF",
    n: 950,
    d: 0,
  },
  {
    c: "New Zealand Dollar",
    a: "NZD",
    n: 554,
    d: 2,
  },
  {
    c: "Costa Rican Colon",
    a: "CRC",
    n: 188,
    d: 2,
  },
  {
    c: "CFA Franc BCEAO",
    a: "XOF",
    n: 952,
    d: 0,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "Cuban Peso",
    a: "CUP",
    n: 192,
    d: 2,
  },
  {
    c: "Peso Convertible",
    a: "CUC",
    n: 931,
    d: 2,
  },
  {
    c: "Netherlands Antillean Guilder",
    a: "ANG",
    n: 532,
    d: 2,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "Czech Koruna",
    a: "CZK",
    n: 203,
    d: 2,
  },
  {
    c: "Danish Krone",
    a: "DKK",
    n: 208,
    d: 2,
  },
  {
    c: "Djibouti Franc",
    a: "DJF",
    n: 262,
    d: 0,
  },
  {
    c: "East Caribbean Dollar",
    a: "XCD",
    n: 951,
    d: 2,
  },
  {
    c: "Dominican Peso",
    a: "DOP",
    n: 214,
    d: 2,
  },
  {
    c: "US Dollar",
    a: "USD",
    n: 840,
    d: 2,
  },
  {
    c: "Egyptian Pound",
    a: "EGP",
    n: 818,
    d: 2,
  },
  {
    c: "El Salvador Colon",
    a: "SVC",
    n: 222,
    d: 2,
  },
  {
    c: "US Dollar",
    a: "USD",
    n: 840,
    d: 2,
  },
  {
    c: "CFA Franc BEAC",
    a: "XAF",
    n: 950,
    d: 0,
  },
  {
    c: "Nakfa",
    a: "ERN",
    n: 232,
    d: 2,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "Lilangeni",
    a: "SZL",
    n: 748,
    d: 2,
  },
  {
    c: "Ethiopian Birr",
    a: "ETB",
    n: 230,
    d: 2,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "Falkland Islands Pound",
    a: "FKP",
    n: 238,
    d: 2,
  },
  {
    c: "Danish Krone",
    a: "DKK",
    n: 208,
    d: 2,
  },
  {
    c: "Fiji Dollar",
    a: "FJD",
    n: 242,
    d: 2,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "CFP Franc",
    a: "XPF",
    n: 953,
    d: 0,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "CFA Franc BEAC",
    a: "XAF",
    n: 950,
    d: 0,
  },
  {
    c: "Dalasi",
    a: "GMD",
    n: 270,
    d: 2,
  },
  {
    c: "Lari",
    a: "GEL",
    n: 981,
    d: 2,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "Ghana Cedi",
    a: "GHS",
    n: 936,
    d: 2,
  },
  {
    c: "Gibraltar Pound",
    a: "GIP",
    n: 292,
    d: 2,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "Danish Krone",
    a: "DKK",
    n: 208,
    d: 2,
  },
  {
    c: "East Caribbean Dollar",
    a: "XCD",
    n: 951,
    d: 2,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "US Dollar",
    a: "USD",
    n: 840,
    d: 2,
  },
  {
    c: "Quetzal",
    a: "GTQ",
    n: 320,
    d: 2,
  },
  {
    c: "Pound Sterling",
    a: "GBP",
    n: 826,
    d: 2,
  },
  {
    c: "Guinean Franc",
    a: "GNF",
    n: 324,
    d: 0,
  },
  {
    c: "CFA Franc BCEAO",
    a: "XOF",
    n: 952,
    d: 0,
  },
  {
    c: "Guyana Dollar",
    a: "GYD",
    n: 328,
    d: 2,
  },
  {
    c: "Gourde",
    a: "HTG",
    n: 332,
    d: 2,
  },
  {
    c: "US Dollar",
    a: "USD",
    n: 840,
    d: 2,
  },
  {
    c: "Australian Dollar",
    a: "AUD",
    n: 36,
    d: 2,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "Lempira",
    a: "HNL",
    n: 340,
    d: 2,
  },
  {
    c: "Hong Kong Dollar",
    a: "HKD",
    n: 344,
    d: 2,
  },
  {
    c: "Forint",
    a: "HUF",
    n: 348,
    d: 2,
  },
  {
    c: "Iceland Krona",
    a: "ISK",
    n: 352,
    d: 0,
  },
  {
    c: "Indian Rupee",
    a: "INR",
    n: 356,
    d: 2,
  },
  {
    c: "Rupiah",
    a: "IDR",
    n: 360,
    d: 2,
  },
  {
    c: "SDR (Special Drawing Right)",
    a: "XDR",
    n: 960,
    d: 0,
  },
  {
    c: "Iranian Rial",
    a: "IRR",
    n: 364,
    d: 2,
  },
  {
    c: "Iraqi Dinar",
    a: "IQD",
    n: 368,
    d: 3,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "Pound Sterling",
    a: "GBP",
    n: 826,
    d: 2,
  },
  {
    c: "New Israeli Sheqel",
    a: "ILS",
    n: 376,
    d: 2,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "Jamaican Dollar",
    a: "JMD",
    n: 388,
    d: 2,
  },
  {
    c: "Yen",
    a: "JPY",
    n: 392,
    d: 0,
  },
  {
    c: "Pound Sterling",
    a: "GBP",
    n: 826,
    d: 2,
  },
  {
    c: "Jordanian Dinar",
    a: "JOD",
    n: 400,
    d: 3,
  },
  {
    c: "Tenge",
    a: "KZT",
    n: 398,
    d: 2,
  },
  {
    c: "Kenyan Shilling",
    a: "KES",
    n: 404,
    d: 2,
  },
  {
    c: "Australian Dollar",
    a: "AUD",
    n: 36,
    d: 2,
  },
  {
    c: "North Korean Won",
    a: "KPW",
    n: 408,
    d: 2,
  },
  {
    c: "Won",
    a: "KRW",
    n: 410,
    d: 0,
  },
  {
    c: "Kuwaiti Dinar",
    a: "KWD",
    n: 414,
    d: 3,
  },
  {
    c: "Som",
    a: "KGS",
    n: 417,
    d: 2,
  },
  {
    c: "Lao Kip",
    a: "LAK",
    n: 418,
    d: 2,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "Lebanese Pound",
    a: "LBP",
    n: 422,
    d: 2,
  },
  {
    c: "Loti",
    a: "LSL",
    n: 426,
    d: 2,
  },
  {
    c: "Rand",
    a: "ZAR",
    n: 710,
    d: 2,
  },
  {
    c: "Liberian Dollar",
    a: "LRD",
    n: 430,
    d: 2,
  },
  {
    c: "Libyan Dinar",
    a: "LYD",
    n: 434,
    d: 3,
  },
  {
    c: "Swiss Franc",
    a: "CHF",
    n: 756,
    d: 2,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "Pataca",
    a: "MOP",
    n: 446,
    d: 2,
  },
  {
    c: "Denar",
    a: "MKD",
    n: 807,
    d: 2,
  },
  {
    c: "Malagasy Ariary",
    a: "MGA",
    n: 969,
    d: 2,
  },
  {
    c: "Malawi Kwacha",
    a: "MWK",
    n: 454,
    d: 2,
  },
  {
    c: "Malaysian Ringgit",
    a: "MYR",
    n: 458,
    d: 2,
  },
  {
    c: "Rufiyaa",
    a: "MVR",
    n: 462,
    d: 2,
  },
  {
    c: "CFA Franc BCEAO",
    a: "XOF",
    n: 952,
    d: 0,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "US Dollar",
    a: "USD",
    n: 840,
    d: 2,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "Ouguiya",
    a: "MRU",
    n: 929,
    d: 2,
  },
  {
    c: "Mauritius Rupee",
    a: "MUR",
    n: 480,
    d: 2,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "ADB Unit of Account",
    a: "XUA",
    n: 965,
    d: 0,
  },
  {
    c: "Mexican Peso",
    a: "MXN",
    n: 484,
    d: 2,
  },
  {
    c: "Mexican Unidad de Inversion",
    a: "MXV",
    n: 979,
    d: 2,
  },
  {
    c: "US Dollar",
    a: "USD",
    n: 840,
    d: 2,
  },
  {
    c: "Moldovan Leu",
    a: "MDL",
    n: 498,
    d: 2,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "Tugrik",
    a: "MNT",
    n: 496,
    d: 2,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "East Caribbean Dollar",
    a: "XCD",
    n: 951,
    d: 2,
  },
  {
    c: "Moroccan Dirham",
    a: "MAD",
    n: 504,
    d: 2,
  },
  {
    c: "Mozambique Metical",
    a: "MZN",
    n: 943,
    d: 2,
  },
  {
    c: "Kyat",
    a: "MMK",
    n: 104,
    d: 2,
  },
  {
    c: "Namibia Dollar",
    a: "NAD",
    n: 516,
    d: 2,
  },
  {
    c: "Rand",
    a: "ZAR",
    n: 710,
    d: 2,
  },
  {
    c: "Australian Dollar",
    a: "AUD",
    n: 36,
    d: 2,
  },
  {
    c: "Nepalese Rupee",
    a: "NPR",
    n: 524,
    d: 2,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "CFP Franc",
    a: "XPF",
    n: 953,
    d: 0,
  },
  {
    c: "New Zealand Dollar",
    a: "NZD",
    n: 554,
    d: 2,
  },
  {
    c: "Cordoba Oro",
    a: "NIO",
    n: 558,
    d: 2,
  },
  {
    c: "CFA Franc BCEAO",
    a: "XOF",
    n: 952,
    d: 0,
  },
  {
    c: "Naira",
    a: "NGN",
    n: 566,
    d: 2,
  },
  {
    c: "New Zealand Dollar",
    a: "NZD",
    n: 554,
    d: 2,
  },
  {
    c: "Australian Dollar",
    a: "AUD",
    n: 36,
    d: 2,
  },
  {
    c: "US Dollar",
    a: "USD",
    n: 840,
    d: 2,
  },
  {
    c: "Norwegian Krone",
    a: "NOK",
    n: 578,
    d: 2,
  },
  {
    c: "Rial Omani",
    a: "OMR",
    n: 512,
    d: 3,
  },
  {
    c: "Pakistan Rupee",
    a: "PKR",
    n: 586,
    d: 2,
  },
  {
    c: "US Dollar",
    a: "USD",
    n: 840,
    d: 2,
  },
  {
    c: "Balboa",
    a: "PAB",
    n: 590,
    d: 2,
  },
  {
    c: "US Dollar",
    a: "USD",
    n: 840,
    d: 2,
  },
  {
    c: "Kina",
    a: "PGK",
    n: 598,
    d: 2,
  },
  {
    c: "Guarani",
    a: "PYG",
    n: 600,
    d: 0,
  },
  {
    c: "Sol",
    a: "PEN",
    n: 604,
    d: 2,
  },
  {
    c: "Philippine Peso",
    a: "PHP",
    n: 608,
    d: 2,
  },
  {
    c: "New Zealand Dollar",
    a: "NZD",
    n: 554,
    d: 2,
  },
  {
    c: "Zloty",
    a: "PLN",
    n: 985,
    d: 2,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "US Dollar",
    a: "USD",
    n: 840,
    d: 2,
  },
  {
    c: "Qatari Rial",
    a: "QAR",
    n: 634,
    d: 2,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "Romanian Leu",
    a: "RON",
    n: 946,
    d: 2,
  },
  {
    c: "Russian Ruble",
    a: "RUB",
    n: 643,
    d: 2,
  },
  {
    c: "Rwanda Franc",
    a: "RWF",
    n: 646,
    d: 0,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "Saint Helena Pound",
    a: "SHP",
    n: 654,
    d: 2,
  },
  {
    c: "East Caribbean Dollar",
    a: "XCD",
    n: 951,
    d: 2,
  },
  {
    c: "East Caribbean Dollar",
    a: "XCD",
    n: 951,
    d: 2,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "East Caribbean Dollar",
    a: "XCD",
    n: 951,
    d: 2,
  },
  {
    c: "Tala",
    a: "WST",
    n: 882,
    d: 2,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "Dobra",
    a: "STN",
    n: 930,
    d: 2,
  },
  {
    c: "Saudi Riyal",
    a: "SAR",
    n: 682,
    d: 2,
  },
  {
    c: "CFA Franc BCEAO",
    a: "XOF",
    n: 952,
    d: 0,
  },
  {
    c: "Serbian Dinar",
    a: "RSD",
    n: 941,
    d: 2,
  },
  {
    c: "Seychelles Rupee",
    a: "SCR",
    n: 690,
    d: 2,
  },
  {
    c: "Leone",
    a: "SLL",
    n: 694,
    d: 2,
  },
  {
    c: "Leone",
    a: "SLE",
    n: 925,
    d: 2,
  },
  {
    c: "Singapore Dollar",
    a: "SGD",
    n: 702,
    d: 2,
  },
  {
    c: "Netherlands Antillean Guilder",
    a: "ANG",
    n: 532,
    d: 2,
  },
  {
    c: "Sucre",
    a: "XSU",
    n: 994,
    d: 0,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "Solomon Islands Dollar",
    a: "SBD",
    n: 90,
    d: 2,
  },
  {
    c: "Somali Shilling",
    a: "SOS",
    n: 706,
    d: 2,
  },
  {
    c: "Rand",
    a: "ZAR",
    n: 710,
    d: 2,
  },
  {
    c: "South Sudanese Pound",
    a: "SSP",
    n: 728,
    d: 2,
  },
  {
    c: "Euro",
    a: "EUR",
    n: 978,
    d: 2,
  },
  {
    c: "Sri Lanka Rupee",
    a: "LKR",
    n: 144,
    d: 2,
  },
  {
    c: "Sudanese Pound",
    a: "SDG",
    n: 938,
    d: 2,
  },
  {
    c: "Surinam Dollar",
    a: "SRD",
    n: 968,
    d: 2,
  },
  {
    c: "Norwegian Krone",
    a: "NOK",
    n: 578,
    d: 2,
  },
  {
    c: "Swedish Krona",
    a: "SEK",
    n: 752,
    d: 2,
  },
  {
    c: "Swiss Franc",
    a: "CHF",
    n: 756,
    d: 2,
  },
  {
    c: "WIR Euro",
    a: "CHE",
    n: 947,
    d: 2,
  },
  {
    c: "WIR Franc",
    a: "CHW",
    n: 948,
    d: 2,
  },
  {
    c: "Syrian Pound",
    a: "SYP",
    n: 760,
    d: 2,
  },
  {
    c: "New Taiwan Dollar",
    a: "TWD",
    n: 901,
    d: 2,
  },
  {
    c: "Somoni",
    a: "TJS",
    n: 972,
    d: 2,
  },
  {
    c: "Tanzanian Shilling",
    a: "TZS",
    n: 834,
    d: 2,
  },
  {
    c: "Baht",
    a: "THB",
    n: 764,
    d: 2,
  },
  {
    c: "US Dollar",
    a: "USD",
    n: 840,
    d: 2,
  },
  {
    c: "CFA Franc BCEAO",
    a: "XOF",
    n: 952,
    d: 0,
  },
  {
    c: "New Zealand Dollar",
    a: "NZD",
    n: 554,
    d: 2,
  },
  {
    c: "Pa'anga",
    a: "TOP",
    n: 776,
    d: 2,
  },
  {
    c: "Trinidad and Tobago Dollar",
    a: "TTD",
    n: 780,
    d: 2,
  },
  {
    c: "Tunisian Dinar",
    a: "TND",
    n: 788,
    d: 3,
  },
  {
    c: "Turkish Lira",
    a: "TRY",
    n: 949,
    d: 2,
  },
  {
    c: "Turkmenistan New Manat",
    a: "TMT",
    n: 934,
    d: 2,
  },
  {
    c: "US Dollar",
    a: "USD",
    n: 840,
    d: 2,
  },
  {
    c: "Australian Dollar",
    a: "AUD",
    n: 36,
    d: 2,
  },
  {
    c: "Uganda Shilling",
    a: "UGX",
    n: 800,
    d: 0,
  },
  {
    c: "Hryvnia",
    a: "UAH",
    n: 980,
    d: 2,
  },
  {
    c: "UAE Dirham",
    a: "AED",
    n: 784,
    d: 2,
  },
  {
    c: "Pound Sterling",
    a: "GBP",
    n: 826,
    d: 2,
  },
  {
    c: "US Dollar",
    a: "USD",
    n: 840,
    d: 2,
  },
  {
    c: "US Dollar",
    a: "USD",
    n: 840,
    d: 2,
  },
  {
    c: "US Dollar (Next day)",
    a: "USN",
    n: 997,
    d: 2,
  },
  {
    c: "Peso Uruguayo",
    a: "UYU",
    n: 858,
    d: 2,
  },
  {
    c: "Uruguay Peso en Unidades Indexadas (UI)",
    a: "UYI",
    n: 940,
    d: 0,
  },
  {
    c: "Unidad Previsional",
    a: "UYW",
    n: 927,
    d: 4,
  },
  {
    c: "Uzbekistan Sum",
    a: "UZS",
    n: 860,
    d: 2,
  },
  {
    c: "Vatu",
    a: "VUV",
    n: 548,
    d: 0,
  },
  {
    c: "Bolívar Soberano",
    a: "VES",
    n: 928,
    d: 2,
  },
  {
    c: "Bolívar Soberano",
    a: "VED",
    n: 926,
    d: 2,
  },
  {
    c: "Dong",
    a: "VND",
    n: 704,
    d: 0,
  },
  {
    c: "US Dollar",
    a: "USD",
    n: 840,
    d: 2,
  },
  {
    c: "US Dollar",
    a: "USD",
    n: 840,
    d: 2,
  },
  {
    c: "CFP Franc",
    a: "XPF",
    n: 953,
    d: 0,
  },
  {
    c: "Moroccan Dirham",
    a: "MAD",
    n: 504,
    d: 2,
  },
  {
    c: "Yemeni Rial",
    a: "YER",
    n: 886,
    d: 2,
  },
  {
    c: "Zambian Kwacha",
    a: "ZMW",
    n: 967,
    d: 2,
  },
  {
    c: "Zimbabwe Dollar",
    a: "ZWL",
    n: 932,
    d: 2,
  },
  {
    c: "Bond Markets Unit European Composite Unit (EURCO)",
    a: "XBA",
    n: 955,
    d: 0,
  },
  {
    c: "Bond Markets Unit European Monetary Unit (E.M.U.-6)",
    a: "XBB",
    n: 956,
    d: 0,
  },
  {
    c: "Bond Markets Unit European Unit of Account 9 (E.U.A.-9)",
    a: "XBC",
    n: 957,
    d: 0,
  },
  {
    c: "Bond Markets Unit European Unit of Account 17 (E.U.A.-17)",
    a: "XBD",
    n: 958,
    d: 0,
  },
  {
    c: "Codes specifically reserved for testing purposes",
    a: "XTS",
    n: 963,
    d: 0,
  },
  {
    c: "The codes assigned for transactions where no currency is involved",
    a: "XXX",
    n: 999,
    d: 0,
  },
  {
    c: "Gold",
    a: "XAU",
    n: 959,
    d: 0,
  },
  {
    c: "Palladium",
    a: "XPD",
    n: 964,
    d: 0,
  },
  {
    c: "Platinum",
    a: "XPT",
    n: 962,
    d: 0,
  },
  {
    c: "Silver",
    a: "XAG",
    n: 961,
    d: 0,
  },
];
