/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2025 Qualcomm Innovation Center, Inc. All rights reserved.
 */
#ifndef _TMELCOM_H_
#define _TMELCOM_H_

#include <linux/bitfield.h>

/*
 * Macro used to define unique TMEL Message Identifier based on
 * message type and action identifier.
 */
#define MSGTYPE_MASK GENMASK(15, 8)
#define ACTIONID_MASK GENMASK(7, 0)

#define TMEL_MSG_UID_CREATE(msg_type, action_id) \
	(FIELD_PREP_CONST(MSGTYPE_MASK, msg_type) | \
	FIELD_PREP_CONST(ACTIONID_MASK, action_id))

/*
 * Helper macro to extract the messageType from TMEL_MSG_UID
 */
#define TMEL_MSG_UID_MSG_TYPE(v)	FIELD_GET(MSGTYPE_MASK, v)

/*
 * Helper macro to extract the actionID from TMEL_MSG_UID
 */
#define TMEL_MSG_UID_ACTION_ID(v)	FIELD_GET(ACTIONID_MASK, v)

/*
 * All definitions of supported messageTypes.
 */
#define TMEL_MSG_SECBOOT	0x00

/*
 * Action IDs for TMEL_MSG_SECBOOT
 */
#define TMEL_ACTION_SECBOOT_SEC_AUTH		0x04
#define TMEL_ACTION_SECBOOT_SS_TEAR_DOWN	0x0a

/*
 * UIDs for TMEL_MSG_SECBOOT
 */
#define TMEL_MSG_UID_SECBOOT_SEC_AUTH	    TMEL_MSG_UID_CREATE(TMEL_MSG_SECBOOT,\
					    TMEL_ACTION_SECBOOT_SEC_AUTH)

#define TMEL_MSG_UID_SECBOOT_SS_TEAR_DOWN	TMEL_MSG_UID_CREATE(TMEL_MSG_SECBOOT,\
						TMEL_ACTION_SECBOOT_SS_TEAR_DOWN)

struct tmel_qmp_msg {
	void *msg;
	u32 msg_id;
};

struct tmel_sec_auth {
	void *data;
	u32 size;
	u32 pas_id;
};

void tmel_secboot_sec_free(void *ptr);

DEFINE_FREE(tmel_secboot_sec_f, void *, if (_T) tmel_secboot_sec_free(_T))
#endif  /* _TMELCOM_H_ */
