/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso;

import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.api.Deployment;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.web.undertow.UndertowBinaryRequirement;
import org.wildfly.clustering.web.undertow.UndertowRequirement;
import org.wildfly.clustering.web.undertow.sso.SessionManagerRegistry;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.UndertowEventListener;
import org.wildfly.extension.undertow.UndertowService;

public class SessionManagerRegistryServiceConfigurator
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
Service,
SessionManagerRegistry,
UndertowEventListener {
    private final String serverName;
    private final String hostName;
    private final SupplierDependency<SessionListener> listener;
    private final ConcurrentMap<String, SessionManager> managers = new ConcurrentHashMap<String, SessionManager>();
    private volatile SupplierDependency<UndertowService> service;
    private volatile SupplierDependency<Host> host;
    private volatile Consumer<SessionManagerRegistry> registry;

    public SessionManagerRegistryServiceConfigurator(ServiceName name, String serverName, String hostName, SupplierDependency<SessionListener> listener) {
        super(name);
        this.serverName = serverName;
        this.hostName = hostName;
        this.listener = listener;
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        this.service = new ServiceSupplierDependency(UndertowRequirement.UNDERTOW.getServiceName(support));
        this.host = new ServiceSupplierDependency(UndertowBinaryRequirement.HOST.getServiceName(support, this.serverName, this.hostName));
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        this.registry = new CompositeDependency(new Dependency[]{this.listener, this.service, this.host}).register(builder).provides(new ServiceName[]{this.getServiceName()});
        return builder.setInstance((Service)this).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public void start(StartContext context) {
        ((UndertowService)this.service.get()).registerListener((UndertowEventListener)this);
        for (Deployment deployment : ((Host)this.host.get()).getDeployments()) {
            this.addDeployment(deployment);
        }
        this.registry.accept(this);
    }

    public void stop(StopContext context) {
        for (Deployment deployment : ((Host)this.host.get()).getDeployments()) {
            this.removeDeployment(deployment);
        }
        ((UndertowService)this.service.get()).unregisterListener((UndertowEventListener)this);
    }

    private void addDeployment(Deployment deployment) {
        SessionManager manager = deployment.getSessionManager();
        if (this.managers.putIfAbsent(deployment.getDeploymentInfo().getDeploymentName(), deployment.getSessionManager()) == null) {
            manager.registerSessionListener((SessionListener)this.listener.get());
        }
    }

    private void removeDeployment(Deployment deployment) {
        if (this.managers.remove(deployment.getDeploymentInfo().getDeploymentName()) != null) {
            deployment.getSessionManager().removeSessionListener((SessionListener)this.listener.get());
        }
    }

    public void onDeploymentStart(Deployment deployment, Host host) {
        if (((Host)this.host.get()).getName().equals(host.getName())) {
            this.addDeployment(deployment);
        }
    }

    public void onDeploymentStop(Deployment deployment, Host host) {
        if (((Host)this.host.get()).getName().equals(host.getName())) {
            this.removeDeployment(deployment);
        }
    }

    @Override
    public SessionManager getSessionManager(String deployment) {
        return (SessionManager)this.managers.get(deployment);
    }
}

