/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.simple;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.ejb3.cache.Cache;
import org.jboss.as.ejb3.cache.Identifiable;
import org.jboss.as.ejb3.cache.StatefulObjectFactory;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.NodeAffinity;
import org.wildfly.clustering.ejb.IdentifierFactory;

public class SimpleCache<K, V extends Identifiable<K>>
implements Cache<K, V> {
    final Map<K, Future<?>> expirationFutures = new ConcurrentHashMap();
    private final ConcurrentMap<K, Entry<V>> entries = new ConcurrentHashMap<K, Entry<V>>();
    private final StatefulObjectFactory<V> factory;
    private final IdentifierFactory<K> identifierFactory;
    private final StatefulTimeoutInfo timeout;
    private final ServerEnvironment environment;
    private final ScheduledExecutorService executor;

    public SimpleCache(StatefulObjectFactory<V> factory, IdentifierFactory<K> identifierFactory, StatefulTimeoutInfo timeout, ServerEnvironment environment, ScheduledExecutorService executor) {
        this.factory = factory;
        this.identifierFactory = identifierFactory;
        this.timeout = timeout;
        this.environment = environment;
        this.executor = executor;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        for (Future<?> future : this.expirationFutures.values()) {
            future.cancel(true);
        }
        for (Future<?> future : this.expirationFutures.values()) {
            if (future.isCancelled() || future.isDone()) continue;
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException executionException) {}
        }
        for (Map.Entry entry : this.entries.entrySet()) {
            this.factory.destroyInstance(((Entry)entry.getValue()).getValue());
        }
        this.expirationFutures.clear();
        this.entries.clear();
    }

    public Affinity getStrictAffinity() {
        return new NodeAffinity(this.environment.getNodeName());
    }

    public Affinity getWeakAffinity(K key) {
        return Affinity.NONE;
    }

    public K createIdentifier() {
        return (K)this.identifierFactory.createIdentifier();
    }

    @Override
    public V create() {
        if (CURRENT_GROUP.get() != null) {
            throw EjbLogger.ROOT_LOGGER.incompatibleCaches();
        }
        Identifiable bean = (Identifiable)this.factory.createInstance();
        this.entries.put(bean.getId(), new Entry<Identifiable>(bean));
        return (V)bean;
    }

    @Override
    public void discard(V value) {
        this.entries.remove(value.getId());
    }

    @Override
    public void remove(K key) {
        Entry entry = (Entry)this.entries.remove(key);
        if (entry != null) {
            this.factory.destroyInstance(entry.getValue());
        }
    }

    @Override
    public V get(K key) {
        Entry entry;
        Future<?> future = this.expirationFutures.get(key);
        if (future != null) {
            future.cancel(true);
        }
        if ((entry = (Entry)this.entries.get(key)) == null) {
            return null;
        }
        entry.use();
        return (V)((Identifiable)entry.getValue());
    }

    @Override
    public boolean contains(K key) {
        return this.entries.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(V bean) {
        Object id = bean.getId();
        Entry entry = (Entry)this.entries.get(id);
        if (entry != null && entry.done() && this.timeout != null) {
            long value = this.timeout.getValue();
            if (value > 0L) {
                RemoveTask task;
                TimeUnit unit = this.timeout.getTimeUnit();
                RemoveTask removeTask = task = new RemoveTask(id);
                synchronized (removeTask) {
                    this.expirationFutures.put(id, this.executor.schedule(task, value, unit));
                }
            } else if (value == 0L) {
                this.remove(id);
            }
        }
    }

    @Override
    public int getCacheSize() {
        return this.entries.size();
    }

    @Override
    public int getPassivatedCount() {
        return 0;
    }

    @Override
    public int getTotalSize() {
        return this.getCacheSize();
    }

    static class Entry<V> {
        private final V value;
        private final AtomicInteger usage = new AtomicInteger();

        Entry(V value) {
            this.value = value;
        }

        void use() {
            this.usage.incrementAndGet();
        }

        boolean done() {
            return this.usage.decrementAndGet() == 0;
        }

        V getValue() {
            return this.value;
        }
    }

    class RemoveTask
    implements Runnable {
        private final K key;

        RemoveTask(K key) {
            this.key = key;
        }

        @Override
        public synchronized void run() {
            if (!Thread.currentThread().isInterrupted()) {
                SimpleCache.this.remove(this.key);
            }
            SimpleCache.this.expirationFutures.remove(this.key);
        }
    }
}

