/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.service.spi;

import org.hibernate.search.engine.service.spi.Service;
import org.hibernate.search.engine.service.spi.ServiceManager;

public class ServiceReference<S extends Service>
implements AutoCloseable {
    private final ServiceManager serviceManager;
    private final Class<S> serviceType;
    private final S service;

    public ServiceReference(ServiceManager serviceManager, Class<S> serviceType) {
        this.serviceManager = serviceManager;
        this.serviceType = serviceType;
        this.service = serviceManager.requestService(serviceType);
    }

    public S get() {
        return this.service;
    }

    @Override
    public void close() {
        this.serviceManager.releaseService(this.serviceType);
    }
}

