/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.rest.bridge.inbound;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.jta.xa.XATxConverter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;
import org.jboss.narayana.rest.bridge.inbound.InboundBridge;
import org.jboss.narayana.rest.bridge.inbound.InboundBridgeException;
import org.jboss.narayana.rest.bridge.inbound.InboundBridgeParticipant;
import org.jboss.narayana.rest.bridge.inbound.InboundBridgeParticipantDeserializer;
import org.jboss.narayana.rest.integration.api.Participant;
import org.jboss.narayana.rest.integration.api.ParticipantDeserializer;
import org.jboss.narayana.rest.integration.api.ParticipantsManagerFactory;

public final class InboundBridgeManager {
    private static InboundBridgeManager INSTANCE;
    private static final String APPLICATION_ID = "org.jboss.narayana.rest.bridge.inbound.InboundBridgeManager:application_id";
    private static final Logger LOG;
    private final Map<Xid, InboundBridge> inboundBridges = new ConcurrentHashMap<Xid, InboundBridge>();
    private final Map<String, Xid> transactionXids = new ConcurrentHashMap<String, Xid>();

    public static synchronized InboundBridgeManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InboundBridgeManager();
        }
        return INSTANCE;
    }

    private InboundBridgeManager() {
        ParticipantsManagerFactory.getInstance().registerDeserializer(APPLICATION_ID, (ParticipantDeserializer)new InboundBridgeParticipantDeserializer());
    }

    public synchronized boolean addInboundBridge(InboundBridge inboundBridge) {
        InboundBridge existingInboundBridge;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("InboundBridgeManager.addInboundBridge: inboundBridge=" + inboundBridge));
        }
        if (inboundBridge.equals(existingInboundBridge = this.inboundBridges.get(inboundBridge.getXid()))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("InboundBridgeManager.addInboundBridge: " + inboundBridge + " was added before"));
            }
            return true;
        }
        if (existingInboundBridge != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("InboundBridgeManager.addInboundBridge: another bridge uses this xid " + existingInboundBridge));
            }
            return false;
        }
        this.inboundBridges.put(inboundBridge.getXid(), inboundBridge);
        this.transactionXids.put(inboundBridge.getEnlistmentUrl(), inboundBridge.getXid());
        return true;
    }

    public InboundBridge getInboundBridge(Xid xid) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("InboundBridgeManager.getInboundBridge: xid=" + xid));
        }
        return this.inboundBridges.get(xid);
    }

    public synchronized InboundBridge createInboundBridge(String enlistmentUrl) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("InboundBridgeManager.createInboundBridge: enlistmentUrl=" + enlistmentUrl));
        }
        if (enlistmentUrl == null) {
            throw new IllegalArgumentException("Enlistment URL is required");
        }
        if (!this.transactionXids.containsKey(enlistmentUrl)) {
            this.createAndEnlist(enlistmentUrl);
        }
        Xid xid = this.transactionXids.get(enlistmentUrl);
        return this.inboundBridges.get(xid);
    }

    public void removeInboundBridge(Xid xid) {
        InboundBridge inboundBridge;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("InboundBridgeManager.removeInboundBridge: xid=" + xid));
        }
        if ((inboundBridge = this.inboundBridges.get(xid)) != null) {
            this.transactionXids.remove(inboundBridge.getEnlistmentUrl());
            this.inboundBridges.remove(xid);
        }
    }

    private void createAndEnlist(String enlistmentUrl) {
        InboundBridge inboundBridge = this.getNewInboundBridge(enlistmentUrl);
        InboundBridgeParticipant inboundBridgeParticipant = new InboundBridgeParticipant(inboundBridge.getXid());
        String participantId = ParticipantsManagerFactory.getInstance().enlist(APPLICATION_ID, enlistmentUrl, (Participant)inboundBridgeParticipant);
        if (participantId == null) {
            throw new InboundBridgeException("Participant was not enlisted.");
        }
        this.transactionXids.put(enlistmentUrl, inboundBridge.getXid());
        this.inboundBridges.put(inboundBridge.getXid(), inboundBridge);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("New inbound bridge enlisted: " + inboundBridge));
        }
    }

    private InboundBridge getNewInboundBridge(String enlistmentUrl) {
        Xid xid = XATxConverter.getXid((Uid)new Uid(), (boolean)false, (int)131081);
        InboundBridge inboundBridge = new InboundBridge(xid, enlistmentUrl);
        return inboundBridge;
    }

    static {
        LOG = Logger.getLogger(InboundBridgeManager.class);
    }
}

