/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.Type;
import javax.json.bind.JsonbException;
import javax.json.bind.adapter.JsonbAdapter;
import javax.json.bind.serializer.JsonbSerializer;
import javax.json.bind.serializer.SerializationContext;
import javax.json.stream.JsonGenerator;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.Marshaller;
import org.eclipse.yasson.internal.components.AdapterBinding;
import org.eclipse.yasson.internal.model.ClassModel;
import org.eclipse.yasson.internal.model.JsonBindingModel;
import org.eclipse.yasson.internal.model.JsonbPropertyInfo;
import org.eclipse.yasson.internal.model.customization.Customization;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.ContainerSerializerProvider;
import org.eclipse.yasson.internal.serializer.CurrentItem;
import org.eclipse.yasson.internal.serializer.SerializerBuilder;

public class AdaptedObjectSerializer<T, A>
implements CurrentItem<T>,
JsonbSerializer<T> {
    private final JsonBindingModel model;
    private final AdapterBinding adapterInfo;

    public AdaptedObjectSerializer(JsonBindingModel model, AdapterBinding adapter) {
        this.model = new AdaptedObjectSerializerModel(model, adapter.getToType());
        this.adapterInfo = adapter;
    }

    public void serialize(T obj, JsonGenerator generator, SerializationContext ctx) {
        JsonbContext jsonbContext = ((Marshaller)ctx).getJsonbContext();
        try {
            jsonbContext.addProcessedType(this.adapterInfo.getBindingType());
            JsonbAdapter<?, ?> adapter = this.adapterInfo.getAdapter();
            Object adapted = adapter.adaptToJson(obj);
            JsonbSerializer<Object> serializer = this.resolveSerializer((Marshaller)ctx, adapted);
            serializer.serialize(adapted, generator, ctx);
        }
        catch (Exception e) {
            throw new JsonbException(Messages.getMessage(MessageKeys.ADAPTER_EXCEPTION, this.adapterInfo.getBindingType(), this.adapterInfo.getToType(), this.adapterInfo.getAdapter().getClass()), (Throwable)e);
        }
        finally {
            jsonbContext.removeProcessedType(this.adapterInfo.getBindingType());
        }
    }

    private JsonbSerializer<A> resolveSerializer(Marshaller ctx, A adapted) {
        ContainerSerializerProvider cached = ctx.getMappingContext().getSerializerProvider(adapted.getClass());
        if (cached != null) {
            return cached.provideSerializer(new JsonbPropertyInfo().withWrapper(this).withRuntimeType(this.model.getType()).withJsonBindingModel(this.model));
        }
        return ((SerializerBuilder)((SerializerBuilder)new SerializerBuilder(ctx.getJsonbContext()).withObjectClass(adapted.getClass()).withModel(this.model)).withWrapper(this)).build();
    }

    @Override
    public ClassModel getClassModel() {
        return null;
    }

    @Override
    public CurrentItem<?> getWrapper() {
        return null;
    }

    @Override
    public JsonBindingModel getWrapperModel() {
        return this.model;
    }

    @Override
    public Type getRuntimeType() {
        return null;
    }

    private static final class AdaptedObjectSerializerModel
    implements JsonBindingModel {
        private final JsonBindingModel wrapperSerializerModel;
        private final Type adaptedType;

        public AdaptedObjectSerializerModel(JsonBindingModel wrapperSerializerModel, Type adaptedType) {
            this.wrapperSerializerModel = wrapperSerializerModel;
            this.adaptedType = adaptedType;
        }

        @Override
        public Customization getCustomization() {
            return this.wrapperSerializerModel != null ? this.wrapperSerializerModel.getCustomization() : null;
        }

        @Override
        public Type getType() {
            return this.adaptedType;
        }
    }
}

