/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.health;

import io.smallrye.health.SmallRyeHealth;
import io.smallrye.health.SmallRyeHealthReporter;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.util.function.Supplier;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.server.mgmt.domain.ExtensibleHttpManagement;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;

public class HealthContextService
implements Service {
    static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"extension", "health", "context"});
    private static final String CONTEXT_NAME = "health";
    private final Supplier<ExtensibleHttpManagement> extensibleHttpManagement;
    private final boolean securityEnabled;
    private final Supplier<SmallRyeHealthReporter> healthReporter;

    static void install(OperationContext context, boolean securityEnabled) {
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(SERVICE_NAME);
        Supplier extensibleHttpManagement = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.management.http.extensible", ExtensibleHttpManagement.class));
        Supplier healthReporter = serviceBuilder.requires(context.getCapabilityServiceName("org.wildlfy.microprofile.health.reporter", SmallRyeHealthReporter.class));
        HealthContextService healthContextService = new HealthContextService(extensibleHttpManagement, securityEnabled, healthReporter);
        serviceBuilder.setInstance((Service)healthContextService).install();
    }

    HealthContextService(Supplier<ExtensibleHttpManagement> extensibleHttpManagement, boolean securityEnabled, Supplier<SmallRyeHealthReporter> healthReporter) {
        this.extensibleHttpManagement = extensibleHttpManagement;
        this.securityEnabled = securityEnabled;
        this.healthReporter = healthReporter;
    }

    public void start(StartContext context) {
        this.extensibleHttpManagement.get().addManagementHandler(CONTEXT_NAME, this.securityEnabled, (HttpHandler)new HealthCheckHandler(this.healthReporter.get()));
    }

    public void stop(StopContext context) {
        this.extensibleHttpManagement.get().removeContext(CONTEXT_NAME);
    }

    private class HealthCheckHandler
    implements HttpHandler {
        private final SmallRyeHealthReporter healthReporter;

        public HealthCheckHandler(SmallRyeHealthReporter healthReporter) {
            this.healthReporter = healthReporter;
        }

        public void handleRequest(HttpServerExchange exchange) {
            SmallRyeHealth health = this.healthReporter.getHealth();
            exchange.setStatusCode(health.isDown() ? 503 : 200).getResponseHeaders().add(Headers.CONTENT_TYPE, "application/json");
            exchange.getResponseSender().send(health.getPayload().toString());
        }
    }
}

