/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.dispatcher;

import java.security.PrivilegedAction;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.server.dispatcher.AutoCloseableCommandDispatcherFactory;
import org.wildfly.clustering.server.dispatcher.LocalCommandDispatcher;
import org.wildfly.security.manager.WildFlySecurityManager;

public class LocalCommandDispatcherFactory
implements AutoCloseableCommandDispatcherFactory,
PrivilegedAction<Void> {
    private final Group group;
    private final ExecutorService executor;

    private static ThreadFactory createThreadFactory() {
        PrivilegedAction<ThreadFactory> action = () -> new JBossThreadFactory(new ThreadGroup(LocalCommandDispatcher.class.getSimpleName()), Boolean.FALSE, null, "%G - %t", null, null);
        return (ThreadFactory)WildFlySecurityManager.doUnchecked(action);
    }

    public LocalCommandDispatcherFactory(Group group) {
        this.group = group;
        this.executor = Executors.newCachedThreadPool(LocalCommandDispatcherFactory.createThreadFactory());
    }

    public Group getGroup() {
        return this.group;
    }

    public <C> CommandDispatcher<C> createCommandDispatcher(Object id, C context) {
        return new LocalCommandDispatcher<C>(this.group.getLocalMember(), context, this.executor);
    }

    @Override
    public void close() {
        WildFlySecurityManager.doUnchecked((PrivilegedAction)this);
    }

    @Override
    public Void run() {
        this.executor.shutdownNow();
        return null;
    }
}

