# -*- coding: utf-8 -*-

'''
Copyright (C) 2014                                                     

This program is free software: you can redistribute it and/or modify   
it under the terms of the GNU General Public License as published by   
the Free Software Foundation, either version 3 of the License, or      
(at your option) any later version.                                    

This program is distributed in the hope that it will be useful,        
but WITHOUT ANY WARRANTY; without even the implied warranty of         
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
GNU General Public License for more details.                           

You should have received a copy of the GNU General Public License      
along with this program. If not, see <http://www.gnu.org/licenses/  
'''                                                                           

import urllib, urllib2, re, os ,unicodedata
import xbmcplugin, xbmcgui, xbmcaddon
import json
from BeautifulSoup import BeautifulSoup

addon = xbmcaddon.Addon(id='plugin.audio.itv.khosachnoi')
profile = addon.getAddonInfo('profile')
home = addon.getAddonInfo('path')
dataPatch = xbmc.translatePath(os.path.join(home, 'resources'))
logos = xbmc.translatePath(os.path.join(dataPatch, 'logos\\'))
fanart = xbmc.translatePath(os.path.join(dataPatch, 'art\\'))
icon = xbmc.translatePath(os.path.join(home, 'icon.png'))

isach = 'http://isach.info/'
isachauthor = 'http://isach.info/audio.php?list=audio&reader='
isachtype = 'http://isach.info/audio.php?list=audio&category='

def main(): #
    addDir('[COLOR red]Tìm Kiếm[/COLOR]', 'isach', 99, logos + 'Search.png', fanart + 'fanart.jpg', isFolder=True)
	
    content = makeRequest(isach)
	
    match = re.compile('<li class="menu_item"><a href="/audio.php?.*?reader=(.*?)">(.*?)</a></li>').findall(content)  
    for url, title in match:
        addDir( '[[COLOR blue]Tác giả[/COLOR]] ' + title, isachauthor + url, 2, logos + 'author.png', fanart + 'fanart.jpg', isFolder=True)

    match = re.compile('<li class="menu_item"><a href="/audio.php?.*?category=(.*?)">(.*?)</a></li>').findall(content)  
    for url, title in match:
        addDir( '[[COLOR orange]Thể loại[/COLOR]] ' + title, isachtype + url, 2, logos + 'type.png', fanart + 'fanart.jpg', isFolder=True)

def mediaList(url): #2
    content = makeRequest(url)
    match = re.compile('<div class=\'left_list_item\'>\s*<a href="(.*?)" title="(.*?)">').findall(content)  
    for href, title in match:
        addDir( title, isach + href, 3, logos + 'book.png', fanart, isFolder=True)
		
    match = re.compile('<li><a class=\'navigator\' href="(.*?)">\s*<img class=.*?5px;" src=".*?" alt="Next"/>').findall(content)[1:2]  
    for href in match:
        addDir( '[COLOR red]Trang Tiếp Theo >>>[/COLOR]', isach + href, 2, logos + 'NEXT.png', fanart, isFolder=True)

def episodes(url,iconimage): #3
    content = makeRequest(url)
    match = re.compile('title:"(.*?)", mp3:"(.*?)"').findall(content)
    for name, link in match:
        addDir( name, link, 100, iconimage, fanart, isFolder=False)

def search(): #99
    try:
        keyb = xbmc.Keyboard('', '[COLOR yellow]Enter search text[/COLOR]')
        keyb.doModal()
        if (keyb.isConfirmed()):
            searchText = urllib.quote_plus(keyb.getText())
        url = 'http://isach.info/search/audio_result.php?search=%s' % urllib.quote_plus(searchText.replace(' ','%20'))
        #print "Searching URL: " + url	
        search_data(url)
    except:
	    pass

def search_data(url): #2
    content = makeRequest(url)
    match = re.compile('<div class=\'left_list_item\'>\s*<a href="(.*?)" title="(.*?)">').findall(content)  
    for href, title in match:
        addDir( title, href, 3, logos + 'book.png', fanart, isFolder=True)
		
def resolveUrl(url): #100
    mediaUrl = url
    item = xbmcgui.ListItem( path = mediaUrl)
    xbmcplugin.setResolvedUrl(int(sys.argv[1]), True, item)
    return

def makeRequest(url, headers=None):
    if headers is None:
        headers = {'User-agent' : 'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2228.0 Safari/537.36',
                 'Referer' : 'http://www.google.com'}
    try:
        req = urllib2.Request(url,headers=headers)
        f = urllib2.urlopen(req)
        body=f.read()
        return body
    except:
        pass 
  
def get_params():
    param=[]
    paramstring=sys.argv[2]
    if len(paramstring)>=2:
        params=sys.argv[2]
        cleanedparams=params.replace('?','')
        if (params[len(params)-1]=='/'):
            params=params[0:len(params)-2]
        pairsofparams=cleanedparams.split('&')
        param={}
        for i in range(len(pairsofparams)):
            splitparams={}
            splitparams=pairsofparams[i].split('=')
            if (len(splitparams))==2:
                param[splitparams[0]]=splitparams[1]
    return param

def addDir(name,url,mode,iconimage,fanart,isFolder=False):
    u=sys.argv[0]+"?url="+urllib.quote_plus(url)+"&mode="+str(mode)+"&name="+urllib.quote_plus(name)+"&iconimage="+urllib.quote_plus(iconimage)+"&fanart="+urllib.quote_plus(fanart)
    ok=True
    liz=xbmcgui.ListItem(name, iconImage="DefaultFolder.png", thumbnailImage=iconimage)
    liz.setInfo( type="Video", infoLabels={ "Title": name } )
    liz.setProperty('Fanart_Image',fanart)
    if not isFolder:
        liz.setProperty('IsPlayable', 'true')
    ok=xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]),url=u,listitem=liz,isFolder=isFolder)
    return ok 

	
params=get_params()
url=None
name=None
mode=None
iconimage=None

try:url=urllib.unquote_plus(params["url"])
except:pass
try:name=urllib.unquote_plus(params["name"])
except:pass
try:mode=int(params["mode"])
except:pass
try:iconimage=urllib.unquote_plus(params["iconimage"])
except:pass  
try:fanart=urllib.unquote_plus(params["fanart"])
except:pass
  
if mode==None or url==None or len(url)<1:main()
#elif mode==1:Categories(url,name)
elif mode==2:mediaList(url)
elif mode==3:episodes(url,iconimage)
elif mode==99:search()
elif mode==100:resolveUrl(url)
			
xbmcplugin.endOfDirectory(int(sys.argv[1]))
