import xbmc
import xbmcgui
import xbmcplugin
import xbmcaddon
import sys
import urllib
import os
import re
import xbmcvfs

addon_handle = int(sys.argv[1])
addon = xbmcaddon.Addon(id='plugin.program.favkaos')
profileDir = addon.getAddonInfo('profile')
profileDir = xbmc.translatePath(profileDir).decode("utf-8")


def loadmap(map):
    favourites_file = os.path.join(profileDir, '%s.xml' % map)
    f = xbmcvfs.File(favourites_file,"rb")
    data = f.read()
    f.close()
    favourites = re.findall("<favourite.*?</favourite>",data)
    for fav in favourites:
        url = ''
        match = re.search('>(.*?)<',fav)
        if match:
            url = match.group(1)
        label = ''
        match = re.search('name="(.*?)"',fav)
        if match:
            label = match.group(1)
        match = re.search('thumb="(.*?)"',fav)
        if match:
            thumbnail = match.group(1)
        if url:
            addDir(label, url, thumbnail, map)
    xbmcplugin.endOfDirectory(addon_handle)
    

def UPDATE(url):
    xbmc.executebuiltin(unescape(url))

    
def unescape( str ):
    str = str.replace("&lt;","<")
    str = str.replace("&gt;",">")
    str = str.replace("&quot;","\"")
    str = str.replace("&amp;","&")
    return str    


def addDir(name, url, iconimage, map, Folder=False):
    u = (sys.argv[0] +
         "?url=" + urllib.quote_plus(url) +
         "&map=" + str(map))
    ok = True
    liz = xbmcgui.ListItem(name, iconImage="DefaultFolder.png", thumbnailImage=iconimage)
    liz.setArt({'thumb': iconimage, 'icon': 'special://home/addons/plugin.program.favkaos/icon.png'})
    liz.setInfo(type="Video", infoLabels={"Title": name})
    ok = xbmcplugin.addDirectoryItem(handle=addon_handle, url=u, listitem=liz, isFolder=Folder)
    return ok


def getParams():
    param = []
    paramstring = sys.argv[2]
    if len(paramstring) >= 2:
        params = sys.argv[2]
        cleanedparams = params.replace('?', '')
        if params[len(params) - 1] == '/':
            params = params[0:len(params) - 2]
        pairsofparams = cleanedparams.split('&')
        param = {}
        for i in range(len(pairsofparams)):
            splitparams = {}
            splitparams = pairsofparams[i].split('=')
            if (len(splitparams)) == 2:
                param[splitparams[0]] = splitparams[1]

    return param


params = getParams()

map = None
url = None

try: map = params["map"]
except: pass

try: url = urllib.unquote_plus(params["url"])
except: pass


if map is None: quit()
elif map and url is None: loadmap(map)
elif url: UPDATE(url)
else: quit()

