# -*- coding: utf-8 -*-
#------------------------------------------------------------
# 1Channel Proxifier
#------------------------------------------------------------
# License: GPL (http://www.gnu.org/licenses/gpl-3.0.html)
#------------------------------------------------------------

import os
import sys
import plugintools
import xbmcaddon
import xbmc
import xbmcgui
import re

plugintools.module_log_enabled = True
plugintools.http_debug_log_enabled = True

# Entry point
def run():
    plugintools.log("1channel-proxifier.run")
    
    # Get params
    params = plugintools.get_params()
    
    if params.get("action") is None:
        main_list(params)
    else:
        action = params.get("action")
        exec action+"(params)"
    
    plugintools.close_item_list()

# Main menu
def main_list(params):
    plugintools.log("1channel-proxifier.main_list "+repr(params))

    plugintools.add_item( action="change" , title="Change Domain to Proxy" , folder=False )

def change(params):
    plugintools.log("1channel-proxifier.change "+repr(params))

    yes_pressed = plugintools.message_yes_no("1Channel Proxifier", "Please be warned that this add-on will change the default domain name for the 1Channel plugin so that it will be access by proxy in the future.","Press YES if you wish to proceed.")

    if yes_pressed:
        try:
            # Settings file in userdata
            userdata_path = xbmc.translatePath("special://userdata/")
            userdata_settings_file_path = os.path.join( userdata_path , "addon_data" , "plugin.video.1channel" , "settings.xml")
            plugintools.log("1channel-proxifier.change userdata_settings_file_path="+userdata_settings_file_path)

            # Settings file in addon
            this_addon_path = plugintools.get_runtime_path()
            addon_settings_file_path = os.path.join(this_addon_path,"..","plugin.video.1channel" , "resources" , "settings.xml")
            addon_settings_file_path = os.path.abspath(addon_settings_file_path)
            plugintools.log("1channel-proxifier.change addon_settings_file_path="+addon_settings_file_path)

            if not os.path.exists(userdata_settings_file_path) or not os.path.exists(addon_settings_file_path):
                plugintools.message("1Channel Proxifier", "Error! Settings file for 1channel","has not been found")
            else:
                # Change proxy in userdata settings
                settings_file = open( userdata_settings_file_path , "r" )
                text = settings_file.read()
                settings_file.close()

                # Change active proxy
                text = re.compile('<setting id="domain" value="[^"]+"\s*/>',re.DOTALL).sub('<setting id="domain" value="http://1channel.occupyuk.co.uk" />',text)
                # And change use of meta for avoiding script errors
                text = re.compile('<setting id="use-meta" value="true"\s*/>',re.DOTALL).sub('<setting id="use-meta" value="false" />',text)

                settings_file = open( userdata_settings_file_path ,"w")
                settings_file.write(text)
                settings_file.close()

                # Add proxy to list in addon settings
                addon_settings_file = open( addon_settings_file_path , "r" )
                text = addon_settings_file.read()
                addon_settings_file.close()

                current_proxy_list_block = plugintools.find_single_match(text,'(<setting id="domain".*?/>)')
                new_proxy_list_block = current_proxy_list_block
                plugintools.log("1channel-proxifier.change current_proxy_list_block="+current_proxy_list_block)

                current_proxy_list = plugintools.find_single_match(current_proxy_list_block,'values="([^"]+)"')
                new_proxy_list = current_proxy_list
                plugintools.log("1channel-proxifier.change current_proxy_list="+current_proxy_list)

                if not "http://primewireproxy.co.uk" in new_proxy_list:
                    new_proxy_list = new_proxy_list + "|http://primewireproxy.co.uk"

                if not "http://1channel.occupyuk.co.uk" in new_proxy_list:
                    new_proxy_list = new_proxy_list + "|http://1channel.occupyuk.co.uk"

                new_proxy_list_block = new_proxy_list_block.replace(current_proxy_list,new_proxy_list)
                plugintools.log("1channel-proxifier.change new_proxy_list_block="+new_proxy_list_block)

                text = text.replace(current_proxy_list_block,new_proxy_list_block)

                addon_settings_file = open( addon_settings_file_path ,"w")
                addon_settings_file.write(text)
                addon_settings_file.close()

                plugintools.message("1Channel Proxifier", "It's all done! You may now continue to enjoy the use of the 1Channel plugin.","Please note that you may change the domain back manually at anytime within the Add-on Settings.")

        except:
            import traceback
            plugintools.log(traceback.format_exc())
            plugintools.log("1channel-proxifier.change Nothing changed")
            plugintools.message("1Channel Proxifier", "Problem found","Your settings has not been changed")

run()