'''
    Animal TV Add-on

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

from resources.lib import Addon, animaltv
import sys, os, urllib, urllib2
import json
import xbmc, xbmcgui, xbmcplugin, xbmcaddon

import liveresolver

addon = xbmcaddon.Addon()
addonname = addon.getAddonInfo('name')
addonid = addon.getAddonInfo('id')
plugin_path = xbmcaddon.Addon(id=addonid).getAddonInfo('path')

Addon.plugin_url = sys.argv[0]
Addon.plugin_handle = int(sys.argv[1])
Addon.plugin_queries = Addon.parse_query(sys.argv[2][1:])

dlg = xbmcgui.Dialog()

Addon.log('plugin url: ' + Addon.plugin_url)
Addon.log('plugin queries: ' + str(Addon.plugin_queries))
Addon.log('plugin handle: ' + str(Addon.plugin_handle)) 

mode = Addon.plugin_queries['mode']

if mode == 'main':
    channels = animaltv.AnimalTV().get_channels()
    if channels:
        for c in channels:
            channel = c['channel'];
            id = c['id'];
            rURL = "plugin://plugin.video.animaltv/?id=" + id + "&channel=" + channel + "&mode=play&rand=" + Addon.random_generator()
            logo = c['img']
            cm_refresh = (Addon.get_string(6000), 
                      'XBMC.RunPlugin(%s/?mode=refresh)' % 
                           (Addon.plugin_url))
            cm_menu = [cm_refresh]
           
            Addon.add_video_item(rURL,
                                 {'title': channel},
                                 img=logo, playable=True, cm=cm_menu, cm_replace=True)

elif mode == 'refresh':
    xbmc.executebuiltin('Container.Refresh')

elif mode=='play':
    id = Addon.plugin_queries['id']
    channel = Addon.plugin_queries['channel']
    stream_status = animaltv.AnimalTV()._get_json('/status_json.php', {'id': id})['status']
    if stream_status == 'live':
        Addon.log(id)
        channels = []
        channels = animaltv.AnimalTV().get_link()
        if channels:
            Addon.log(str(id))
            for c in channels:
                if c['id'] == id:
                    url = c['url']
                    stream_url = liveresolver.resolve(url)
                    Addon.log(stream_url)
                    item = xbmcgui.ListItem(path=stream_url)
                    xbmcplugin.setResolvedUrl(int(sys.argv[1]), True, item)
    else:
        dlg.ok(Addon.get_string(5000), channel + " " + Addon.get_string(7000))

Addon.end_of_directory()
