#!/usr/bin/python
# -*- coding: utf-8 -*-
##┌──────────────────────────────────────
##│  DragonQuest10 LiveCamera v0.0.3 (2014/07/10)
##│  Copyright (c) Inpane
##│  plugin.video.dq10.livecam
##│  http://xbmc.inpane.com/
##│  info@inpane.com
##└──────────────────────────────────────
##
## [ 更新履歴 ]
## 2014/07/10 -> v0.0.3
##  3D動画モード追加
##
## 2014/07/02 -> v0.0.2
##  静止画モード追加
##
## 2014/06/30 -> v0.0.1
##  テスト版公開
##
##==============================================================================
## 設定値をここに記載する。
import sys, os, string

__script_path__    = os.path.abspath( os.path.dirname(__file__) )
__resources_path__ = __script_path__ + '/resources'
__cache_path__     = __script_path__ + '/cache'
__module_path__    = __resources_path__ + '/module'
__skins_path__     = __resources_path__ + '/skins'
__m3u8_file__      = __cache_path__     + '/live.3D.SBS.m3u8'
__interface_file__ = 'interface.xml'
#-------------------------------------------------------------------------------
sys.path.append (__module_path__)
import re
import threading, time
import httplib, urllib, urllib2, cookielib
import xbmc, xbmcgui, xbmcplugin, xbmcaddon
try:    import json
except: import simplejson as json

#-------------------------------------------------------------------------------
__addon_id__ = 'plugin.video.dq10.livecam'
__settings__ = xbmcaddon.Addon(__addon_id__)
__mode__     = __settings__.getSetting("mode")

__2d_json_url__     = 'http://livecamera.dqx.jp/youtube.jsonp'
__2d_youtube_url__  = 'plugin://plugin.video.youtube/?action=play_video&videoid='
__pic_json_url__    = 'http://livecamera.dqx.jp/shot_h.jsonp'

try:    __xbmc_version__ = xbmc.getInfoLabel('System.BuildVersion')
except: __xbmc_version__ = 'Unknown'
class AppURLopener(urllib.FancyURLopener):
	version = 'XBMC/' + __xbmc_version__ + ' - Download and play (' + os.name + ')'
urllib._urlopener = AppURLopener()


__image_interval__ = 30 # sec
__ctlid_dq10_image__ = 200
__ctlid_dq10_date_label__  = 210
__ctlid_dq10_place_label__ = 211

IN  = {}
OUT = {}

IN[ 'close_sequence' ] = 0

#-------------------------------------------------------------------------------
class GUI( xbmcgui.WindowXML ):
	def __init__( self, *args, **kwargs ):
		pass

	def updateImageThread(self):
		global IN
		UpdateTime = int(time.time())
		while True:
			if IN[ 'close_sequence' ] or xbmcgui.getCurrentWindowId() < 13000: break

			if UpdateTime < int(time.time()):
				self.updatePicJson()
				UpdateTime = UpdateTime + __image_interval__

	def updatePicJson(self):
		global IN
		response = urllib2.urlopen(__pic_json_url__)
		buf = response.read()
		response.close
		p = re.compile(r'callback\((.+)\)$')
		m = p.search(buf)
		decoder = json.JSONDecoder()
		jsondata, index = decoder.raw_decode(m.group(1))

		IN['pic_world_name'     ] = jsondata["liveCamValueList"][0]["WorldName"    ].encode('utf-8') # ワールド名
		IN['pic_zone_name'      ] = jsondata["liveCamValueList"][0]["ZoneName"     ].encode('utf-8') # ゾーン名
		IN['pic_timestamp'      ] = jsondata["liveCamValueList"][0]["Timestamp"    ] # タイムスタンプ
		IN['pic_file_name_large'] = jsondata["liveCamValueList"][0]["FileNameLarge"] # 画像URL

		self.getControl(__ctlid_dq10_image__).setImage("%s?%d" % (IN['pic_file_name_large'], int(time.time() * 1000)))
		t = time.localtime(IN['pic_timestamp']+946652400)
		self.getControl(__ctlid_dq10_date_label__).setLabel("さつえい日：%04d/%02d/%02d %02d:%02d:%02d" % (t[0],t[1],t[2],t[3],t[4],t[5]))

		self.getControl(__ctlid_dq10_place_label__).setLabel("さつえい場所：%s（%s）" % (IN['pic_zone_name'], IN['pic_world_name']))

	def onInit( self ):
		global IN
		self.updatePicJson()

		# 画像更新用スレッド
		ImageThread = threading.Thread(target=self.updateImageThread,args=(''))
		ImageThread.setDaemon(True)
		ImageThread.start()

def main():
	global IN

	if __mode__ == "0":
		xbmcplugin.endOfDirectory(handle = int(sys.argv[1]), succeeded = False)
		ui = GUI(__interface_file__ , __settings__.getAddonInfo('path'), "Default")
		ui.doModal()
		del ui

		# スレッド死活確認
		CheckTime = int(time.time())
		while True:

			try: result = json.loads(xbmc.executeJSONRPC('{"jsonrpc": "2.0", "method": "JSONRPC.Version", "id": 1}'))
			except: break
			if "error" in result or xbmcgui.getCurrentWindowId() < 13000:
				IN[ 'close_sequence' ] = 1
				#sys.exit()
				break

			if CheckTime < int(time.time()):
				CheckTime = CheckTime + 1
			xbmc.sleep(10)

	elif __mode__ == "1":
		try: response = urllib2.urlopen(__2d_json_url__)
		except: return 1
		j = response.read()
		p = re.compile(r'.+\,\"URL2\"\:\"(.+)\"\}\]\,.+')
		m = p.search(j)
		if m.group(1):
			xbmc.Player().play(__2d_youtube_url__ + m.group(1))
			while True:
				xbmc.sleep(500)
				if xbmc.Player().isPlayingVideo():
					xbmc.executebuiltin("Action(AspectRatio)")
					xbmc.executebuiltin("Action(AspectRatio)")
					xbmc.executebuiltin("Action(AspectRatio)")
					xbmc.executebuiltin("Action(AspectRatio)")
					xbmc.executebuiltin("Action(AspectRatio)")
					break

	elif __mode__ == "2":
		# 3D再生形式のダイアログを自動表示しない
		query = '{"jsonrpc":"2.0","method":"Settings.SetSettingValue","params":{"setting":"videoplayer.stereoscopicplaybackmode","value":1},"id":1}'
		result = xbmc.executeJSONRPC(query)

		# 3D再生形式の選択を自動的になしに戻さない
		query = '{"jsonrpc":"2.0","method":"Settings.SetSettingValue","params":{"setting":"videoplayer.quitstereomodeonstop","value":false},"id":1}'
		result = xbmc.executeJSONRPC(query)

		# 3D再生形式が設定されていなければ、自動的にアナグラフ形式にする。
		query = '{"jsonrpc":"2.0","method":"Settings.GetSettingValue","params":{"setting":"videoscreen.stereoscopicmode"},"id":1}'
		result = xbmc.executeJSONRPC(query)
		rjson = json.loads(result)
		if not rjson['result'].has_key('value') or rjson['result']['value'] == 0:
			query = '{"jsonrpc":"2.0","method":"Settings.SetSettingValue","params":{"setting":"videoscreen.stereoscopicmode","value":3},"id":1}'
			result = xbmc.executeJSONRPC(query)

		try: response = urllib2.urlopen(__2d_json_url__)
		except: return 1
		j = response.read()
		response.close
		p = re.compile(r'.+\,\"URL\"\:\"(.+)\"\,\"URL2\"\:\".+')
		m = p.search(j)

		if m.group(1):
			xbmc.Player().play(__2d_youtube_url__ + m.group(1))
			tmpurl = xbmc.Player().getPlayingFile()
			while True:
				tit  = xbmc.getInfoLabel("Player.Title")
				thum = xbmc.getInfoLabel("Player.Art(thumb)")
				if xbmc.Player().isPlayingVideo() and tit:
					xbmc.Player().stop()
					break
				xbmc.sleep(1)

			url = tmpurl.replace('index.m3u8', 'index.3D.SBS.m3u8')
			li = xbmcgui.ListItem(tit, "", thum, thum, url)
			xbmc.Player().play(url, li)

#-------------------------------------------------------------------------------
if __name__  == '__main__': main()
