# -*- coding: utf-8 -*-
import plugintools,xbmcplugin,xbmc,xbmcgui,urlresolver,hadlfa
import os, hadlfa

# Plugin Info
__addonname__="Hdlafa.net"

# Thumbnails for item list
SEARCH_ICON     = os.path.join(plugintools.get_runtime_path(), 'resources', 'images', 'search.png')
ARCHIVE_ICON    = os.path.join(plugintools.get_runtime_path(), 'resources', 'images', 'archive.png')
MOVIE_ICON      = os.path.join(plugintools.get_runtime_path(), 'resources', 'images', 'movie.png')
UPDATE_ICON     = os.path.join(plugintools.get_runtime_path(), 'resources', 'images', 'update.png')
COVER           = os.path.join(plugintools.get_runtime_path(), 'fanart.jpg')
SESSION_ICON    = os.path.join(plugintools.get_runtime_path(), 'Session.png')

def get_shows():
    plugintools.add_item(title=u'[B][COLOR white]סרטים[/COLOR][/B]' , action='movies', thumbnail=MOVIE_ICON)
    plugintools.add_item(title=u'[B][COLOR white]סדרות[/COLOR][/B]', action='session', thumbnail=ARCHIVE_ICON)
    plugintools.add_item(title=u'[B][COLOR red]לוח עדכוני עליית תוכן[/COLOR][/B]', action='update', thumbnail=UPDATE_ICON)
    plugintools.add_item(title=u'[B][COLOR white]חיפוש[/COLOR][/B]' ,action='search', thumbnail=SEARCH_ICON)
    plugintools.close_item_list()

def get_session():
    results = hadlfa.getsession()
    for series in results:
        plugintools.add_item(title=series.get('title'),
                             action='showepisode',
                             url=series.get('url'),
                             thumbnail=SESSION_ICON)
    plugintools.close_item_list()

def get_movie():
    results = hadlfa.getMovie()
    for series in results:
        plugintools.add_item(title=series.get('title'),
                             action='showparts',
                             url=series.get('url'),
                             thumbnail=series.get('thumbnail'))
    plugintools.close_item_list()

def get_search():
    searchtext=""
    keyboard = xbmc.Keyboard(searchtext,u'הקלד שם של סדרה או סרט')
    keyboard.doModal()
    if (keyboard.isConfirmed()):
        results = hadlfa.GetSearch(keyboard.getText())
        for series in results:
            plugintools.add_item(title=series.get('title'),
                                 action='showparts',
                                 url=series.get('url'),
                                 thumbnail=series.get('thumbnail'))
        plugintools.close_item_list()

def get_update():
    updates = hadlfa.GetUpdate()
    for update in updates:
        plugintools.add_item(title=update.get('title'),
                             action='showparts',url=update.get('url'),
                             thumbnail=update.get('thumbnail'))
    plugintools.close_item_list()

def get_parts(url, thumbnail):
        partsList = hadlfa.GetParts(url)
        if partsList == None:
            xbmcgui.Dialog().ok(__addonname__, "[COLOR red]Error 404 File Not Found[/COLOR]")
        else:
            for part in partsList:
                plugintools.add_item(title=part.get('title'),
                                     thumbnail=thumbnail,
                                     action='play',
                                     url=part.get('url'))
            plugintools.close_item_list()

def get_episode(url):
    results = hadlfa.GetEpisode(url)
    for series in results:
        plugintools.add_item(title=series.get('title'),
                             action='showparts',
                             url=series.get('url'),
                             thumbnail=series.get('thumbnail'))
    plugintools.close_item_list()

def playVideo(url,title,thumbnail):
    url = hadlfa.getStreamUrl(url)
    print url
    if url and not '.f4mTester' in url:
        li = xbmcgui.ListItem(label=title,
                              iconImage=thumbnail,
                              thumbnailImage=thumbnail,
                              path=url)
        li.setInfo(type='Video',
                   infoLabels={"Title": str(title)})
        xbmc.Player().play(url, li)
    elif url:
        xbmc.executebuiltin('XBMC.RunPlugin('+url+')')
    else:
        xbmcgui.Dialog().ok(__addonname__, "[COLOR red]Error 404 File Not Found[/COLOR]")

def run():
    params = plugintools.get_params()
    action = params.get('action')
    print params.get('title')
    if action == None:
        get_shows()
    elif action == 'session':
        get_session()
    elif action == 'movies':
        get_movie()
    elif action == 'search':
        get_search()
    elif action == 'update':
        get_update()
    elif action == 'showepisode':
        get_episode(params.get('url'))
    elif action == 'showparts':
        get_parts(params.get('url'), params.get('thumbnail'))
    elif action == 'play':
        playVideo(params.get('url'), params.get('title'), params.get('thumbnail'))

run()