# -*- coding: utf-8 -*-
import requests,re
from bs4 import BeautifulSoup
import urllib2,json,urllib
import resources.cfscrape as cfscrape
maxVideoQuality="1080"

def GetSearch(query):
    requests_flare = cfscrape.create_scraper()
    r = requests_flare.get("http://www.hadlafa.net/?s=" + query)
    r.encoding = 'utf-8'
    soup = BeautifulSoup(r.text, 'html5lib')
    results = soup.findAll('div', {'class': 'blog-item-wrap'})
    pages = soup.findAll('a', {'class': 'page-numbers'})
    for num in pages:
        try:
            numberpage = int(num.text)
        except:
            pass
        else:
            r = requests_flare.get("http://www.hadlafa.net/page/%d?s=%s" % (numberpage, query))  # or post()
            r.encoding = 'utf-8'
            soup = BeautifulSoup(r.text, 'html5lib')
            results += soup.findAll('div', {'class': 'blog-item-wrap'})

    resultsList = []
    for result in results:
        if ((result.text).replace('\n', '')) == u'ארכיון הסדרות של הדלפה  ' or \
                        ((result.text).replace('\n', '')) == u'ימים ושעות שידור – סדרות ישראליות  ':
            pass
        elif result.find('a') != None:
            resultsList.append({'title': (result.text).replace('\n', ''),
                                'url': result.find('a').get('href'),
                                'thumbnail': result.find('img').get('src')})
    return resultsList

def GetParts(url):
    requests_flare = cfscrape.create_scraper()
    r = requests_flare.get(url)
    r.encoding = 'utf-8'
    soup = BeautifulSoup(r.text, 'html5lib')
    results = soup.findAll('div', {'class': 'entry-content'})
    partsList = []
    count = 0
    for index in results:
            try:
                link=(index.findAll('iframe'))
                if len(link) > 0:
                    for iframe in index.findAll('iframe'):
                            partsList.append({'title': u'חלק ' + str(count + 1), 'url': iframe.get("src")})
                            count = count + 1

                link2=index.findAll('script', {'type': "text/javascript"})
                if len(link2) > 0:
                    for script in link2:
                        m3u8link = re.search(r"(http://).*(/)[^/]*\.m3u8", str(script)).group()
                        partsList.append({'title': u'חלק ' + str(count + 1), 'url': m3u8link})
                        count = count + 1
            except:
                pass
    return partsList

def getMovie():
    requests_flare = cfscrape.create_scraper()
    r = requests_flare.get("http://www.hadlafa.net/search/label/%D7%A1%D7%A8%D7%98%D7%99%D7%9D")  # or post()
    r.encoding = 'utf-8'
    soup = BeautifulSoup(r.text, 'html5lib')
    results = soup.findAll('div', {'class': 'blog-item-wrap'})
    resultsList = []
    for result in results:
        if ((result.text).replace('\n', '')) == u'ארכיון הסדרות של הדלפה  ' or \
                        ((result.text).replace('\n', '')) == u'ימים ושעות שידור – סדרות ישראליות  ':
            pass
        elif result.find('a') != None:
            resultsList.append({'title': (result.text).replace('\n', ''),
                                'url': result.find('a').get('href'),
                                'thumbnail': result.find('img').get('src')})
    return resultsList

def getsession():
    url = "http://www.hadlafa.net/"
    requests_flare = cfscrape.create_scraper()
    r = requests_flare.get(url)  # or post()
    r.encoding = 'utf-8'
    soup = BeautifulSoup(r.text, 'html5lib')
    updates = soup.findAll('ul', {'aria-labelledby': 'dropdownMenu1'})
    sessionlist = []
    for update in updates[2:]:
        for session in update:
            try:
                sessionlist.append({'title': session.text, 'url': "http://www.hadlafa.net%s" % (session.find('a').get('href'))})
            except:
                pass
    return sessionlist

def getUrl2(url):
    req = urllib2.Request(url)
    req.add_header('User-Agent', 'Mozilla/5.0 (Windows NT 6.1; rv:22.0) Gecko/20100101 Firefox/22.0')
    req.add_header('Cookie', "lang=en_EN")
    response = urllib2.urlopen(req)
    link = response.read()
    response.close()
    return link

def getStreamUrl(url, live=False):
    if ".m3u8" in url:
        return url
    elif "dailymotion" in url:
        id = (url.strip("http://www.dailymotion.com/embed/video/")).split("?")[0]
        return "plugin://plugin.video.dailymotion_com/?url=%s&mode=playVideo"%(id)
    elif "wistia" in url:
        regex = r"https?://(embed-ssl\.wistia\.com)/(deliveries)/(\w+).(bin)"
        r = requests.get(url)
        r.encoding = 'utf-8'
        soup = BeautifulSoup(r.text, 'html5lib')
        wistia = soup.findAll('script')
        wistialist = str(wistia[2])
        return "https://embedwistia-a.akamaihd.net/deliveries/%s/file.mp4" % (re.findall(regex, wistialist)[0][2])

    elif "youtube" in url:
        regex = r"^https://www.youtube.com/embed\/(.*)\?rel=0&autoplay=1$"
        return "plugin://plugin.video.youtube/?path=/root/video&action=play_video&videoid=%s"%(re.search(regex, url).group(1))
def GetUpdate():
    url = "https://www7.cbox.ws/box/?boxid=814543&boxtag=zaibf3&sec=main"
    requests_flare = cfscrape.create_scraper()
    r = requests_flare.get(url)  # or post()
    r.encoding = 'utf-8'
    soup = BeautifulSoup(r.text, 'html5lib')
    updates = soup.findAll('td', {'class': 'msg'})
    updatelist =[]
    for update in updates:
        try:
            updatelist.append({'title': update.text, 'url': update.find('a').get("href"),'thumbnail': update.find('img').get('src')})
        except:
            pass
    return updatelist

def GetEpisode(url):
    requests_flare = cfscrape.create_scraper()
    r = requests_flare.get(url)
    r.encoding = 'utf-8'
    soup = BeautifulSoup(r.text, 'html5lib')
    results = soup.findAll('div', {'class': 'blog-item-wrap'})
    pages = soup.findAll('a', {'class': 'page-numbers'})
    for num in pages:
        try:
            numberpage = int(num.text)
        except:
            pass
        else:
            r = requests_flare.get("%s/page/%d" % (url,numberpage))  # or post()
            r.encoding = 'utf-8'
            soup = BeautifulSoup(r.text, 'html5lib')
            results += soup.findAll('div', {'class': 'blog-item-wrap'})

    resultsList = []
    for result in results:
        if ((result.text).replace('\n', '')) == u'ארכיון הסדרות של הדלפה  ' or \
                        ((result.text).replace('\n', '')) == u'ימים ושעות שידור – סדרות ישראליות  ':
            pass
        elif result.find('a') != None:
            resultsList.append({'title': (result.text).replace('\n', ''),
                                'url': result.find('a').get('href'),
                                'thumbnail': result.find('img').get('src')})
    return resultsList