import time, os, hashlib, random
import urllib, urllib2, json
import xbmc, xbmcaddon
from cookielib import LWPCookieJar
import common, log_utils, traceback

_API_URL = 'https://www.vadapi.com/api/'
_API_VERSION = 2

EMAIL = ''
AUTH_HASH = ''
DEVICE_UUID = ''

onError = None

_ADDON = xbmcaddon.Addon()
_PROJECT_NAME = 'Plugin Kodi'
_PROJECT_VERSION = _ADDON.getAddonInfo('version')
_USER_AGENT = 'Kodi %s; %s; Plugin v%s' % (xbmc.getInfoLabel('System.BuildVersion').split(' ')[0], common.getPlatform(), _PROJECT_VERSION)
_LOGIN_COOKIE_FILE = os.path.join(xbmc.translatePath(_ADDON.getAddonInfo('profile')), 'login_cookie')


def raiseError(message):
    if onError:
        onError(message)


def getAuthHash(email, password):
    pwd_md5 = hashlib.md5(password).hexdigest()
    return hashlib.sha256(email + pwd_md5).hexdigest()


def _apiRequest(method, params=None, raise_error=True):
    params = {} if not params else params
    params['v'] = _API_VERSION
    params['u'] = EMAIL
    params['p'] = AUTH_HASH
    params = urllib.unquote_plus(urllib.urlencode(params))
    
    cj = LWPCookieJar()
    if os.path.isfile(_LOGIN_COOKIE_FILE):
        cj.load(_LOGIN_COOKIE_FILE, ignore_discard=True)
    opener = urllib2.build_opener(urllib2.HTTPCookieProcessor(cj))
    urllib2.install_opener(opener)
    
    req = urllib2.Request(_API_URL + method, params)
    req.add_header('User-Agent', _USER_AGENT)
    
    try:
        conn = urllib2.urlopen(req)
        
        if conn.code != 200:
            conn.close()
            raise Exception()
        
        response = conn.read()
        conn.close()
        response = json.loads(response)
        
        if not response['api_status_general']:
            raise Exception()
        
        if int(response['status']) == 0 and raise_error:
            raise Exception(response['status_message'])
        
        cj.save(_LOGIN_COOKIE_FILE, ignore_discard=True)
        
        return response
    
    except Exception as ex:
        message = ex.message if ex.message else 'Eroare de conexiune sau server indisponibil.'
        log_utils.log(traceback.print_exc())
        raiseError(message)


def login(email, auth_hash):
    global EMAIL
    global AUTH_HASH
    EMAIL = email
    AUTH_HASH = auth_hash
    params = {
        's': DEVICE_UUID,
        'pn': _PROJECT_NAME,
        'pv': _PROJECT_VERSION
    }
    _apiRequest('login', params)


def logout():
    _apiRequest('logout', raise_error=False)
    if os.path.isfile(_LOGIN_COOKIE_FILE):
        os.remove(_LOGIN_COOKIE_FILE)


def _apiCall(method, params=None):
    for try_num in [1, 2]:
        response = _apiRequest(method, params, try_num != 1)
        if response and int(response['status']) > 0:
            return response
        login(EMAIL, AUTH_HASH)
        time.sleep(0.5)


def getCategories():
    response = _apiCall('categories')['category']
    return sorted(response.iteritems(), key=lambda item: item[1])


def getTVChannels(categoryId=None):
    all_channels = _apiCall('app')['channels']
    
    if not categoryId:
        return all_channels
    
    channels = []
    
    for channel in all_channels:
        cats = [int(c) for c in channel['category_ids'].split(',')]
        if int(categoryId) not in cats:
            continue
        channels.append(channel)
    
    return channels


def getStreamURL(id):
    def random_number():
        return str(random.randint(10 ** (10 - 1), 10 ** 10 - 1))
    
    params = {'e': id, 'r': random_number()}
    response = _apiCall('stream', params)
    
    if response['subscriptionExpired']:
        raiseError('Abonamentul a expirat.')
    
    hls_url = response.get('stream_hls_url', None)

    if hls_url:
        return hls_url

    stream = '%s://%s/%s/%s' % (response['stream_type'], response['server'], response['app'], response['stream'])
    
    if stream.startswith('rtmp'):
        stream += ' timeout=10'
    
    return stream


def getAccountStatus():
    return _apiCall('status')['status_message']
