import sys, os
import xbmc, xbmcaddon, xbmcgui


addon = xbmcaddon.Addon()
addon_id = addon.getAddonInfo('id')
addon_version = addon.getAddonInfo('version')
addon_name = addon.getAddonInfo('name')
addon_path = xbmc.translatePath(addon.getAddonInfo('path'))
profile_path = xbmc.translatePath(addon.getAddonInfo('profile'))
cache_path = os.path.join(profile_path, 'cache')
addon_fullname = '%s v%s' % (addon_id, addon_version)

for folder in [profile_path, cache_path]:
    if not os.path.exists(folder):
        os.makedirs(folder)

def getSetting(settingId):
	return addon.getSetting(settingId)

def setSetting(settingId, value):
	addon.setSetting(settingId, value)

def okDialog(title, message):
    title = '%s - %s' % (addon_name, title) if title else addon_name
    return xbmcgui.Dialog().ok(title, message)

def notify(message,duration=3000):
    icon = os.path.join(addon_path, 'resources', 'media', 'info_icon.png')
    xbmc.executebuiltin('Notification(%s, %s, %d, %s)' % (addon_name, message, duration, icon))

def createProgress(title, message):
    title = '%s - %s' % (addon_name, title) if title else addon_name
    progress = xbmcgui.DialogProgress()
    progress.create(title, message)
    return progress

def getPlatform():
    platforms = ['Android', 'Linux', 'Windows', 'OS X', 'iOS']
    
    for platform in platforms:
        p = platform.replace(' ', '').lower()
        if xbmc.getCondVisibility('system.platform.%s' % p):
            return platform
    
    return 'Unknown OS'
