import sys, os, re, time, uuid, traceback
import urllib, urlparse
import xbmc, xbmcplugin, xbmcgui
import common, api, utils, tvguide, log_utils
from resources.lib import b64

script_start = time.time()

PARAMS = dict(urlparse.parse_qsl(sys.argv[2].replace('?','')))

MODE = int(PARAMS.get('mode', 0))
PARAM = PARAMS.get('param', '')
NAME = PARAMS.get('name', '')
THUMBNAIL = PARAMS.get('thumbnail', '')
CHANNEL_ID = PARAMS.get('channel_id', '')
PARENTAL = int(PARAMS.get('parental', 0))

if MODE == 99:
    api.logout()
    common.setSetting('email', '')
    common.setSetting('auth_hash', '')
    xbmc.executebuiltin('Action(Back)')
    sys.exit()


if MODE in (20, 10) and PARENTAL > 0:
    kb = xbmc.Keyboard('', 'Reintroduceti parola')
    kb.setHiddenInput(True)
    kb.doModal()
    if not kb.isConfirmed() or not kb.getText():
        sys.exit()
    email = b64.decode(common.getSetting('email'))
    if api.getAuthHash(email, kb.getText()) != common.getSetting('auth_hash'):
        common.notify('Parola incorecta.')
        sys.exit()


if MODE == 20:
    progress = common.createProgress('Cautare Program TV', 'Asteptati...')

    tvchannel = re.sub(r'\(\d+p\)', r'', NAME).strip()

    try:
        info = tvguide.getTVGuide(tvchannel)
    except:
        progress.close()
        common.notify('Eroare la obtinerea programului TV.')
        log_utils.log(traceback.print_exc())
        sys.exit()
    
    if not info:
        progress.close()
        common.notify('Programul TV nu a fost gasit.')
        sys.exit()
    
    items = []

    x = False
    y = 0
    for i in xrange(len(info)):
        item = info[i][0] + ' ' * 5 + info[i][1]
        if info[i][2]:
            item = '[COLOR red]' + item + '[/COLOR]'
            x = True
            y = i
        items.append(item)

    if x:
        items = items[y:]

    progress.close()

    if not progress.iscanceled():
        xbmcgui.Dialog().select('%s - Program TV: %s' % (common.addon_name, tvchannel), items)

    sys.exit()


api.onError = lambda message: (
    log_utils.log(message),
    xbmcplugin.endOfDirectory(int(sys.argv[1])),
    common.okDialog('Eroare', message),
    sys.exit()
)


if not common.getSetting('device_uuid'):
    device_uuid = uuid.uuid1()
    if not device_uuid:
        device_uuid = uuid.uuid4()
    device_uuid = device_uuid.hex[-12:-2].upper()
    common.setSetting('device_uuid', device_uuid)


def loggedIn():
    return common.getSetting('email') and common.getSetting('auth_hash')


def login():    
    loginData = []
    
    req_data = {0: 'E-mail', 1: 'Parola'}    
    for i in range(len(req_data)):
        kb = xbmc.Keyboard('', 'LOGIN: ' + req_data[i])
        if i == 1:
            kb.setHiddenInput(True)
        kb.doModal()
        if not kb.isConfirmed():
            return
        
        text = kb.getText()
        
        if not text:
            common.okDialog('', 'Date insuficiente pentru login.')
            return
        
        loginData.append(text)
    
    progress = common.createProgress('Login', 'Asteptati...')
    
    auth_hash = api.getAuthHash(loginData[0], loginData[1])
    
    api.login(loginData[0], auth_hash)
    
    progress.close()
    
    common.setSetting('email', b64.encode(loginData[0]))
    common.setSetting('auth_hash', auth_hash)


def main():
    addDir('Toate Canalele', '', 1, 'tv_icon.png')
    addDir('Categorii', '', 2, 'categories_icon.png')
    addDir('Stare Cont', '', 98, 'account_info_icon.png', False)
    if loggedIn():
        addDir('Logout', '', 99, 'logout_icon.png', False)
    
    xbmcplugin.endOfDirectory(int(sys.argv[1]))
    xbmc.executebuiltin('Container.SetViewMode(500)')


def categories():
    categories = api.getCategories()
    
    for category in categories:
        addDir(category[1], category[0], 1, getCategoryIcon(category[0]), totalItems=len(categories))
    
    xbmcplugin.endOfDirectory(int(sys.argv[1]))
    xbmc.executebuiltin('Container.SetViewMode(500)')


def TVChannels(categoryId=None):
    channels = api.getTVChannels(categoryId)
    total = len(channels)
    
    for channel in channels:
        addChannel(
            channel['name'],
            channel['e'],
            channel['img_url'],
            channel['quality'],
            int(channel['parental']),
            total
        )
    
    xbmcplugin.endOfDirectory(int(sys.argv[1]))
    xbmc.executebuiltin('Container.SetViewMode(500)')


def playStream(id, name, thumbnail):
    progress = common.createProgress(name, 'Conectare...')
    
    stream = api.getStreamURL(id)
    
    if progress.iscanceled():
        return
    
    liz = xbmcgui.ListItem(name, iconImage=thumbnail, thumbnailImage=thumbnail)
    liz.setInfo('Video', {'title': name})
    
    player = xbmc.Player()
    
    while True:
        if not player.isPlaying():
            break
        player.stop()
        time.sleep(0.5)
    
    progress.close()
    
    if not progress.iscanceled():
        player.play(stream, liz)


def addDir(name,param,mode,thumbnail='',folder=True,totalItems=0):
    listitem = xbmcgui.ListItem()
    listitem.setLabel(name)
    if thumbnail:
        thumbnail = os.path.join(common.addon_path, 'resources', 'media', thumbnail)
    else:
        thumbnail = 'DefaultFolder.png' if folder else 'DefaultVideo.png'
    listitem.setIconImage(thumbnail)
    listitem.setThumbnailImage(thumbnail)
    listitem.setProperty('fanart_image', os.path.join(common.addon_path, 'fanart.jpg'))
    
    params = {'name': name, 'mode': mode, 'thumbnail': thumbnail, 'param': param}
    
    u = sys.argv[0] + '?' + urllib.urlencode(params)
    
    return xbmcplugin.addDirectoryItem(int(sys.argv[1]), u, listitem, folder, totalItems)


def addChannel(name,id,thumbnail,quality,parental=0,totalItems=0):
    label = '%s (%s)' % (name, quality)
    listitem = xbmcgui.ListItem()
    listitem.setLabel(label)
    listitem.setIconImage(thumbnail)
    listitem.setThumbnailImage(thumbnail)
    listitem.setProperty('fanart_image', os.path.join(common.addon_path, 'fanart.jpg'))    
    listitem.setInfo('Video', {'title': name})
    
    contextMenuItems = []
    params = {'name': name, 'mode': 20, 'parental': parental}
    u = sys.argv[0] + '?' + urllib.urlencode(params)
    contextMenuItems.append(('Program TV', 'XBMC.RunPlugin(%s)' % u))
    listitem.addContextMenuItems(contextMenuItems)
    
    params = {}
    params['name'] = name
    params['channel_id'] = id
    params['parental'] = parental
    params['mode'] = 10
    params['thumbnail'] = thumbnail
    
    u = sys.argv[0] + '?' + urllib.urlencode(params)
    
    return xbmcplugin.addDirectoryItem(int(sys.argv[1]), u, listitem, False, totalItems)


def getCategoryIcon(id):
    icon_filename = 'category_%s_icon.png' % id
    media_path = os.path.join(common.addon_path, 'resources', 'media')
    icon_path = os.path.join(media_path, icon_filename)
    if not os.path.exists(icon_path):
        return os.path.join(media_path, 'category_icon.png')
    return icon_path


if not loggedIn():
    login()

api.EMAIL = b64.decode(common.getSetting('email'))
api.AUTH_HASH = common.getSetting('auth_hash')
api.DEVICE_UUID = common.getSetting('device_uuid')

if MODE == 0:
    main()

elif MODE == 1:
    TVChannels(PARAM)

elif MODE == 2:
    categories()

elif MODE == 10:
    playStream(CHANNEL_ID, NAME, THUMBNAIL)

elif MODE == 98:
    progress = common.createProgress('', 'Asteptati...')
    common.okDialog('Stare Cont', api.getAccountStatus())
    progress.close()


script_end = time.time() - script_start

log_utils.log('Script successfully executed in %f seconds.' % (script_end), log_utils.LOGDEBUG)
