# -*- coding: utf-8 -*-
'''
    Torrenter v2 plugin for XBMC/Kodi
    Copyright (C) 2012-2015 Vadim Skorba v1 - DiMartino v2
    http://forum.kodi.tv/showthread.php?tid=214366

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import urllib
import re
import sys
import xbmcaddon
import os
import socket

import SearcherABC


class RuTrackerOrg(SearcherABC.SearcherABC):

    __torrenter_settings__ = xbmcaddon.Addon(id='plugin.video.torrenter')
    #__torrenter_language__ = __settings__.getLocalizedString
    #__torrenter_root__ = __torrenter_settings__.getAddonInfo('path')

    ROOT_PATH=os.path.dirname(__file__)
    addon_id=ROOT_PATH.replace('\\','/').rstrip('/').split('/')[-1]
    __settings__ = xbmcaddon.Addon(id=addon_id)
    __addonpath__ = __settings__.getAddonInfo('path')
    __version__ = __settings__.getAddonInfo('version')
    __plugin__ = __settings__.getAddonInfo('name').replace('Torrenter Searcher: ','') + " v." + __version__

    username = __settings__.getSetting("username")
    password = __settings__.getSetting("password")
    baseurl = 'rutracker.org'

    '''
    Setting the timeout
    '''
    torrenter_timeout_multi=int(sys.modules["__main__"].__settings__.getSetting("timeout"))
    timeout_multi=int(__settings__.getSetting("timeout"))

    '''
    Weight of source with this searcher provided. Will be multiplied on default weight.
    '''
    sourceWeight = 2

    '''
    Full path to image will shown as source image at result listing
    '''
    searchIcon = os.path.join(__addonpath__,'icon.png')

    '''
    Flag indicates is this source - magnet links source or not.
    '''
    @property
    def isMagnetLinkSource(self):
        return False

    '''
    Main method should be implemented for search process.
    Receives keyword and have to return dictionary of proper tuples:
    filesList.append((
        int(weight),# Calculated global weight of sources
        int(seeds),# Seeds count
        int(leechers),# Leechers count
        str(size),# Full torrent's content size (e.g. 3.04 GB)
        str(title),# Title (will be shown)
        str(link),# Link to the torrent/magnet
        str(image),# Path to image shown at the list
    ))
    '''

    def __init__(self):
        self.logout()

        if self.timeout_multi==0:
            socket.setdefaulttimeout(10+(10*self.torrenter_timeout_multi))
        else:
            socket.setdefaulttimeout(10+(10*(self.timeout_multi-1)))

        if self.__settings__.getSetting("usemirror")=='true':
            self.baseurl = self.__settings__.getSetting("baseurl")

        #self.debug=self.log

    def logout(self):
        old_username = self.__settings__.getSetting("old_username")
        if old_username in [None,''] or old_username!=self.username:
            self.__settings__.setSetting("old_username", self.username)
            self.clear_cookie(self.baseurl)
            self.login()

    def search(self, keyword):
        filesList = []
        url = 'http://%s/forum/tracker.php?nm=%s' %(self.baseurl, urllib.quote_plus(keyword))

        data = {'prev_my': '0',
                'prev_new': '0',
                'prev_oop': '0',
                'o': '10',
                's': '2',
                'f[]': '-1',
                'nm': keyword}

        response = self.makeRequest(url, data=data)
        if None != response and 0 < len(response):
            response = response.decode('cp1251').encode('utf8')
            # print response
            if not self.check_login(response):
                response = self.makeRequest(url, data=data)
                response = response.decode('cp1251').encode('utf8')
            # print response
            forums = [7, 187, 2090, 2221, 2091, 2092, 2093, 934, 505, 212, 2459, 1235, 185, 22, 941, 1666, 124, 1543,
                      376, 709, 1577, 511, 656, 93, 905, 1576, 101, 100, 103, 572, 1670, 2198, 2199, 313, 2201, 312,
                      2339, 314, 352, 549, 1213, 2109, 514, 2097, 4, 930, 2365, 1900, 521, 2258, 208, 539, 209, 484,
                      822, 921, 922, 1247, 923, 924, 1991, 925, 1165, 1245, 928, 926, 1246, 1250, 927, 1248, 33, 281,
                      1386, 1387, 1388, 282, 599, 1105, 1389, 404, 1390, 1642, 1391, 893, 1478, 670, 2107, 294, 1453,
                      1475, 46, 2178, 671, 2177, 251, 97, 851, 821, 2076, 98, 56, 1469, 2123, 1280, 876, 752, 1114,
                      2380, 1467, 672, 249, 552, 500, 2112, 1327, 1468, 24, 1959, 115, 939, 1481, 113, 882, 1482, 393,
                      1569, 373, 1186, 137, 1321, 532, 979, 827, 1484, 1485, 114, 1332, 1495, 255, 256, 1986, 1551, 626,
                      262, 1326, 978, 1287, 1188, 1667, 1675, 257, 845, 875, 263, 2073, 550, 2124, 1470, 528, 486, 854,
                      2079, 260, 2111, 1608, 1952, 1613, 1614, 1623, 1615, 1630, 2514, 1616, 2014, 1617, 1987, 2171,
                      1620, 1621, 1998, 751, 1697, 2004, 2001, 2002, 283, 1997, 2003, 2009, 2010, 2006, 2007, 2005, 259,
                      2008, 126, 9, 104, 1535, 91, 1356, 856, 188, 1408, 310, 202, 935, 990, 80, 119, 1530, 175, 79,
                      172, 812, 207, 805, 123, 189, 271, 273, 743, 184, 842, 194, 1605, 85, 1144, 595, 1288, 1171, 1694,
                      1690, 820, 819, 625, 84, 242, 623, 1417, 1798, 106, 166, 236, 507, 504, 536, 173, 918, 920, 203,
                      1243, 1120, 140, 636, 606, 776, 235, 1499, 81, 266, 252, 1102, 1449, 196, 372, 110, 193, 1531,
                      237, 265, 181, 1214, 497, 121, 721, 1117, 1359, 387, 134, 195, 2366, 2390, 2391, 2392, 2407, 2393,
                      2370, 2394, 2408, 2395, 2396, 2397, 2398, 2399, 2400, 2401, 2402, 2403, 2404, 2405, 2406, 911,
                      1691, 704, 1493, 1500, 1574, 1940, 1539, 1939, 823, 1006, 972, 1299, 781, 717, 1300, 1803, 1298,
                      825, 1606, 1458, 1463, 1459, 1938, 1461, 718, 1498, 907, 877, 992, 607, 594, 775, 534, 1462, 904,
                      1460, 816, 815, 325, 1457, 1301, 1692, 1540, 694, 1949, 1678, 1541, 860, 1941, 1537, 2100, 2102,
                      2103, 1242, 2104, 610, 1542, 2335, 1544, 1545, 1546, 1549, 1597, 1552, 1550, 1568, 1553, 1554,
                      617, 1555, 2017, 1257, 1258, 2208, 677, 1255, 1479, 1261, 614, 1259, 2065, 1254, 1260, 2209, 2210,
                      1547, 1548, 2211, 615, 1581, 1590, 1587, 1594, 1591, 1588, 1596, 1585, 1586, 2078, 1929, 1593,
                      1592, 1595, 1556, 1560, 1561, 1653, 1570, 1654, 1655, 1656, 1930, 1931, 1932, 1562, 1563, 1626,
                      1564, 1565, 1559, 1566, 1573, 1567, 2491]
            regex = '''<tr class=.+?</tr>'''
            regex_tr = '<a class="gen f" href="tracker\.php\?f=(\d+)">.+? class=".+?" href="viewtopic\.php\?t=(\d+)">(.+?)</a>.+?<a .+?href="http://dl.+?">(.+?)</a>.+?<td class="row4 nowrap"><u>(.+?)</u>.+?class=".+?eechmed".+?(\d+)'
            for tr in re.compile(regex, re.DOTALL).findall(response):
                result=re.compile(regex_tr, re.DOTALL).findall(tr)
                self.debug(tr+' -> '+str(result))
                if result:
                    (forum, link, title, size, seeds, leechers) = result[0]
                    if int(forum) in forums and int(seeds)>0:
                        size = size.replace(' &#8595;','').replace('&nbsp;', ' ')
                        torrentTitle = title
                        image = self.searchIcon
                        link = 'http://dl.%s/forum/dl.php?t=%s' %(self.baseurl,link)
                        filesList.append((
                            int(int(self.sourceWeight) * int(seeds)),
                            int(seeds), int(leechers), size,
                            self.unescape(self.stripHtml(torrentTitle)),
                            self.__class__.__name__ + '::' + link,
                            image,
                        ))
        return filesList

    def getTorrentFile(self, url):
        self.load_cookie()
        cookie = None
        for cookie in self.cookieJar:
            if cookie.name == 'bb_data' and cookie.domain == '.%s' % (self.baseurl):
                cookie = 'bb_data=' + cookie.value# + '; bb_dl=' + re.search('(\d+)$', url).group(1)
                break
        if not cookie:
            cookie = self.login()# + '; bb_dl=' + re.search('(\d+)$', url).group(1)

        t = re.search('(\d+)$', url).group(1)
        referer = 'http://%s/forum/viewtopic.php?t=%s' %(self.baseurl, t)
        headers = [('Cookie', cookie), ('Referer', referer),
                   ('User-Agent', 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.101 YaBrowser/15.10.2454.3658 Safari/537.36'),
                   ('Origin', 'http://%s' % self.baseurl), ('Upgrade-Insecure-Requests', '1')]
        data = {
            't': t,
        }
        content = self.makeRequest(url, data=data, headers=headers)
        if not self.check_login(content):
            cookie = self.login() + '; bb_dl=' + re.search('(\d+)$', url).group(1)
            headers = [('Cookie', cookie), ('Referer', referer)]
            content = self.makeRequest(url, data=data, headers=headers)
        return self.saveTorrentFile(url, content)

    def check_login(self, response=None):
        if None != response and 0 < len(response):
            if re.compile('<input type="text" name="login_username"').search(response):
                self.log('Not logged!')
                self.login()
                return False
        return True

    def login(self):
        pageContent = self.makeRequest('http://login.%s/forum/login.php' % (self.baseurl))
        captchaMatch = re.compile(
            '(http://static\.'+self.baseurl.replace('.','\.')+'/captcha/\d+/\d+/[0-9a-f]+\.jpg\?\d+).+?name="cap_sid" value="(.+?)".+?name="(cap_code_[0-9a-f]+)"',
            re.DOTALL | re.MULTILINE).search(pageContent)
        data = {
            'login_password': self.password,
            'login_username': self.username,
            'login': '%C2%F5%EE%E4',
            'redirect': 'index.php'
        }
        if captchaMatch:
            captchaCode = self.askCaptcha(captchaMatch.group(1))
            if captchaCode:
                data['cap_sid'] = captchaMatch.group(2)
                data[captchaMatch.group(3)] = captchaCode
            else:
                return False
        self.makeRequest(
            'http://login.%s/forum/login.php' % self.baseurl,
            data
        )
        self.cookieJar.save(ignore_discard=True)
        for cookie in self.cookieJar:
            if cookie.name == 'bb_data':
                return 'bb_data=' + cookie.value
        return False