# -*- coding: utf-8 -*-
'''
    Torrenter v2 plugin for XBMC/Kodi
    Copyright (C) 2012-2015 Vadim Skorba v1 - DiMartino v2
    http://forum.kodi.tv/showthread.php?tid=214366

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import urllib
import re
import sys
import xbmcaddon
import os
import socket

import SearcherABC


class TorrentsIIID(SearcherABC.SearcherABC):

    __torrenter_settings__ = xbmcaddon.Addon(id='plugin.video.torrenter')
    #__torrenter_language__ = __settings__.getLocalizedString
    #__torrenter_root__ = __torrenter_settings__.getAddonInfo('path')

    ROOT_PATH=os.path.dirname(__file__)
    addon_id=ROOT_PATH.replace('\\','/').rstrip('/').split('/')[-1]
    __settings__ = xbmcaddon.Addon(id=addon_id)
    __addonpath__ = __settings__.getAddonInfo('path')
    __version__ = __settings__.getAddonInfo('version')
    __plugin__ = __settings__.getAddonInfo('name').replace('Torrenter Searcher: ','') + " v." + __version__

    username = __settings__.getSetting("username")
    password = __settings__.getSetting("password")
    adult_content = __settings__.getSetting("adult_content")
    baseurl = 'torrents3d.ru'

    '''
    Setting the timeout
    '''
    torrenter_timeout_multi=int(sys.modules["__main__"].__settings__.getSetting("timeout"))
    timeout_multi=int(__settings__.getSetting("timeout"))

    '''
    Weight of source with this searcher provided. Will be multiplied on default weight.
    '''
    sourceWeight = 1

    '''
    Full path to image will shown as source image at result listing
    '''
    searchIcon = os.path.join(__addonpath__,'icon.png')

    '''
    Flag indicates is this source - magnet links source or not.
    '''
    @property
    def isMagnetLinkSource(self):
        return False

    '''
    Main method should be implemented for search process.
    Receives keyword and have to return dictionary of proper tuples:
    filesList.append((
        int(weight),# Calculated global weight of sources
        int(seeds),# Seeds count
        int(leechers),# Leechers count
        str(size),# Full torrent's content size (e.g. 3.04 GB)
        str(title),# Title (will be shown)
        str(link),# Link to the torrent/magnet
        str(image),# Path to image shown at the list
    ))
    '''

    def __init__(self):
        self.logout()

        if self.timeout_multi==0:
            socket.setdefaulttimeout(10+(10*self.torrenter_timeout_multi))
        else:
            socket.setdefaulttimeout(10+(10*(self.timeout_multi-1)))

        if self.__settings__.getSetting("usemirror")=='true':
            self.baseurl = self.__settings__.getSetting("baseurl")

        #self.debug=self.log

    def logout(self):
        old_username = self.__settings__.getSetting("old_username")
        if old_username in [None,''] or old_username!=self.username:
            self.__settings__.setSetting("old_username", self.username)
            self.clear_cookie(self.baseurl)
        self.login()

    def search(self, keyword):
        filesList = []
        url = 'http://%s/tracker.php' %(self.baseurl)

        data = {'prev_my': '0',
                'prev_new': '0',
                'prev_oop': '0',
                'o': '10',
                's': '2',
                'f[]': '-1',
                'nm': keyword}

        response = self.makeRequest(url, data=data)
        if None != response and 0 < len(response):
            response = response#.decode('cp1251').encode('utf8')
            self.debug(response)
            if not self.check_login(response):
                response = self.makeRequest(url, data=data)
                response = response#.decode('cp1251').encode('utf8')
            self.debug(response)
            bad_forums = [8, 33, 16, 34]
            adult_forum = [35]

            regex = '''<tr class=.+?</tr>'''
            regex_tr = '<a class="gen" href=http://'+self.baseurl.replace('.','\.')+'/section/(\d+)/ .+? href="http://'+self.baseurl.replace('.','\.')+'/article/(\d+)/"><b>(.+?)</b></a>.+?<a .+?href="\./download\.php\?id=(\d+)">(.+?)</a>.+?<td class=".+?seedmed" title=".+?"><b>(\d+)</b></td>.+?<td class=".+?leechmed" title=".+?"><b>(\d+)'
            for tr in re.compile(regex, re.DOTALL).findall(response):
                result=re.compile(regex_tr, re.DOTALL).findall(tr)
                self.debug(tr+' -> '+str(result))
                if result:
                    (forum, topic, title, link, size, seeds, leechers) = result[0]
                    if (int(forum) not in bad_forums) and (int(forum) not in adult_forum or self.adult_content=='true'):
                        size = size.replace(' &#8595;','').replace('&nbsp;', ' ')
                        torrentTitle = title
                        image = self.searchIcon
                        link = 'http://%s/download.php?id=%s&%s' %(self.baseurl, link, topic)
                        filesList.append((
                            int(int(self.sourceWeight) * int(seeds)),
                            int(seeds), int(leechers), size,
                            self.unescape(self.stripHtml(torrentTitle)),
                            self.__class__.__name__ + '::' + link,
                            image,
                        ))
        return filesList

    def getTorrentFile(self, url):
        self.timeout(5)

        referer = 'http://%s/forum/viewtopic.php?t=%s' % (self.baseurl, re.search('(\d+)$', url).group(1))
        self.log('[getTorrentFile] url: '+url)

        headers=[('Referer', referer)]
        content = self.makeRequest(url, headers=headers)

        if not self.check_login(content):
            content = self.makeRequest(url, headers=headers)

        return self.saveTorrentFile(url, content)

    def check_login(self, response=None):
        if None != response and 0 < len(response):
            if re.compile('<input type="text" name="login_username"').search(response):
                self.log('Not logged!')
                self.login()
                return False
        return True

    def login(self):
        pageContent = self.makeRequest('http://%s/login.php' % self.baseurl)
        captchaMatch = re.compile(
            '<img src="\.(/images/captcha/\d+/[0-9a-f]+\.jpg\?\d+)".+?name="cap_sid" value="(.+?)".+?name="(cap_code_[0-9a-f]+)"',
            re.DOTALL | re.MULTILINE).search(pageContent)
        data = {
            'login_password': self.password,
            'login_username': self.username,
            'login': '%C2%F5%EE%E4',
            'redirect': 'index.php'
        }
        if captchaMatch:
            captchaCode = self.askCaptcha(self.baseurl+captchaMatch.group(1))
            if captchaCode:
                data['cap_sid'] = captchaMatch.group(2)
                data[captchaMatch.group(3)] = captchaCode
            else:
                return False
        self.makeRequest(
            'http://%s/login.php' % self.baseurl,
            data
        )
        self.cookieJar.save(ignore_discard=True)
        for cookie in self.cookieJar:
            if cookie.name == 'bb_data' and cookie.domain=='.%s' % self.baseurl:
                return 'bb_data=' + cookie.value
        return False