#! /bin/csh -f
#
#  tibabb --  look up a journal and find the tib abbreviation for it 
#
#  Usage:  tibabb  < keys >...
#
#  Note: this is case sensitive if there is more than one word in the keys
#
if ($#argv == 1 && "$1" == -usage) then
  echo " Usage:  tibabb < keys > ..."
  exit 0
endif
switch ($#argv)
  case 0:
    echo " Usage:  tibabb < keys > ..."
    exit 1
  case 1:
    grep -i -h $1 BBBBB/*{abb,fll}.ttz|more
    breaksw
  default:
    set arg = `echo $* | sed 's, ,/ \&\& /,g'`
    awk "/$arg/" BBBBB/*{abb,fll}.ttz|more
endsw

