/*
    Copyright (C) 2013 Nicola L.C. Talbot
    www.dickimaw-books.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package com.dickimawbooks.texparserlib.latex.jmlr;

import java.io.IOException;
import java.util.Vector;

import com.dickimawbooks.texparserlib.*;
import com.dickimawbooks.texparserlib.latex.*;

public class AtJmlrIfGraphicxLoaded extends ControlSequence
{
   public AtJmlrIfGraphicxLoaded()
   {
      this("@jmlr@ifgraphicxloaded");
   }

   public AtJmlrIfGraphicxLoaded(String name)
   {
      super(name);
   }

   public Object clone()
   {
      return new AtJmlrIfGraphicxLoaded(getName());
   }

   public void process(TeXParser parser) throws IOException
   {
      process(parser, parser);
   }

   public void process(TeXParser parser, TeXObjectList stack) throws IOException
   {
      TeXObject arg1;
      TeXObject arg2;

      if (parser == stack)
      {
         arg1 = parser.popNextArg();
         arg2 = parser.popNextArg();
      }
      else
      {
         arg1 = stack.popArg(parser);
         arg2 = stack.popArg(parser);
      }

      LaTeXParserListener listener = (LaTeXParserListener)parser.getListener();
      TeXObject arg;

      if (listener.isStyLoaded("graphicx"))
      {
         arg = arg1;
      }
      else
      {
         arg = arg2;
      }

      if (parser == stack)
      {
         arg.process(parser);
      }
      else
      {
         arg.process(parser, stack);
      }
   }

}
