.PS
# ArrestersMan.m4
# https://tex.stackexchange.com/questions/733192/spark-gap-in-circuit-package-and-voltage-arrow-capacitor
cct_init

  sep = 0.2
  rsep = 0.15

R1: [
  arrester
  {`"\tt arrester"' at last line.c+(0,-0.2)}
  move sep
  arrester(,G)
  {`"\tt arrester(,G)"' at last line.c+(0,-0.2)}
  move sep
  arrester(,g)
  {`"\tt ...(,g)"' at last line.c+(0,-0.2)}
  move sep
  arrester(,M)
  {`"\tt \ldots(,M)"' at last line.c+(0,-0.2)}
  move sep
  arrester(,C)
  {`"\tt \ldots(,C)"' at last line.c+(0,-0.2)}
  move sep
  arrester(,A)
  {`"\tt \ldots(,A)"' at last line.c+(0,-0.2)}
  ]

R2: [
  arrester(,H)
  {`"\tt \ldots(,H)"' at last line.c+(0,-0.2)}
  move sep
  arrester(,HR)
  {`"\tt \ldots(,HR)"' at last line.c+(0,-0.2)}
  move sep
  arrester(,P)
  {`"\tt \ldots(,P)"' at last line.c+(0,-0.2)}
  move sep
  arrester(,s)
  {`"\tt \ldots(,s)"' at last line.c+(0,-0.2)}
  move sep
  arrester(,F)
  {`"\tt \ldots(,F)"' at last line.c+(0,-0.2)}
  move sep
  arrester(,S)
  {`"\tt \ldots(,S)"' at last line.c+(0,-0.2)}
  ] with .nw at R1.sw+(0,-rsep)

  define(`Dlabels',
  `{ thinlines_
    arrow <- from last [].A up 0.1 left 0.1; "\sl A" rjust
    arrow <- from last [].B up 0.1 right 0.1; "\sl B" ljust
    arrow <- from last [].G up 0.05 right 0.15; "\sl G" ljust
    thicklines_ }')
R3: [
  arrester(,E)
  {`"\tt \ldots(,E)"' at last line.c+(0,-0.25)}
  move up_ 0.1 then right_ sep
  DE: arrester(,DE,,,fill_(0.95))
  {`"\tt \ldots(,DE,{,},"' wid 61bp__ at last [].A+(-0.1,-0.40) ljust \
   `"\tt fill\_(0.95))"' ljust }
  Dlabels
# move down_ 0.1 then right_ sep*3
  move right_ sep*3
  arrester(,DS)
  {`"\tt \ldots(,DS)"' at last [].s+(0,-0.1)}
  Dlabels
  move sep*3
  DEL: arrester(,DEL)
  {`"\tt \ldots(,DEL)"' at last [].s+(0,-0.1)}
  Dlabels
  move sep*3
  DSL: arrester(up_ dimen_,DSL)
  {`"\tt \ldots(up\_ dimen\_,DSL)"' at last [].s+(0,-0.1)}
  { thinlines_
    arrow <- from DSL.A up 0.1 left 0.1; "\sl A" rjust
    arrow <- from DSL.B down 0.1 right 0.1; "\sl B" ljust
    arrow <- from DSL.G up 0.05 left 0.15; "\sl G" rjust
    thicklines_ }
  ] with .nw at R2.sw+(0,-rsep)
[ moveht *= 0.6
  { arrester(,,:dimen_/5,:dimen_/3,shaded "red")
    `"\tt arrester(,{,}:dimen\_/5,:dimen\_/3,shaded \"red\")"' ljust }
# move down_; right_
# { arrester(,,,,shaded "red" outlined "red")
#   `"\tt arrester(,{,},{,}shaded \"red\" outlined \"red\")"' ljust }
  move down_; right_
  { S: arrester(,S,,,shaded "yellow")
    `"\tt arrester(,S,{,},shaded \"yellow\")"' ljust }
  move down_; right_
  { Gg: arrester(,g,,:dimen_/6,shaded "red")
    `"\tt arrester(,g{,},:dimen\_/6,shaded \"red\")"' ljust }
# move down_; right_
# { M: arrester(,M,,:dimen_/8,shaded "orange")
#   `"\tt arrester(,M{,},:dimen\_/8,shaded \"orange\")"' ljust }
  move down_; right_
  { C: arrester(,C,,,shaded "blue")
    `"\tt arrester(,C,{,},shaded \"blue\")"' ljust }
  ] with .nw at R3.sw+(0,-rsep)

.PE
