# The `longtwocolumn` LaTeX Package

Providing `\longtwocolumn` similar to LaTeX's `\twocolumn` but allowing the
optional argument to span several pages.

------------------------------------------------------------------------------

LaTeX package `longtwocolumn`

Copyright (c) 2013—2025 Markus Kohm

Release: 2025-07-21 v0.1

License: LPPL 1.3c (see [LICENSE](LICENSE.md))

CTAN Location: https://www.ctan.org/pkg/longtwocolumn

------------------------------------------------------------------------------

## Summary

`longtwocolumn` is the result of a question on komascript.de, which is no
longer available. It provides a command `\longtwocolumn` similar to the LaTeX
kernel command `\twocolumn`, but it allows the optional argument to span
several pages.

## Status

This is an early release of an experimental package.

## Installation

We recommend to use the package manager of your TeX distribution to install
packages. However, if you need to install `longtwocolumn` manually, you
can either use a semi-manual installation or a completely manual installation.

### Semi-manual Installation

For a semi-manual installation you can first create a local clone
of the repository:

```bash
git clone https://gitlab.com/latex9343737/packages/longtwocolumn.git
```

Then enter the directory created while cloning the repository:
```bash
cd longtwocolumn
```

Last, but not least use `l3build` to install it locally with manual and
sources:

```bash
l3build install --full
```

or without manual and sources:

```bash
l3build install
```

### Completely Manual Installation

To do a completely manual installation, download `longtwocolumn.dtx`.
Then extract it using:

```bash
tex longtwocolumn.dtx
```

To create the manual use:

```bash
pdflatex longtwocolumn-example.tex
pdflatex longtwocolumn.dtx
mkindex longtwocolumn
pdflatex longtwocolumn.dtx
mkindex longtwocolumn
pdflatex longtwocolumn.dtx
```

Now, you can either install it in the proper directory (see the
documentation of your TeX distribution) or copy `longtwocolumn.sty`
to your document directory.

# How to Report Issues

If you think you have found a bug (or another kind of issue) using
`longtwocolumn` you should use [the issue
tracker](https://gitlab.com/latex9343737/packages/longtwocolumn/-/issues). 
Please first search for similar issues already reported and maybe also already
solved and closed. Maybe the replies to such similar reports would help you
too.

If your issue is new, you should report it also isung [the issue
tracker](https://gitlab.com/latex9343737/packages/longtwocolumn/-/issues). Please
be kind, not only when writing the report but also when reading replies and
commenting or answering. And please always add a minimal working example and
usually the relevant parts of the `log`-file to your report. Please use the
[markdown for
code](https://docs.gitlab.com/user/markdown/#code-spans-and-blocks)
to add such files into the text of your report. The correct language
identifier for LaTeX code would be `latex`. For `log`-files you won't need any
language identifier. Usually you should not use attachments for code or
`log`-files unless you've been asked to do so. And please note, reports should
always be self-containing. External links often break and so the report become
useles.

# How to Say Thank You for my Work

Hey, I'm doing this as a hobby. So no need to say thank you. But I'm a vain
fop, so I'm certainly up for a quick thank you by email. On komascript.de you
can find an [explanation of my wishes](https://komascript.de/wunschliste) if
you want to give more. If you don't understand German, just click to links at
that page.
